/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.TabSheetVariant;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@Tag(value="vaadin-tabsheet")
@NpmPackage(value="@vaadin/tabsheet", version="24.9.4")
@JsModule(value="@vaadin/tabsheet/src/vaadin-tabsheet.js")
public class TabSheet
extends Component
implements HasPrefix,
HasStyle,
HasSize,
HasSuffix,
HasThemeVariant<TabSheetVariant> {
    private Tabs tabs = new Tabs();
    private Map<Tab, Element> tabToContent = new HashMap<Tab, Element>();

    public TabSheet() {
        SlotUtils.addToSlot((HasElement)this, (String)"tabs", (Component[])new Component[]{this.tabs});
        this.addSelectedChangeListener((ComponentEventListener<SelectedChangeEvent>)(ComponentEventListener & Serializable)e -> {
            this.getElement().setProperty("selected", (double)this.tabs.getSelectedIndex());
            this.updateContent();
        });
    }

    public Tab add(String tabText, Component content) {
        return this.add(new Tab(tabText), content);
    }

    public Tab add(Component tabContent, Component content) {
        return this.add(new Tab(tabContent), content);
    }

    public Tab add(Tab tab, Component content) {
        return this.add(tab, content, -1);
    }

    public Tab add(Tab tab, Component content, int position) {
        Objects.requireNonNull(tab, "The tab to be added cannot be null");
        Objects.requireNonNull(content, "The content to be added cannot be null");
        if (content instanceof Text) {
            throw new IllegalArgumentException("Text as content is not supported. Consider wrapping the Text inside a Div.");
        }
        if (position < 0) {
            this.tabs.add(tab);
        } else {
            this.tabs.addTabAtIndex(position, tab);
        }
        if (this.tabToContent.containsKey((Object)tab)) {
            this.tabToContent.get((Object)tab).removeFromParent();
        }
        this.linkTabToContent(tab, content);
        this.tabToContent.put(tab, content.getElement());
        this.updateContent();
        return tab;
    }

    private void linkTabToContent(Tab tab, Component content) {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            String tabId = (String)((Object)tab.getId().orElse("tabsheet-tab-" + UUID.randomUUID()));
            tab.setId(tabId);
            content.getElement().setAttribute("tab", tabId);
        });
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void remove(Tab tab) {
        Objects.requireNonNull(tab, "The tab to be removed cannot be null");
        Element content = this.tabToContent.remove((Object)tab);
        content.removeFromParent();
        this.tabs.remove(tab);
    }

    public void remove(Component content) {
        Objects.requireNonNull(content, "The content of the tab to be removed cannot be null");
        if (content instanceof Text) {
            throw new IllegalArgumentException("Text as content is not supported.");
        }
        Tab tab = this.getTab(content);
        if (tab != null) {
            this.remove(tab);
        }
    }

    public void remove(int position) {
        this.remove(this.getTabAt(position));
    }

    public int getSelectedIndex() {
        return this.tabs.getSelectedIndex();
    }

    public void setSelectedIndex(int selectedIndex) {
        this.tabs.setSelectedIndex(selectedIndex);
    }

    public Tab getSelectedTab() {
        return this.tabs.getSelectedTab();
    }

    public void setSelectedTab(Tab selectedTab) {
        this.tabs.setSelectedTab(selectedTab);
    }

    public int getTabCount() {
        return this.tabs.getTabCount();
    }

    public Tab getTabAt(int position) {
        return this.tabs.getTabAt(position);
    }

    public int getIndexOf(Tab tab) {
        return this.tabs.indexOf(tab);
    }

    public Tab getTab(Component content) {
        Objects.requireNonNull(content, "The component to look for the tab cannot be null");
        return this.tabToContent.entrySet().stream().filter(entry -> ((Element)entry.getValue()).equals((Object)content.getElement())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public Component getComponent(Tab tab) {
        Objects.requireNonNull(tab, "The tab to look for the component cannot be null");
        Element tabContent = this.tabToContent.get((Object)tab);
        if (tabContent == null) {
            return null;
        }
        return tabContent.getComponent().orElse(null);
    }

    public Registration addSelectedChangeListener(ComponentEventListener<SelectedChangeEvent> listener) {
        return this.tabs.addSelectedChangeListener((ComponentEventListener<Tabs.SelectedChangeEvent>)(ComponentEventListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new SelectedChangeEvent(this, event.getPreviousTab(), event.isFromClient(), event.isInitialSelection(), (Tabs.SelectedChangeEvent)event){
            final /* synthetic */ Tabs.SelectedChangeEvent val$event;
            {
                this.val$event = selectedChangeEvent;
                super(source, previousTab, fromClient, initialSelection);
            }

            public void unregisterListener() {
                this.val$event.unregisterListener();
            }
        }));
    }

    private void updateContent() {
        for (Map.Entry<Tab, Element> entry : this.tabToContent.entrySet()) {
            Tab tab = entry.getKey();
            Element content = entry.getValue();
            if (((Object)((Object)tab)).equals((Object)this.tabs.getSelectedTab())) {
                if (content.getParent() == null) {
                    this.getElement().appendChild(new Element[]{content});
                }
                content.setEnabled(true);
                continue;
            }
            content.getNode().setEnabled(false);
        }
    }

    public static class SelectedChangeEvent
    extends ComponentEvent<TabSheet> {
        private final Tab selectedTab;
        private final Tab previousTab;
        private final boolean initialSelection;

        public SelectedChangeEvent(TabSheet source, Tab previousTab, boolean fromClient, boolean initialSelection) {
            super((Component)source, fromClient);
            this.selectedTab = source.getSelectedTab();
            this.initialSelection = initialSelection;
            this.previousTab = previousTab;
        }

        public Tab getSelectedTab() {
            return this.selectedTab;
        }

        public Tab getPreviousTab() {
            return this.previousTab;
        }

        public boolean isInitialSelection() {
            return this.initialSelection;
        }
    }
}

