/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.NUMA;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mongod
extends AbstractMongo {
    private static Logger logger = LoggerFactory.getLogger(Mongod.class);
    static final byte[] SHUTDOWN_COMMAND = new byte[]{71, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -44, 7, 0, 0, 0, 0, 0, 0, 97, 100, 109, 105, 110, 46, 36, 99, 109, 100, 0, 0, 0, 0, 0, -1, -1, -1, -1, 27, 0, 0, 0, 16, 115, 104, 117, 116, 100, 111, 119, 110, 0, 1, 0, 0, 0, 8, 102, 111, 114, 99, 101, 0, 1, 0, 5, 0, 0, 0, 0};
    public static final int SOCKET_TIMEOUT = 2000;
    public static final int CONNECT_TIMEOUT = 2000;
    public static final int BYTE_BUFFER_LENGTH = 512;
    public static final int WAITING_TIME_SHUTDOWN_IN_MS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean sendShutdown(InetAddress hostname, int port) {
        Socket s;
        boolean tryToReadErrorResponse;
        block22: {
            if (!hostname.isLoopbackAddress()) {
                logger.warn("---------------------------------------\nYour localhost ({}) is not a loopback adress\nWe can NOT send shutdown to mongod, because it is denied from remote.\n---------------------------------------\n", (Object)hostname.getHostAddress());
                return false;
            }
            tryToReadErrorResponse = false;
            s = new Socket();
            s.setSoTimeout(2000);
            s.connect(new InetSocketAddress(hostname, port), 2000);
            OutputStream outputStream = s.getOutputStream();
            outputStream.write(SHUTDOWN_COMMAND);
            outputStream.flush();
            tryToReadErrorResponse = true;
            InputStream inputStream = s.getInputStream();
            if (inputStream.read(new byte[512]) == -1) break block22;
            logger.error("Got some response, should be an error message");
            boolean bl = false;
            try {
                s.close();
                Thread.sleep(100L);
            }
            catch (InterruptedException ix) {
                logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
            }
            catch (IOException iox) {
                logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, iox});
            }
            return bl;
        }
        boolean bl = true;
        try {
            s.close();
            Thread.sleep(100L);
        }
        catch (InterruptedException ix) {
            logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
        }
        catch (IOException iox) {
            logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, iox});
        }
        return bl;
        catch (IOException iox) {
            block23: {
                boolean bl2;
                try {
                    if (!tryToReadErrorResponse) break block23;
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    try {
                        s.close();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ix) {
                        logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
                    }
                    catch (IOException iox2) {
                        logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, iox2});
                    }
                    throw throwable;
                }
                try {
                    s.close();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ix) {
                    logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
                }
                catch (IOException iox3) {
                    logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, iox3});
                }
                return bl2;
            }
            logger.warn("sendShutdown {}:{}", new Object[]{hostname, port, iox});
            try {
                s.close();
                Thread.sleep(100L);
            }
            catch (InterruptedException ix) {
                logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
            }
            catch (IOException iox4) {
                logger.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, iox4});
            }
        }
        return false;
    }

    public static int getMongodProcessId(String output, int defaultValue) {
        Pattern pattern = Pattern.compile("MongoDB starting : pid=([1234567890]+) port", 8);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String value = matcher.group(1);
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public static List<String> getCommandLine(IMongodConfig config, IExtractedFileSet files, File dbDir) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(Files.fileOf((File)files.baseDir(), (File)files.executable()).getAbsolutePath(), "--dbpath", "" + dbDir.getAbsolutePath()));
        if (config.params() != null && !config.params().isEmpty()) {
            for (Object key : config.params().keySet()) {
                ret.addAll(Arrays.asList(String.format("--setParameter", new Object[0]), String.format("%s=%s", key, config.params().get(key))));
            }
        }
        if (config.cmdOptions().auth()) {
            ret.add("--auth");
        } else {
            ret.add("--noauth");
        }
        if (config.cmdOptions().useNoPrealloc()) {
            ret.add("--noprealloc");
        }
        if (config.cmdOptions().useSmallFiles()) {
            ret.add("--smallfiles");
        }
        if (config.cmdOptions().useNoJournal()) {
            ret.add("--nojournal");
        }
        if (config.cmdOptions().master()) {
            ret.add("--master");
        }
        if (config.cmdOptions().storageEngine() != null) {
            ret.add("--storageEngine");
            ret.add(config.cmdOptions().storageEngine());
        }
        if (config.cmdOptions().isVerbose()) {
            ret.add("-v");
        }
        Mongod.applyDefaultOptions(config, ret);
        Mongod.applyNet(config.net(), ret);
        if (config.replication().getReplSetName() != null) {
            ret.add("--replSet");
            ret.add(config.replication().getReplSetName());
        }
        if (config.replication().getOplogSize() != 0) {
            ret.add("--oplogSize");
            ret.add(String.valueOf(config.replication().getOplogSize()));
        }
        if (config.isConfigServer()) {
            ret.add("--configsvr");
        }
        if (config.version().enabled(Feature.SYNC_DELAY)) {
            Mongod.applySyncDelay(ret, config.cmdOptions());
        }
        if (config.version().enabled(Feature.TEXT_SEARCH)) {
            Mongod.applyTextSearch(ret, config.cmdOptions());
        }
        return ret;
    }

    private static void applySyncDelay(List<String> ret, IMongoCmdOptions cmdOptions) {
        Integer syncDelay = cmdOptions.syncDelay();
        if (syncDelay != null) {
            ret.add("--syncdelay=" + syncDelay);
        }
    }

    private static void applyTextSearch(List<String> ret, IMongoCmdOptions cmdOptions) {
        if (cmdOptions.enableTextSearch()) {
            ret.add("--setParameter");
            ret.add("textSearchEnabled=true");
        }
    }

    public static List<String> enhanceCommandLinePlattformSpecific(Distribution distribution, List<String> commands) {
        if (NUMA.isNUMA((ISupportConfig)new SupportConfig(Command.MongoD), (Platform)distribution.getPlatform())) {
            switch (distribution.getPlatform()) {
                case Linux: {
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("numactl");
                    ret.add("--interleave=all");
                    ret.addAll(commands);
                    return ret;
                }
            }
            logger.warn("NUMA Plattform detected, but not supported.");
        }
        return commands;
    }
}

