package io.takari.graph;

import java.util.List;

public interface DependencyGraph<V> {

  V getRoot();

  Iterable<V> getDependencyNodes();

  Iterable<Dependency<V>> getDependencies();

  List<V> getTransitiveUpstream(V v);

  List<V> getDirectUpstream(V v);

  Dependency<V> addDependency(V source, V target);
}
