package io.takari.graph.dot;

/**
 * Part of a Record, may also be considered as a node as it can point or be
 * pointed with an edge
 */
public class SubRecord extends Record {
  public Rectangle rect;

  private void init(Record directParentRecord) {
    this.rootRecord = directParentRecord.rootRecord;
    Graph.addNode(this.root, this.rootRecord);
    Graph.addNode(this.root, directParentRecord);
    directParentRecord.addSubRecord(this);
  }

  /**
   * Create a SubRecord
   * @param root root of the graph
   * @param id identificator of the subRecord
   * @param directParentRecord direct Record on top of the new one
   * @throws Exception
   */
  public SubRecord(Object root, String id, Record directParentRecord) throws Exception {
    super(root, id);
    init(directParentRecord);
  }
}
