package io.takari.graph.render;

import io.takari.graph.DependencyGraph;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class D3GraphRenderer<V> implements GraphRenderer<V> {

  private final int INDENT = 2;

  public void render(DependencyGraph<V> g, OutputStream os) {
    V root = g.getRoot();
    int indent = 0;
    PrintWriter out = new PrintWriter(os);
    renderVertex(g, root, out, true, indent);
    out.flush();
  }

  private void renderVertex(DependencyGraph<V> graph, V vertex, PrintWriter writer, boolean isLast, int indent) {
    writer.print(indent(indent));
    writer.print(String.format("{ \"name\": \"%s\"", vertex));
    //
    // Get children of this vertex
    //
    List<V> edges = graph.getDirectUpstream(vertex);
    if (!edges.isEmpty()) {
      writer.println(",");
      indent += INDENT;
      writer.print(indent(indent));
      writer.println("\"children\": [");
      int i = 0;
      for (V e : edges) {
        V child = e;
        renderVertex(graph, child, writer, (i == (edges.size() - 1)), indent + INDENT);
        i++;
      }
      writer.print(indent(indent));
      writer.println("]");
      indent -= INDENT;
      writer.print(indent(indent));
    }

    if (isLast) {
      writer.println("}");
    } else {
      writer.println(" },");
    }
  }

  private String indent(int indent) {
    StringBuffer sb = new StringBuffer();
    for (int i = 0; i < indent; i++) {
      sb.append(' ');
    }
    return sb.toString();
  }
}
