package io.takari.graph.render;

import io.takari.graph.Dependency;
import io.takari.graph.DependencyGraph;
import io.takari.graph.render.DotConstants.DotGraphType;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

import org.codehaus.plexus.util.StringUtils;

public class DotGraphRenderer<V> implements GraphRenderer<V> {

  public static final String INDENT = "  ";

  private String graphName = "G";
  private DotGraphType graphType = DotGraphType.DIGRAPH;

  public void render(DependencyGraph<V> graph, OutputStream os) throws IOException {
    PrintWriter writer = new PrintWriter(os);
    String name = this.getDotSafeName(graphName);
    write(String.format("%s %s {%n", graphType.getName(), name), writer);
    //
    // Vertices
    //
    for (V vertex : graph.getDependencyNodes()) {
      String id = "" + vertex.toString();
      String label = id;
      if (StringUtils.isBlank(label)) {
        label = vertex.toString();
      }
      write(String.format("%s%s;%n", INDENT, getDotSafeName(id)), writer);
    }
    //
    // Edges
    //
    for (Dependency<V> edge : graph.getDependencies()) {
      String source = edge.getSource().toString();
      String target = edge.getTarget().toString();
      write(String.format("%s%s%s%s;%n", INDENT, getDotSafeName(source), graphType.getEdge(), getDotSafeName(target)), writer);
    }
    write("}", writer);
    writer.close();
  }

  private String getDotSafeName(String inName) {
    String name = null;
    if (StringUtils.isAlphanumeric(inName)) {
      name = inName;
    } else {
      name = "\"" + inName + "\"";
    }
    return name;
  }

  private void write(String s, PrintWriter os) throws IOException {
    os.write(s);
  }
}