package io.takari.project.generator;

import java.io.File;
import java.io.IOException;

import javax.lang.model.element.Modifier;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;

public class JavaSourceGenerator {

  public void generate(String packageName, String className, File target) throws IOException {

    if (!target.getParentFile().exists()) {
      target.getParentFile().mkdirs();
    }

    MethodSpec main = MethodSpec.methodBuilder("main") //
        .addModifiers(Modifier.PUBLIC, Modifier.STATIC) //
        .returns(void.class) //
        .addParameter(String[].class, "args") //
        .addStatement("$T.out.println($S)", System.class, "Hello from Maven!") //
        .build();

    TypeSpec clazz = TypeSpec.classBuilder(className) //
        .addModifiers(Modifier.PUBLIC, Modifier.FINAL) //
        .addMethod(main) //
        .build();

    JavaFile javaFile = JavaFile.builder(packageName, clazz).build();

    javaFile.writeTo(target);
  }
}
