package io.takari.project.generator;

import java.io.File;
import java.io.FileInputStream;

import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

import io.takari.dot.DotBaseListener;
import io.takari.dot.DotLexer;
import io.takari.dot.DotParser;
import io.takari.dot.DotParser.EdgeRHSContext;
import io.takari.dot.DotParser.Edge_stmtContext;
import io.takari.dot.DotParser.PropertyContext;
import io.takari.graph.dot.BasicNode;
import io.takari.graph.dot.Edge;
import io.takari.graph.dot.Graph;
import io.takari.graph.dot.Node;

public class ProjectGeneratorWithAntlr4 extends AbstractProjectGenerator {

  public ProjectGeneratorWithAntlr4(File dot) {
    super(dot);
  }

  @Override
  public Graph parse(File dot) throws Exception {
    ANTLRInputStream input = new ANTLRInputStream(new FileInputStream(dot));
    DotLexer lexer = new DotLexer(input);
    CommonTokenStream tokens = new CommonTokenStream(lexer);
    DotParser parser = new DotParser(tokens);
    ParserRuleContext tree = parser.graph();
    ParseTreeWalker walker = new ParseTreeWalker();
    MyListener graphProducer = new MyListener();
    walker.walk(graphProducer, tree);
    return graphProducer.getGraph();
  }

  static class MyListener extends DotBaseListener {

    Graph graph;

    public MyListener() throws Exception {
      graph = new Graph();
      // This is done in the old grammar. Seems like a hack.
      graph.removeNode(graph.genericNode);
      graph.removeNode(graph.genericRecord);
      graph.removeEdge(graph.genericEdge);
    }

    public Graph getGraph() {
      return graph;
    }


    @Override
    public void enterProperty(PropertyContext ctx) {
      String key = stripQuotes(ctx.getChild(0).getText());
      String value = stripQuotes(ctx.getChild(2).getText());
      graph.attributes().put(key, value);
    }

    String currentVertex;

    @Override
    public void enterEdge_stmt(Edge_stmtContext ctx) {
      currentVertex = ctx.getChild(0).getText();
    }

    @Override
    public void enterEdgeRHS(EdgeRHSContext ctx) {
      for (int i = 0; i < ctx.getChildCount(); i = i + 2) {
        String endText = ctx.getChild(i + 1).getText();
        try {
          String startText = currentVertex;
          Node start = new BasicNode(graph, startText);
          // This is janky having to strip this out. Antlr should do this
          if (endText.startsWith("->")) {
            endText = endText.substring(2);
          }
          Node end = new BasicNode(graph, endText);
          graph.addNode(start);
          graph.addNode(end);
          graph.addEdge(new Edge(graph, start, end));
          currentVertex = endText;
        } catch (Exception e) {
          e.printStackTrace();
        }
      }
    }

    private String stripQuotes(String s) {
      if (s.startsWith("\"")) {
        s = s.substring(1);
      }
      if (s.endsWith("\"")) {
        s = s.substring(0, s.length() - 1);
      }
      return s;
    }
  }
}
