/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.LineEnding;
import net.revelc.code.formatter.Result;
import net.revelc.code.formatter.java.JavaFormatter;
import net.revelc.code.formatter.javascript.JavascriptFormatter;
import net.revelc.code.formatter.model.ConfigReadException;
import net.revelc.code.formatter.model.ConfigReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MalformedTreeException;
import org.xml.sax.SAXException;

@Mojo(name="format", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=false)
public class FormatterMojo
extends AbstractMojo
implements ConfigurationSource {
    private static final String FILE_S = " file(s)";
    private static final String CACHE_PROPERTIES_FILENAME = "maven-java-formatter-cache.properties";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.java", "**/*.js"};
    @Component(role=ResourceManager.class)
    private ResourceManager resourceManager;
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="sourceDirectory", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", property="testSourceDirectory", required=true)
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File targetDirectory;
    @Parameter(defaultValue=".", property="project.basedir", readonly=true, required=true)
    private File basedir;
    @Parameter
    private File[] directories;
    @Parameter(property="formatter.includes")
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="1.5", property="maven.compiler.source", required=true)
    private String compilerSource;
    @Parameter(defaultValue="1.5", property="maven.compiler.source", required=true)
    private String compilerCompliance;
    @Parameter(defaultValue="1.5", property="maven.compiler.target", required=true)
    private String compilerTargetPlatform;
    @Parameter(property="project.build.sourceEncoding", required=true)
    private String encoding;
    @Parameter(defaultValue="AUTO", property="lineending", required=true)
    private LineEnding lineEnding;
    @Parameter(defaultValue="src/config/eclipse/formatter/java.xml", property="configfile", required=true)
    private String configFile;
    @Parameter(defaultValue="src/config/eclipse/formatter/javascript.xml", property="configjsfile", required=true)
    private String configJsFile;
    @Parameter(defaultValue="false", alias="skip", property="formatter.skip")
    private Boolean skipFormatting;
    private JavaFormatter javaFormatter = new JavaFormatter();
    private JavascriptFormatter jsFormatter = new JavascriptFormatter();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipFormatting.booleanValue()) {
            this.getLog().info((CharSequence)"Formatting is skipped");
            return;
        }
        long startClock = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = ReaderFactory.FILE_ENCODING;
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding (" + this.encoding + ") to format source files, i.e. build is platform dependent!"));
        } else {
            if (!Charset.isSupported(this.encoding)) {
                throw new MojoExecutionException("Encoding '" + this.encoding + "' is not supported");
            }
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' encoding to format source files."));
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            if (this.directories != null) {
                for (File directory : this.directories) {
                    if (!directory.exists() || !directory.isDirectory()) continue;
                    files.addAll(this.addCollectionFiles(directory));
                }
            } else {
                if (this.sourceDirectory != null && this.sourceDirectory.exists() && this.sourceDirectory.isDirectory()) {
                    files.addAll(this.addCollectionFiles(this.sourceDirectory));
                }
                if (this.testSourceDirectory != null && this.testSourceDirectory.exists() && this.testSourceDirectory.isDirectory()) {
                    files.addAll(this.addCollectionFiles(this.testSourceDirectory));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find files using includes/excludes", (Exception)e);
        }
        int numberOfFiles = files.size();
        Log log = this.getLog();
        log.info((CharSequence)("Number of files to be formatted: " + numberOfFiles));
        if (numberOfFiles > 0) {
            this.createCodeFormatter();
            ResultCollector rc = new ResultCollector();
            Properties hashCache = this.readFileHashCacheFile();
            String basedirPath = this.getBasedirPath();
            int n = files.size();
            for (int i = 0; i < n; ++i) {
                File file = (File)files.get(i);
                if (file.exists()) {
                    if (file.canWrite()) {
                        this.formatFile(file, rc, hashCache, basedirPath);
                        continue;
                    }
                    ++rc.readOnlyCount;
                    continue;
                }
                ++rc.failCount;
            }
            this.storeFileHashCache(hashCache);
            long endClock = System.currentTimeMillis();
            log.info((CharSequence)("Successfully formatted:          " + rc.successCount + FILE_S));
            log.info((CharSequence)("Fail to format:                  " + rc.failCount + FILE_S));
            log.info((CharSequence)("Skipped:                         " + rc.skippedCount + FILE_S));
            log.info((CharSequence)("Read only skipped:               " + rc.readOnlyCount + FILE_S));
            log.info((CharSequence)("Approximate time taken:          " + (endClock - startClock) / 1000L + "s"));
        }
    }

    List<File> addCollectionFiles(File newBasedir) throws IOException {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(newBasedir);
        if (this.includes != null && this.includes.length > 0) {
            ds.setIncludes(this.includes);
        } else {
            ds.setIncludes(DEFAULT_INCLUDES);
        }
        ds.setExcludes(this.excludes);
        ds.addDefaultExcludes();
        ds.setCaseSensitive(false);
        ds.setFollowSymlinks(false);
        ds.scan();
        ArrayList<File> foundFiles = new ArrayList<File>();
        for (String filename : ds.getIncludedFiles()) {
            foundFiles.add(new File(newBasedir, filename));
        }
        return foundFiles;
    }

    private String getBasedirPath() {
        try {
            return this.basedir.getCanonicalPath();
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"", (Throwable)e);
            return "";
        }
    }

    private void storeFileHashCache(Properties props) {
        File cacheFile = new File(this.targetDirectory, CACHE_PROPERTIES_FILENAME);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cacheFile));){
            props.store(out, null);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Cannot store file hash cache properties file", (Throwable)e);
        }
    }

    private Properties readFileHashCacheFile() {
        Properties props = new Properties();
        Log log = this.getLog();
        if (!this.targetDirectory.exists()) {
            this.targetDirectory.mkdirs();
        } else if (!this.targetDirectory.isDirectory()) {
            log.warn((CharSequence)("Something strange here as the '" + this.targetDirectory.getPath() + "' supposedly target directory is not a directory."));
            return props;
        }
        File cacheFile = new File(this.targetDirectory, CACHE_PROPERTIES_FILENAME);
        if (!cacheFile.exists()) {
            return props;
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(cacheFile));){
            props.load(stream);
        }
        catch (IOException e) {
            log.warn((CharSequence)"Cannot load file hash cache properties file", (Throwable)e);
        }
        return props;
    }

    private void formatFile(File file, ResultCollector rc, Properties hashCache, String basedirPath) throws MojoFailureException, MojoExecutionException {
        try {
            this.doFormatFile(file, rc, hashCache, basedirPath, false);
        }
        catch (IOException | BadLocationException | MalformedTreeException e) {
            ++rc.failCount;
            this.getLog().warn(e);
        }
    }

    protected void doFormatFile(File file, ResultCollector rc, Properties hashCache, String basedirPath, boolean dryRun) throws IOException, BadLocationException, MojoFailureException, MojoExecutionException {
        Log log = this.getLog();
        log.debug((CharSequence)("Processing file: " + file));
        String code = this.readFileAsString(file);
        String originalHash = this.md5hash(code);
        String canonicalPath = file.getCanonicalPath();
        String path = canonicalPath.substring(basedirPath.length());
        String cachedHash = hashCache.getProperty(path);
        if (cachedHash != null && cachedHash.equals(originalHash)) {
            ++rc.skippedCount;
            log.debug((CharSequence)"File is already formatted.");
            return;
        }
        Result result = file.getName().endsWith(".java") && this.javaFormatter.isInitialized() ? this.javaFormatter.formatFile(file, this.lineEnding, dryRun) : (file.getName().endsWith(".js") && this.jsFormatter.isInitialized() ? this.jsFormatter.formatFile(file, this.lineEnding, dryRun) : Result.SKIPPED);
        switch (result) {
            case SKIPPED: {
                ++rc.skippedCount;
                return;
            }
            case SUCCESS: {
                ++rc.successCount;
                break;
            }
            case FAIL: {
                ++rc.failCount;
                return;
            }
        }
        String formattedCode = this.readFileAsString(file);
        String formattedHash = this.md5hash(formattedCode);
        hashCache.setProperty(path, formattedHash);
        if (originalHash.equals(formattedHash)) {
            ++rc.skippedCount;
            log.debug((CharSequence)"Equal hash code. Not writing result to file.");
            return;
        }
        this.writeStringToFile(formattedCode, file);
    }

    private String md5hash(String str) throws UnsupportedEncodingException {
        return Hashing.md5().hashBytes(str.getBytes(this.encoding)).toString();
    }

    private String readFileAsString(File file) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        try (BufferedReader reader = new BufferedReader(ReaderFactory.newReader((File)file, (String)this.encoding));){
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
        }
        return fileData.toString();
    }

    private void writeStringToFile(String str, File file) throws IOException {
        if (!file.exists() && file.isDirectory()) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(WriterFactory.newWriter((File)file, (String)this.encoding));){
            bw.write(str);
        }
    }

    private void createCodeFormatter() throws MojoExecutionException {
        Map<String, String> jsFormattingOptions;
        Map<String, String> javaFormattingOptions = this.getFormattingOptions(this.configFile);
        if (javaFormattingOptions != null) {
            this.javaFormatter.init(javaFormattingOptions, this);
        }
        if ((jsFormattingOptions = this.getFormattingOptions(this.configJsFile)) != null) {
            this.jsFormatter.init(jsFormattingOptions, this);
        }
        if (javaFormattingOptions == null && jsFormattingOptions == null) {
            throw new MojoExecutionException("You must provide a Java or Javascript configuration file.");
        }
    }

    private Map<String, String> getFormattingOptions(String newConfigFile) throws MojoExecutionException {
        if (newConfigFile != null) {
            return this.getOptionsFromConfigFile(newConfigFile);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.source", this.compilerSource);
        options.put("org.eclipse.jdt.core.compiler.compliance", this.compilerCompliance);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.compilerTargetPlatform);
        return options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getOptionsFromConfigFile(String newConfigFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Using search path at: " + this.basedir.getAbsolutePath()));
        this.resourceManager.addSearchPath("file", this.basedir.getAbsolutePath());
        try (InputStream configInput = this.resourceManager.getResourceAsInputStream(newConfigFile);){
            Map<String, String> map = new ConfigReader().read(configInput);
            return map;
        }
        catch (ResourceNotFoundException e) {
            this.getLog().debug((CharSequence)("Config file [" + newConfigFile + "] cannot be found"), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read config file [" + newConfigFile + "]", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot parse config file [" + newConfigFile + "]", (Exception)e);
        }
        catch (ConfigReadException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    @Override
    public String getCompilerSources() {
        return this.compilerSource;
    }

    @Override
    public String getCompilerCompliance() {
        return this.compilerCompliance;
    }

    @Override
    public String getCompilerCodegenTargetPlatform() {
        return this.compilerTargetPlatform;
    }

    @Override
    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public Charset getEncoding() {
        return Charset.forName(this.encoding);
    }

    class ResultCollector {
        int successCount;
        int failCount;
        int skippedCount;
        int readOnlyCount;

        ResultCollector() {
        }
    }
}

