/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class DocumentSorter
extends UnaryExpression {
    private ItemOrderComparer comparer;

    public DocumentSorter(Expression base) {
        super(base);
        int props = base.getSpecialProperties();
        this.comparer = (props & 0x10000) != 0 || (props & 0x800000) != 0 ? LocalOrderComparer.getInstance() : GlobalOrderComparer.getInstance();
    }

    public String getExpressionName() {
        return "documentSort";
    }

    public ItemOrderComparer getComparer() {
        return this.comparer;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if ((this.operand.getSpecialProperties() & 0x20000) != 0) {
            return this.operand;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        if ((this.operand.getSpecialProperties() & 0x20000) != 0) {
            return this.operand;
        }
        if (this.operand instanceof SlashExpression) {
            return visitor.getConfiguration().obtainOptimizer().makeConditionalDocumentSorter(this, (SlashExpression)this.operand);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties() | 0x20000;
    }

    public Expression copy() {
        return new DocumentSorter(this.getBaseExpression().copy());
    }

    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.operand = this.doPromotion(this.operand, offer);
        return this;
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        return this.getBaseExpression().toPattern(config, is30);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return new DocumentOrderIterator(this.operand.iterate(context), this.comparer);
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.operand.effectiveBooleanValue(context);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("sortAndDeduplicate");
        out.emitAttribute("intraDocument", this.comparer instanceof LocalOrderComparer ? "true" : "false");
        this.operand.explain(out);
        out.endElement();
    }
}

