/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chain
implements GroundedValue {
    private List<GroundedValue> children = new ArrayList<GroundedValue>();
    private List<Item> extent = null;

    public Chain(List<GroundedValue> children) {
        this.children = children;
        int size = 0;
        boolean copy = false;
        for (GroundedValue gv : children) {
            if (gv instanceof Chain) {
                if (((Chain)gv).children.size() < 30) {
                    size += ((Chain)gv).children.size();
                    copy = true;
                    continue;
                }
                ++size;
                continue;
            }
            ++size;
        }
        if (copy) {
            this.children = new ArrayList<GroundedValue>(size);
            for (GroundedValue gv : children) {
                if (gv instanceof Chain) {
                    if (((Chain)gv).children.size() < 30) {
                        this.children.addAll(((Chain)gv).children);
                        continue;
                    }
                    this.children.add(gv);
                    continue;
                }
                this.children.add(gv);
            }
        } else {
            this.children = children;
        }
    }

    @Override
    public Item head() {
        for (GroundedValue seq : this.children) {
            Item head = seq.head();
            if (head == null) continue;
            return head;
        }
        return null;
    }

    @Override
    public UnfailingIterator iterate() {
        if (this.extent != null) {
            return new ListIterator(this.extent);
        }
        return new ChainIterator();
    }

    public void append(Item item) {
        if (this.extent != null) {
            throw new IllegalStateException();
        }
        if (item != null) {
            if (item instanceof GroundedValue) {
                this.children.add((GroundedValue)((Object)item));
            } else {
                this.children.add(new One<Item>(item));
            }
        }
    }

    private void consolidate() {
        if (this.extent == null) {
            try {
                Item item;
                ArrayList<Item> content = new ArrayList<Item>();
                UnfailingIterator iter = this.iterate();
                while ((item = iter.next()) != null) {
                    content.add(item);
                }
                this.extent = content;
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public Item itemAt(int n) {
        this.consolidate();
        if (n >= 0 && n < this.extent.size()) {
            return this.extent.get(n);
        }
        return null;
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        int newEnd;
        this.consolidate();
        if (start < 0) {
            start = 0;
        } else if (start >= this.extent.size()) {
            return EmptySequence.getInstance();
        }
        int newStart = start;
        if (length == Integer.MAX_VALUE) {
            newEnd = this.extent.size();
        } else {
            if (length < 0) {
                return EmptySequence.getInstance();
            }
            newEnd = newStart + length;
            if (newEnd > this.extent.size()) {
                newEnd = this.extent.size();
            }
        }
        return new SequenceExtent(this.extent.subList(newStart, newEnd));
    }

    @Override
    public int getLength() {
        if (this.extent != null) {
            return this.extent.size();
        }
        int n = 0;
        for (GroundedValue v : this.children) {
            n += v.getLength();
        }
        return n;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public GroundedValue reduce() {
        this.consolidate();
        return SequenceExtent.makeSequenceExtent(this.extent);
    }

    private class ChainIterator
    implements UnfailingIterator,
    GroundedIterator {
        private Queue<UnfailingIterator> queue = new LinkedList<UnfailingIterator>();
        private Stack<ChainPosition> stack = new Stack();

        public ChainIterator() {
            this.stack.push(new ChainPosition(Chain.this, 0));
        }

        public Item next() {
            while (!this.queue.isEmpty()) {
                UnfailingIterator ui = this.queue.peek();
                while (ui != null) {
                    Item current = ui.next();
                    if (current != null) {
                        return current;
                    }
                    this.queue.remove();
                    ui = this.queue.peek();
                }
            }
            while (!this.stack.isEmpty()) {
                ChainPosition cp = this.stack.peek();
                if (cp.offset >= cp.chain.children.size()) {
                    this.stack.pop();
                    continue;
                }
                GroundedValue gv = (GroundedValue)cp.chain.children.get(cp.offset++);
                if (gv instanceof Chain) {
                    this.stack.push(new ChainPosition((Chain)gv, 0));
                    continue;
                }
                if (gv instanceof Item) {
                    return (Item)((Object)gv);
                }
                this.queue.offer(gv.iterate());
                return this.next();
            }
            return null;
        }

        public void close() {
        }

        public int getProperties() {
            return 1;
        }

        public GroundedValue materialize() {
            return Chain.this;
        }

        public GroundedValue getResidue() throws XPathException {
            return new SequenceExtent(this);
        }

        private class ChainPosition {
            Chain chain;
            int offset;

            public ChainPosition(Chain chain, int offset) {
                this.chain = chain;
                this.offset = offset;
            }
        }
    }
}

