/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.Debug;

public class EntityTypeUtil {
    public static boolean isType(Collection thisCollection, String typeRelation, GenericValue targetType) {
        Iterator iter = thisCollection.iterator();
        while (iter.hasNext()) {
            try {
                GenericValue related = ((GenericValue)iter.next()).getRelatedOne(typeRelation);
                if (!EntityTypeUtil.isType(related, targetType)) continue;
                return true;
            }
            catch (GenericEntityException e) {
            }
        }
        return false;
    }

    private static GenericValue getParentType(GenericValue typeValue) {
        try {
            return typeValue.getRelatedOneCache("Parent" + typeValue.getEntityName());
        }
        catch (GenericEntityException e) {
            Debug.logWarning((Throwable)((Object)e));
            return null;
        }
    }

    public static List getDescendantTypes(GenericValue typeValue) {
        ArrayList descendantTypes = new ArrayList();
        List childrenTypes = null;
        try {
            childrenTypes = typeValue.getRelatedCache("Child" + typeValue.getEntityName());
        }
        catch (GenericEntityException e) {
            Debug.logWarning((Throwable)((Object)e));
            return null;
        }
        if (childrenTypes == null) {
            return null;
        }
        descendantTypes.addAll(childrenTypes);
        Iterator childrenTypeIter = childrenTypes.iterator();
        while (childrenTypeIter.hasNext()) {
            GenericValue childType = (GenericValue)childrenTypeIter.next();
            List childTypeDescendants = EntityTypeUtil.getDescendantTypes(childType);
            if (childTypeDescendants == null) continue;
            descendantTypes.addAll(childTypeDescendants);
        }
        return descendantTypes;
    }

    public static boolean isType(GenericValue thisType, GenericValue targetType) {
        if (thisType == null) {
            return false;
        }
        if (targetType.equals(thisType)) {
            return true;
        }
        return EntityTypeUtil.isType(EntityTypeUtil.getParentType(thisType), targetType);
    }
}

