/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelIndex;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilValidate;

public class DatabaseUtil {
    public static final String module = (class$org$ofbiz$core$entity$jdbc$DatabaseUtil == null ? (class$org$ofbiz$core$entity$jdbc$DatabaseUtil = DatabaseUtil.class$("org.ofbiz.core.entity.jdbc.DatabaseUtil")) : class$org$ofbiz$core$entity$jdbc$DatabaseUtil).getName();
    protected String helperName;
    protected ModelFieldTypeReader modelFieldTypeReader;
    protected EntityConfigUtil.DatasourceInfo datasourceInfo;
    static /* synthetic */ Class class$org$ofbiz$core$entity$jdbc$DatabaseUtil;

    public DatabaseUtil(String helperName) {
        this.helperName = helperName;
        this.modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        this.datasourceInfo = EntityConfigUtil.getDatasourceInfo(helperName);
    }

    public Connection getConnection() throws SQLException, GenericEntityException {
        Connection connection = ConnectionFactory.getConnection(this.helperName);
        return connection;
    }

    public void checkDb(Map modelEntities, Collection messages, boolean addMissing) {
        ModelRelation modelRelation;
        String entMessage;
        ModelEntity entity;
        Iterator refModelEntityIter;
        String indErrMsg;
        String message;
        ModelEntity curEntity;
        Iterator eaIter;
        String message2;
        TreeSet indexTableNames;
        UtilTimer timer = new UtilTimer();
        timer.timerString("Start - Before Get Database Meta Data");
        TreeSet tableNames = this.getTableNames(messages);
        TreeSet fkTableNames = tableNames == null ? null : new TreeSet(tableNames);
        TreeSet treeSet = indexTableNames = tableNames == null ? null : new TreeSet(tableNames);
        if (tableNames == null) {
            String message3 = "Could not get table name information from the database, aborting.";
            if (messages != null) {
                messages.add(message3);
            }
            Debug.logError((String)message3, (String)module);
            return;
        }
        timer.timerString("After Get All Table Names");
        Map colInfo = this.getColumnInfo(tableNames, messages);
        if (colInfo == null) {
            String message4 = "Could not get column information from the database, aborting.";
            if (messages != null) {
                messages.add(message4);
            }
            Debug.logError((String)message4, (String)module);
            return;
        }
        timer.timerString("After Get All Column Info");
        timer.timerString("Before Individual Table/Column Check");
        ArrayList modelEntityList = new ArrayList(modelEntities.values());
        Collections.sort(modelEntityList);
        Iterator modelEntityIter = modelEntityList.iterator();
        int curEnt = 0;
        int totalEnt = modelEntityList.size();
        LinkedList<ModelEntity> entitiesAdded = new LinkedList<ModelEntity>();
        while (modelEntityIter.hasNext()) {
            String entMessage2;
            ++curEnt;
            ModelEntity entity2 = (ModelEntity)modelEntityIter.next();
            String entityName = entity2.getEntityName();
            if (entity2 instanceof ModelViewEntity) {
                entMessage2 = "(" + timer.timeSinceLast() + "ms) NOT Checking #" + curEnt + "/" + totalEnt + " View Entity " + entity2.getEntityName();
                Debug.logVerbose((String)entMessage2, (String)module);
                if (messages == null) continue;
                messages.add(entMessage2);
                continue;
            }
            entMessage2 = "(" + timer.timeSinceLast() + "ms) Checking #" + curEnt + "/" + totalEnt + " Entity " + entity2.getEntityName() + " with table " + entity2.getTableName(this.datasourceInfo);
            Debug.logVerbose((String)entMessage2, (String)module);
            if (messages != null) {
                messages.add(entMessage2);
            }
            if (tableNames.contains(entity2.getTableName(this.datasourceInfo).toUpperCase())) {
                int numCols;
                tableNames.remove(entity2.getTableName(this.datasourceInfo).toUpperCase());
                if (colInfo == null) continue;
                HashMap<String, ModelField> fieldColNames = new HashMap<String, ModelField>();
                for (int fnum = 0; fnum < entity2.getFieldsSize(); ++fnum) {
                    ModelField field = entity2.getField(fnum);
                    fieldColNames.put(field.getColName().toUpperCase(), field);
                }
                List colList = (List)colInfo.get(entity2.getTableName(this.datasourceInfo).toUpperCase());
                if (colList != null) {
                    for (numCols = 0; numCols < colList.size(); ++numCols) {
                        ColumnCheckInfo ccInfo = (ColumnCheckInfo)colList.get(numCols);
                        if (fieldColNames.containsKey(ccInfo.columnName)) {
                            ModelField field = null;
                            field = (ModelField)fieldColNames.remove(ccInfo.columnName);
                            ModelFieldType modelFieldType = this.modelFieldTypeReader.getModelFieldType(field.getType());
                            if (modelFieldType != null) {
                                String message5;
                                String typeName;
                                String fullTypeStr = modelFieldType.getSqlType();
                                int columnSize = -1;
                                int decimalDigits = -1;
                                int openParen = fullTypeStr.indexOf(40);
                                int closeParen = fullTypeStr.indexOf(41);
                                int comma = fullTypeStr.indexOf(44);
                                if (openParen > 0 && closeParen > 0 && closeParen > openParen) {
                                    String csStr;
                                    typeName = fullTypeStr.substring(0, openParen);
                                    if (comma > 0 && comma > openParen && comma < closeParen) {
                                        csStr = fullTypeStr.substring(openParen + 1, comma);
                                        try {
                                            columnSize = Integer.parseInt(csStr);
                                        }
                                        catch (NumberFormatException e) {
                                            Debug.logError((Throwable)e, (String)module);
                                        }
                                        String ddStr = fullTypeStr.substring(comma + 1, closeParen);
                                        try {
                                            decimalDigits = Integer.parseInt(ddStr);
                                        }
                                        catch (NumberFormatException e) {
                                            Debug.logError((Throwable)e, (String)module);
                                        }
                                    } else {
                                        csStr = fullTypeStr.substring(openParen + 1, closeParen);
                                        try {
                                            columnSize = Integer.parseInt(csStr);
                                        }
                                        catch (NumberFormatException e) {
                                            Debug.logError((Throwable)e, (String)module);
                                        }
                                    }
                                } else {
                                    typeName = fullTypeStr;
                                }
                                if (UtilValidate.isNotEmpty((String)modelFieldType.getSqlTypeAlias())) {
                                    typeName = modelFieldType.getSqlTypeAlias();
                                }
                                if (!ccInfo.typeName.equals(typeName.toUpperCase())) {
                                    message5 = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity2.getTableName(this.datasourceInfo) + "\" of entity \"" + entity2.getEntityName() + "\" is of type \"" + ccInfo.typeName + "\" in the database, but is defined as type \"" + typeName + "\" in the entity definition.";
                                    Debug.logError((String)message5, (String)module);
                                    if (messages != null) {
                                        messages.add(message5);
                                    }
                                }
                                if (columnSize != -1 && ccInfo.columnSize != -1 && columnSize != ccInfo.columnSize) {
                                    message5 = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity2.getTableName(this.datasourceInfo) + "\" of entity \"" + entity2.getEntityName() + "\" has a column size of \"" + ccInfo.columnSize + "\" in the database, but is defined to have a column size of \"" + columnSize + "\" in the entity definition.";
                                    Debug.logWarning((String)message5, (String)module);
                                    if (messages != null) {
                                        messages.add(message5);
                                    }
                                }
                                if (decimalDigits == -1 || decimalDigits == ccInfo.decimalDigits) continue;
                                message5 = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity2.getTableName(this.datasourceInfo) + "\" of entity \"" + entity2.getEntityName() + "\" has a decimalDigits of \"" + ccInfo.decimalDigits + "\" in the database, but is defined to have a decimalDigits of \"" + decimalDigits + "\" in the entity definition.";
                                Debug.logWarning((String)message5, (String)module);
                                if (messages == null) continue;
                                messages.add(message5);
                                continue;
                            }
                            message2 = "Column \"" + ccInfo.columnName + "\" of table \"" + entity2.getTableName(this.datasourceInfo) + "\" of entity \"" + entity2.getEntityName() + "\" has a field type name of \"" + field.getType() + "\" which is not found in the field type definitions";
                            Debug.logError((String)message2, (String)module);
                            if (messages == null) continue;
                            messages.add(message2);
                            continue;
                        }
                        String message6 = "Column \"" + ccInfo.columnName + "\" of table \"" + entity2.getTableName(this.datasourceInfo) + "\" of entity \"" + entity2.getEntityName() + "\" exists in the database but has no corresponding field";
                        Debug.logWarning((String)message6, (String)module);
                        if (messages == null) continue;
                        messages.add(message6);
                    }
                }
                if (numCols != entity2.getFieldsSize()) {
                    String message7 = "Entity \"" + entity2.getEntityName() + "\" has " + entity2.getFieldsSize() + " fields but table \"" + entity2.getTableName(this.datasourceInfo) + "\" has " + numCols + " columns.";
                    Debug.logWarning((String)message7, (String)module);
                    if (messages != null) {
                        messages.add(message7);
                    }
                }
                Iterator fcnIter = fieldColNames.keySet().iterator();
                while (fcnIter.hasNext()) {
                    String colName = (String)fcnIter.next();
                    ModelField field = (ModelField)fieldColNames.get(colName);
                    message2 = "Field \"" + field.getName() + "\" of entity \"" + entity2.getEntityName() + "\" is missing its corresponding column \"" + field.getColName() + "\"";
                    Debug.logWarning((String)message2, (String)module);
                    if (messages != null) {
                        messages.add(message2);
                    }
                    if (!addMissing) continue;
                    String errMsg = this.addColumn(entity2, field);
                    if (errMsg != null && errMsg.length() > 0) {
                        message2 = "Could not add column \"" + field.getColName() + "\" to table \"" + entity2.getTableName(this.datasourceInfo) + "\"";
                        Debug.logError((String)message2, (String)module);
                        if (messages != null) {
                            messages.add(message2);
                        }
                        Debug.logError((String)errMsg, (String)module);
                        if (messages == null) continue;
                        messages.add(errMsg);
                        continue;
                    }
                    message2 = "Added column \"" + field.getColName() + "\" to table \"" + entity2.getTableName(this.datasourceInfo) + "\"";
                    Debug.logImportant((String)message2, (String)module);
                    if (messages == null) continue;
                    messages.add(message2);
                }
                continue;
            }
            String message8 = "Entity \"" + entity2.getEntityName() + "\" has no table in the database";
            Debug.logWarning((String)message8, (String)module);
            if (messages != null) {
                messages.add(message8);
            }
            if (!addMissing) continue;
            String errMsg = this.createTable(entity2, modelEntities, false, this.datasourceInfo.usePkConstraintNames, this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.fkStyle, this.datasourceInfo.useFkInitiallyDeferred);
            if (errMsg != null && errMsg.length() > 0) {
                message8 = "Could not create table \"" + entity2.getTableName(this.datasourceInfo) + "\"";
                Debug.logError((String)message8, (String)module);
                if (messages != null) {
                    messages.add(message8);
                }
                Debug.logError((String)errMsg, (String)module);
                if (messages == null) continue;
                messages.add(errMsg);
                continue;
            }
            entitiesAdded.add(entity2);
            message8 = "Created table \"" + entity2.getTableName(this.datasourceInfo) + "\"";
            Debug.logImportant((String)message8, (String)module);
            if (messages == null) continue;
            messages.add(message8);
        }
        timer.timerString("After Individual Table/Column Check");
        Iterator tableNamesIter = tableNames.iterator();
        while (tableNamesIter != null && tableNamesIter.hasNext()) {
            String tableName = (String)tableNamesIter.next();
            String message9 = "Table named \"" + tableName + "\" exists in the database but has no corresponding entity";
            Debug.logWarning((String)message9, (String)module);
            if (messages == null) continue;
            messages.add(message9);
        }
        if (this.datasourceInfo.useFks) {
            eaIter = entitiesAdded.iterator();
            while (eaIter.hasNext()) {
                curEntity = (ModelEntity)eaIter.next();
                String errMsg = this.createForeignKeys(curEntity, modelEntities, this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.fkStyle, this.datasourceInfo.useFkInitiallyDeferred);
                if (errMsg != null && errMsg.length() > 0) {
                    message = "Could not create foreign keys for entity \"" + curEntity.getEntityName() + "\"";
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    Debug.logError((String)errMsg, (String)module);
                    if (messages == null) continue;
                    messages.add(errMsg);
                    continue;
                }
                message = "Created foreign keys for entity \"" + curEntity.getEntityName() + "\"";
                Debug.logImportant((String)message, (String)module);
                if (messages == null) continue;
                messages.add(message);
            }
        }
        if (this.datasourceInfo.useFkIndices) {
            eaIter = entitiesAdded.iterator();
            while (eaIter.hasNext()) {
                curEntity = (ModelEntity)eaIter.next();
                indErrMsg = this.createForeignKeyIndices(curEntity, this.datasourceInfo.getConstraintNameClipLength());
                if (indErrMsg != null && indErrMsg.length() > 0) {
                    message = "Could not create foreign key indices for entity \"" + curEntity.getEntityName() + "\"";
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    Debug.logError((String)indErrMsg, (String)module);
                    if (messages == null) continue;
                    messages.add(indErrMsg);
                    continue;
                }
                message = "Created foreign key indices for entity \"" + curEntity.getEntityName() + "\"";
                Debug.logImportant((String)message, (String)module);
                if (messages == null) continue;
                messages.add(message);
            }
        }
        if (this.datasourceInfo.useIndices) {
            eaIter = entitiesAdded.iterator();
            while (eaIter.hasNext()) {
                curEntity = (ModelEntity)eaIter.next();
                indErrMsg = this.createDeclaredIndices(curEntity);
                if (indErrMsg != null && indErrMsg.length() > 0) {
                    message = "Could not create declared indices for entity \"" + curEntity.getEntityName() + "\"";
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    Debug.logError((String)indErrMsg, (String)module);
                    if (messages == null) continue;
                    messages.add(indErrMsg);
                    continue;
                }
                message = "Created declared indices for entity \"" + curEntity.getEntityName() + "\"";
                Debug.logImportant((String)message, (String)module);
                if (messages == null) continue;
                messages.add(message);
            }
        }
        if (this.datasourceInfo.useFks && this.datasourceInfo.checkForeignKeysOnStart) {
            int numFksCreated = 0;
            Map refTableInfoMap = this.getReferenceInfo(fkTableNames, messages);
            if (refTableInfoMap != null) {
                refModelEntityIter = modelEntityList.iterator();
                while (refModelEntityIter.hasNext()) {
                    entity = (ModelEntity)refModelEntityIter.next();
                    String entityName = entity.getEntityName();
                    if (entity instanceof ModelViewEntity) {
                        entMessage = "NOT Checking View Entity " + entity.getEntityName();
                        Debug.logVerbose((String)entMessage, (String)module);
                        if (messages == null) continue;
                        messages.add(entMessage);
                        continue;
                    }
                    Map rcInfoMap = (Map)refTableInfoMap.get(entity.getTableName(this.datasourceInfo));
                    Iterator relations = entity.getRelationsIterator();
                    boolean createdConstraints = false;
                    while (relations.hasNext()) {
                        String message10;
                        String errMsg;
                        modelRelation = (ModelRelation)relations.next();
                        if (!"one".equals(modelRelation.getType())) continue;
                        ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
                        String relConstraintName = this.makeFkConstraintName(modelRelation, this.datasourceInfo.getConstraintNameClipLength());
                        ReferenceCheckInfo rcInfo = null;
                        if (rcInfoMap != null) {
                            rcInfo = (ReferenceCheckInfo)rcInfoMap.get(relConstraintName);
                        }
                        if (rcInfo != null) {
                            rcInfoMap.remove(relConstraintName);
                            continue;
                        }
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("No Foreign Key Constraint " + relConstraintName + " found in entity " + entityName));
                        }
                        if ((errMsg = this.createForeignKey(entity, modelRelation, relModelEntity, this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.fkStyle, this.datasourceInfo.useFkInitiallyDeferred)) != null && errMsg.length() > 0) {
                            message10 = "Could not create foreign key " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"";
                            Debug.logError((String)message10, (String)module);
                            if (messages != null) {
                                messages.add(message10);
                            }
                            Debug.logError((String)errMsg, (String)module);
                            if (messages == null) continue;
                            messages.add(errMsg);
                            continue;
                        }
                        message10 = "Created foreign key " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"";
                        Debug.logVerbose((String)message10, (String)module);
                        if (messages != null) {
                            messages.add(message10);
                        }
                        createdConstraints = true;
                        ++numFksCreated;
                    }
                    if (createdConstraints) {
                        message2 = "Created foreign key(s) for entity \"" + entity.getEntityName() + "\"";
                        Debug.logImportant((String)message2, (String)module);
                        if (messages != null) {
                            messages.add(message2);
                        }
                    }
                    if (rcInfoMap == null) continue;
                    Iterator rcInfoKeysLeft = rcInfoMap.keySet().iterator();
                    while (rcInfoKeysLeft.hasNext()) {
                        String rcKeyLeft = (String)rcInfoKeysLeft.next();
                        Debug.logImportant((String)("Unknown Foreign Key Constraint " + rcKeyLeft + " found in table " + entity.getTableName(this.datasourceInfo)));
                    }
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Created " + numFksCreated + " fk refs"));
            }
        }
        if (this.datasourceInfo.useFkIndices && this.datasourceInfo.checkFkIndicesOnStart) {
            int numIndicesCreated = 0;
            Map tableIndexListMap = this.getIndexInfo(indexTableNames, messages);
            if (tableIndexListMap != null) {
                refModelEntityIter = modelEntityList.iterator();
                while (refModelEntityIter.hasNext()) {
                    entity = (ModelEntity)refModelEntityIter.next();
                    String entityName = entity.getEntityName();
                    if (entity instanceof ModelViewEntity) {
                        entMessage = "NOT Checking View Entity " + entity.getEntityName();
                        Debug.logVerbose((String)entMessage, (String)module);
                        if (messages == null) continue;
                        messages.add(entMessage);
                        continue;
                    }
                    TreeSet tableIndexList = (TreeSet)tableIndexListMap.get(entity.getTableName(this.datasourceInfo));
                    if (tableIndexList == null) {
                        String message11;
                        String indErrMsg2 = this.createForeignKeyIndices(entity, this.datasourceInfo.getConstraintNameClipLength());
                        if (indErrMsg2 != null && indErrMsg2.length() > 0) {
                            message11 = "Could not create foreign key indices for entity \"" + entity.getEntityName() + "\"";
                            Debug.logError((String)message11, (String)module);
                            if (messages != null) {
                                messages.add(message11);
                            }
                            Debug.logError((String)indErrMsg2, (String)module);
                            if (messages != null) {
                                messages.add(indErrMsg2);
                            }
                        } else {
                            message11 = "Created foreign key indices for entity \"" + entity.getEntityName() + "\"";
                            Debug.logImportant((String)message11, (String)module);
                            if (messages != null) {
                                messages.add(message11);
                            }
                        }
                    } else {
                        boolean createdConstraints = false;
                        Iterator relations = entity.getRelationsIterator();
                        while (relations.hasNext()) {
                            String message12;
                            String errMsg;
                            modelRelation = (ModelRelation)relations.next();
                            if (!"one".equals(modelRelation.getType())) continue;
                            String relConstraintName = this.makeFkConstraintName(modelRelation, this.datasourceInfo.getConstraintNameClipLength());
                            if (tableIndexList.contains(relConstraintName)) {
                                tableIndexList.remove(relConstraintName);
                                continue;
                            }
                            if (Debug.verboseOn()) {
                                Debug.logVerbose((String)("No Index " + relConstraintName + " found for entity " + entityName));
                            }
                            if ((errMsg = this.createForeignKeyIndex(entity, modelRelation, this.datasourceInfo.getConstraintNameClipLength())) != null && errMsg.length() > 0) {
                                message12 = "Could not create foreign key index " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"";
                                Debug.logError((String)message12, (String)module);
                                if (messages != null) {
                                    messages.add(message12);
                                }
                                Debug.logError((String)errMsg, (String)module);
                                if (messages == null) continue;
                                messages.add(errMsg);
                                continue;
                            }
                            message12 = "Created foreign key index " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"";
                            Debug.logVerbose((String)message12, (String)module);
                            if (messages != null) {
                                messages.add(message12);
                            }
                            createdConstraints = true;
                            ++numIndicesCreated;
                        }
                        if (createdConstraints) {
                            message2 = "Created foreign key index/indices for entity \"" + entity.getEntityName() + "\"";
                            Debug.logImportant((String)message2, (String)module);
                            if (messages != null) {
                                messages.add(message2);
                            }
                        }
                    }
                    if (tableIndexList == null) continue;
                    Iterator tableIndexListIter = tableIndexList.iterator();
                    while (tableIndexListIter.hasNext()) {
                        String indexLeft = (String)tableIndexListIter.next();
                        Debug.logImportant((String)("Unknown Index " + indexLeft + " found in table " + entity.getTableName(this.datasourceInfo)));
                    }
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Created " + numIndicesCreated + " indices"));
            }
        }
        timer.timerString("Finished Checking Entity Database");
    }

    public List induceModelFromDb(Collection messages) {
        TreeSet tableNames = this.getTableNames(messages);
        Map colInfo = this.getColumnInfo(tableNames, messages);
        LinkedList<ModelEntity> newEntList = new LinkedList<ModelEntity>();
        Iterator tableNamesIter = new TreeSet(colInfo.keySet()).iterator();
        while (tableNamesIter.hasNext()) {
            String tableName = (String)tableNamesIter.next();
            ArrayList colList = (ArrayList)colInfo.get(tableName);
            ModelEntity newEntity = new ModelEntity(tableName, colList, this.modelFieldTypeReader);
            newEntList.add(newEntity);
        }
        return newEntList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TreeSet getTableNames(Collection messages) {
        TreeSet<String> tableNames;
        block47: {
            String message8;
            SQLException sqle8;
            String message2;
            ResultSet tableSet;
            Connection connection;
            block46: {
                connection = null;
                try {
                    connection = this.getConnection();
                }
                catch (SQLException sqle2) {
                    String message3 = "Unable to esablish a connection with the database... Error was:" + sqle2.toString();
                    Debug.logError((String)message3, (String)module);
                    if (messages != null) {
                        messages.add(message3);
                    }
                    return null;
                }
                catch (GenericEntityException e) {
                    String message4 = "Unable to esablish a connection with the database... Error was:" + e.toString();
                    Debug.logError((String)message4, (String)module);
                    if (messages != null) {
                        messages.add(message4);
                    }
                    return null;
                }
                if (connection == null) {
                    String message5 = "Unable to esablish a connection with the database, no additional information available.";
                    Debug.logError((String)message5, (String)module);
                    if (messages != null) {
                        messages.add(message5);
                    }
                    return null;
                }
                DatabaseMetaData dbData = null;
                try {
                    dbData = connection.getMetaData();
                }
                catch (SQLException sqle3) {
                    String message6 = "Unable to get database meta data... Error was:" + sqle3.toString();
                    Debug.logError((String)message6, (String)module);
                    if (messages != null) {
                        messages.add(message6);
                    }
                    return null;
                }
                if (dbData == null) {
                    Debug.logWarning((String)"Unable to get database meta data; method returned null", (String)module);
                }
                try {
                    if (Debug.infoOn()) {
                        Debug.logInfo((String)("Database Product Name is " + dbData.getDatabaseProductName()), (String)module);
                    }
                    if (Debug.infoOn()) {
                        Debug.logInfo((String)("Database Product Version is " + dbData.getDatabaseProductVersion()), (String)module);
                    }
                }
                catch (SQLException sqle4) {
                    Debug.logWarning((String)"Unable to get Database name & version information", (String)module);
                }
                try {
                    if (Debug.infoOn()) {
                        Debug.logInfo((String)("Database Driver Name is " + dbData.getDriverName()), (String)module);
                    }
                    if (Debug.infoOn()) {
                        Debug.logInfo((String)("Database Driver Version is " + dbData.getDriverVersion()), (String)module);
                    }
                }
                catch (SQLException sqle5) {
                    Debug.logWarning((String)"Unable to get Driver name & version information", (String)module);
                }
                if (Debug.infoOn()) {
                    Debug.logInfo((String)"Getting Table Info From Database");
                }
                tableNames = new TreeSet<String>();
                tableSet = null;
                try {
                    String[] types = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
                    String lookupSchemaName = null;
                    if (dbData.supportsSchemasInTableDefinitions()) {
                        lookupSchemaName = this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 ? this.datasourceInfo.getSchemaName() : dbData.getUserName();
                    }
                    if ((tableSet = dbData.getTables(null, lookupSchemaName, null, types)) == null) {
                        Debug.logWarning((String)"getTables returned null set", (String)module);
                    }
                }
                catch (SQLException sqle6) {
                    block45: {
                        String message7 = "Unable to get list of table information, let's try the create anyway... Error was:" + sqle6.toString();
                        Debug.logError((String)message7, (String)module);
                        if (messages != null) {
                            messages.add(message7);
                        }
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle2) {
                            String message22 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                            Debug.logError((String)message22, (String)module);
                            if (messages == null) break block45;
                            messages.add(message22);
                        }
                    }
                    return tableNames;
                }
                while (tableSet.next()) {
                    try {
                        String tableName = tableSet.getString("TABLE_NAME");
                        tableName = tableName == null ? null : tableName.toUpperCase();
                        tableName = this.convertToSchemaTableName(tableName, dbData);
                        String tableType = tableSet.getString("TABLE_TYPE");
                        String string = tableType = tableType == null ? null : tableType.toUpperCase();
                        if (tableType != null && !"TABLE".equals(tableType) && !"VIEW".equals(tableType) && !"ALIAS".equals(tableType) && !"SYNONYM".equals(tableType)) continue;
                        tableNames.add(tableName);
                    }
                    catch (SQLException sqle7) {
                        message2 = "Error getting table information... Error was:" + sqle7.toString();
                        Debug.logError((String)message2, (String)module);
                        if (messages == null) continue;
                        messages.add(message2);
                    }
                }
                Object var11_23 = null;
                try {
                    tableSet.close();
                }
                catch (SQLException sqle8) {
                    message8 = "Unable to close ResultSet for table list, continuing anyway... Error was:" + sqle8.toString();
                    Debug.logError((String)message8, (String)module);
                    if (messages == null) break block46;
                    messages.add(message8);
                }
            }
            try {
                connection.close();
            }
            catch (SQLException sqle8) {
                message8 = "Unable to close database connection, continuing anyway... Error was:" + sqle8.toString();
                Debug.logError((String)message8, (String)module);
                if (messages != null) {
                    messages.add(message8);
                }
                break block47;
            }
            {
                catch (SQLException sqle9) {
                    String message8;
                    block48: {
                        message2 = "Error getting next table information... Error was:" + sqle9.toString();
                        Debug.logError((String)message2, (String)module);
                        if (messages != null) {
                            messages.add(message2);
                        }
                        Object var11_24 = null;
                        try {
                            tableSet.close();
                        }
                        catch (SQLException sqle8) {
                            message8 = "Unable to close ResultSet for table list, continuing anyway... Error was:" + sqle8.toString();
                            Debug.logError((String)message8, (String)module);
                            if (messages == null) break block48;
                            messages.add(message8);
                        }
                    }
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle8) {
                        message8 = "Unable to close database connection, continuing anyway... Error was:" + sqle8.toString();
                        Debug.logError((String)message8, (String)module);
                        if (messages != null) {
                            messages.add(message8);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block50: {
                    String message8;
                    block49: {
                        Object var11_25 = null;
                        try {
                            tableSet.close();
                        }
                        catch (SQLException sqle8) {
                            message8 = "Unable to close ResultSet for table list, continuing anyway... Error was:" + sqle8.toString();
                            Debug.logError((String)message8, (String)module);
                            if (messages == null) break block49;
                            messages.add(message8);
                        }
                    }
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle8) {
                        message8 = "Unable to close database connection, continuing anyway... Error was:" + sqle8.toString();
                        Debug.logError((String)message8, (String)module);
                        if (messages == null) break block50;
                        messages.add(message8);
                    }
                }
                throw throwable;
            }
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map getColumnInfo(Set tableNames, Collection messages) {
        HashMap<String, ArrayList<ColumnCheckInfo>> colInfo;
        block32: {
            Connection connection;
            block31: {
                String message;
                if (tableNames.size() == 0) {
                    return new HashMap();
                }
                connection = null;
                try {
                    connection = this.getConnection();
                }
                catch (SQLException sqle) {
                    String message2 = "Unable to esablish a connection with the database... Error was:" + sqle.toString();
                    Debug.logError((String)message2, (String)module);
                    if (messages != null) {
                        messages.add(message2);
                    }
                    return null;
                }
                catch (GenericEntityException e) {
                    String message3 = "Unable to esablish a connection with the database... Error was:" + e.toString();
                    Debug.logError((String)message3, (String)module);
                    if (messages != null) {
                        messages.add(message3);
                    }
                    return null;
                }
                DatabaseMetaData dbData = null;
                try {
                    dbData = connection.getMetaData();
                }
                catch (SQLException sqle) {
                    block30: {
                        String message4 = "Unable to get database meta data... Error was:" + sqle.toString();
                        Debug.logError((String)message4, (String)module);
                        if (messages != null) {
                            messages.add(message4);
                        }
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle2) {
                            String message2 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                            Debug.logError((String)message2, (String)module);
                            if (messages == null) break block30;
                            messages.add(message2);
                        }
                    }
                    return null;
                }
                if (Debug.infoOn()) {
                    Debug.logInfo((String)"Getting Column Info From Database");
                }
                colInfo = new HashMap<String, ArrayList<ColumnCheckInfo>>();
                String lookupSchemaName = null;
                if (dbData.supportsSchemasInTableDefinitions()) {
                    lookupSchemaName = this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 ? this.datasourceInfo.getSchemaName() : dbData.getUserName();
                }
                ResultSet rsCols = dbData.getColumns(null, lookupSchemaName, null, null);
                while (rsCols.next()) {
                    try {
                        ColumnCheckInfo ccInfo = new ColumnCheckInfo();
                        ccInfo.tableName = rsCols.getString("TABLE_NAME");
                        ccInfo.tableName = ccInfo.tableName == null ? null : ccInfo.tableName.toUpperCase();
                        ccInfo.tableName = this.convertToSchemaTableName(ccInfo.tableName, dbData);
                        if (!tableNames.contains(ccInfo.tableName)) continue;
                        ccInfo.columnName = rsCols.getString("COLUMN_NAME");
                        ccInfo.columnName = ccInfo.columnName == null ? null : ccInfo.columnName.toUpperCase();
                        ccInfo.typeName = rsCols.getString("TYPE_NAME");
                        ccInfo.typeName = ccInfo.typeName == null ? null : ccInfo.typeName.toUpperCase();
                        ccInfo.columnSize = rsCols.getInt("COLUMN_SIZE");
                        ccInfo.decimalDigits = rsCols.getInt("DECIMAL_DIGITS");
                        ccInfo.isNullable = rsCols.getString("IS_NULLABLE");
                        ccInfo.isNullable = ccInfo.isNullable == null ? null : ccInfo.isNullable.toUpperCase();
                        ArrayList<ColumnCheckInfo> tableColInfo = (ArrayList<ColumnCheckInfo>)colInfo.get(ccInfo.tableName);
                        if (tableColInfo == null) {
                            tableColInfo = new ArrayList<ColumnCheckInfo>();
                            colInfo.put(ccInfo.tableName, tableColInfo);
                        }
                        tableColInfo.add(ccInfo);
                    }
                    catch (SQLException sqle) {
                        message = "Error getting column info for column. Error was:" + sqle.toString();
                        Debug.logError((String)message, (String)module);
                        if (messages == null) continue;
                        messages.add(message);
                    }
                }
                try {
                    rsCols.close();
                }
                catch (SQLException sqle) {
                    message = "Unable to close ResultSet for column list, continuing anyway... Error was:" + sqle.toString();
                    Debug.logError((String)message, (String)module);
                    if (messages == null) break block31;
                    messages.add(message);
                }
            }
            Object var11_22 = null;
            try {
                connection.close();
            }
            catch (SQLException sqle2) {
                String message5 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                Debug.logError((String)message5, (String)module);
                if (messages != null) {
                    messages.add(message5);
                }
                break block32;
            }
            {
                catch (SQLException sqle) {
                    String message = "Error getting column meta data for Error was:" + sqle.toString() + ". Not checking columns.";
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    Object var11_23 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle2) {
                        String message5 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                        Debug.logError((String)message5, (String)module);
                        if (messages != null) {
                            messages.add(message5);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block33: {
                    Object var11_24 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle2) {
                        String message5 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                        Debug.logError((String)message5, (String)module);
                        if (messages == null) break block33;
                        messages.add(message5);
                    }
                }
                throw throwable;
            }
        }
        return colInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map getReferenceInfo(Set tableNames, Collection messages) {
        HashMap refInfo;
        block35: {
            Connection connection;
            block34: {
                int totalFkRefs;
                block33: {
                    String message;
                    connection = null;
                    try {
                        connection = this.getConnection();
                    }
                    catch (SQLException sqle) {
                        String message2 = "Unable to esablish a connection with the database... Error was:" + sqle.toString();
                        Debug.logError((String)message2, (String)module);
                        if (messages != null) {
                            messages.add(message2);
                        }
                        return null;
                    }
                    catch (GenericEntityException e) {
                        String message3 = "Unable to esablish a connection with the database... Error was:" + e.toString();
                        Debug.logError((String)message3, (String)module);
                        if (messages != null) {
                            messages.add(message3);
                        }
                        return null;
                    }
                    DatabaseMetaData dbData = null;
                    try {
                        dbData = connection.getMetaData();
                    }
                    catch (SQLException sqle) {
                        block32: {
                            String message4 = "Unable to get database meta data... Error was:" + sqle.toString();
                            Debug.logError((String)message4, (String)module);
                            if (messages != null) {
                                messages.add(message4);
                            }
                            try {
                                connection.close();
                            }
                            catch (SQLException sqle2) {
                                String message2 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                                Debug.logError((String)message2, (String)module);
                                if (messages == null) break block32;
                                messages.add(message2);
                            }
                        }
                        return null;
                    }
                    if (Debug.infoOn()) {
                        Debug.logInfo((String)"Getting Foreign Key (Reference) Info From Database");
                    }
                    refInfo = new HashMap();
                    String lookupSchemaName = null;
                    if (dbData.supportsSchemasInTableDefinitions()) {
                        lookupSchemaName = this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 ? this.datasourceInfo.getSchemaName() : dbData.getUserName();
                    }
                    ResultSet rsCols = dbData.getImportedKeys(null, lookupSchemaName, null);
                    totalFkRefs = 0;
                    while (rsCols.next()) {
                        try {
                            HashMap<String, ReferenceCheckInfo> tableRefInfo;
                            ReferenceCheckInfo rcInfo = new ReferenceCheckInfo();
                            rcInfo.pkTableName = rsCols.getString("PKTABLE_NAME");
                            rcInfo.pkTableName = rcInfo.pkTableName == null ? null : rcInfo.pkTableName.toUpperCase();
                            rcInfo.pkColumnName = rsCols.getString("PKCOLUMN_NAME");
                            rcInfo.pkColumnName = rcInfo.pkColumnName == null ? null : rcInfo.pkColumnName.toUpperCase();
                            rcInfo.fkTableName = rsCols.getString("FKTABLE_NAME");
                            String string = rcInfo.fkTableName = rcInfo.fkTableName == null ? null : rcInfo.fkTableName.toUpperCase();
                            if (!tableNames.contains(rcInfo.fkTableName)) continue;
                            rcInfo.fkColumnName = rsCols.getString("FKCOLUMN_NAME");
                            rcInfo.fkColumnName = rcInfo.fkColumnName == null ? null : rcInfo.fkColumnName.toUpperCase();
                            rcInfo.fkName = rsCols.getString("FK_NAME");
                            String string2 = rcInfo.fkName = rcInfo.fkName == null ? null : rcInfo.fkName.toUpperCase();
                            if (Debug.verboseOn()) {
                                Debug.logVerbose((String)("Got: " + rcInfo.toString()));
                            }
                            if ((tableRefInfo = (HashMap<String, ReferenceCheckInfo>)refInfo.get(rcInfo.fkTableName)) == null) {
                                tableRefInfo = new HashMap<String, ReferenceCheckInfo>();
                                refInfo.put(rcInfo.fkTableName, tableRefInfo);
                                if (Debug.verboseOn()) {
                                    Debug.logVerbose((String)("Adding new Map for table: " + rcInfo.fkTableName));
                                }
                            }
                            if (!tableRefInfo.containsKey(rcInfo.fkName)) {
                                ++totalFkRefs;
                            }
                            tableRefInfo.put(rcInfo.fkName, rcInfo);
                        }
                        catch (SQLException sqle) {
                            message = "Error getting fk reference info for table. Error was:" + sqle.toString();
                            Debug.logError((String)message, (String)module);
                            if (messages == null) continue;
                            messages.add(message);
                        }
                    }
                    try {
                        rsCols.close();
                    }
                    catch (SQLException sqle) {
                        message = "Unable to close ResultSet for fk reference list, continuing anyway... Error was:" + sqle.toString();
                        Debug.logError((String)message, (String)module);
                        if (messages == null) break block33;
                        messages.add(message);
                    }
                }
                if (!Debug.infoOn()) break block34;
                Debug.logInfo((String)("There are " + totalFkRefs + " foreign key refs in the database"));
            }
            Object var12_23 = null;
            try {
                connection.close();
            }
            catch (SQLException sqle2) {
                String message5 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                Debug.logError((String)message5, (String)module);
                if (messages != null) {
                    messages.add(message5);
                }
                break block35;
            }
            {
                catch (SQLException sqle) {
                    String message = "Error getting fk reference meta data Error was:" + sqle.toString() + ". Not checking fk refs.";
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    refInfo = null;
                    Object var12_24 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle2) {
                        String message5 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                        Debug.logError((String)message5, (String)module);
                        if (messages != null) {
                            messages.add(message5);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block36: {
                    Object var12_25 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle2) {
                        String message5 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                        Debug.logError((String)message5, (String)module);
                        if (messages == null) break block36;
                        messages.add(message5);
                    }
                }
                throw throwable;
            }
        }
        return refInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map getIndexInfo(Set tableNames, Collection messages) {
        HashMap indexInfo;
        block36: {
            Connection connection;
            block35: {
                connection = null;
                try {
                    connection = this.getConnection();
                }
                catch (SQLException sqle) {
                    String message = "Unable to esablish a connection with the database... Error was:" + sqle.toString();
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    return null;
                }
                catch (GenericEntityException e) {
                    String message = "Unable to esablish a connection with the database... Error was:" + e.toString();
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    return null;
                }
                DatabaseMetaData dbData = null;
                try {
                    dbData = connection.getMetaData();
                }
                catch (SQLException sqle) {
                    block34: {
                        String message = "Unable to get database meta data... Error was:" + sqle.toString();
                        Debug.logError((String)message, (String)module);
                        if (messages != null) {
                            messages.add(message);
                        }
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle2) {
                            String message2 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                            Debug.logError((String)message2, (String)module);
                            if (messages == null) break block34;
                            messages.add(message2);
                        }
                    }
                    return null;
                }
                if (Debug.infoOn()) {
                    Debug.logInfo((String)"Getting Index Info From Database");
                }
                indexInfo = new HashMap();
                int totalIndices = 0;
                Iterator tableNamesIter = tableNames.iterator();
                while (tableNamesIter.hasNext()) {
                    String message;
                    String curTableName = (String)tableNamesIter.next();
                    String lookupSchemaName = null;
                    if (dbData.supportsSchemasInTableDefinitions()) {
                        lookupSchemaName = this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 ? this.datasourceInfo.getSchemaName() : dbData.getUserName();
                    }
                    ResultSet rsCols = null;
                    try {
                        rsCols = dbData.getIndexInfo(null, lookupSchemaName, curTableName, false, true);
                    }
                    catch (Exception e) {
                        Debug.logWarning((Throwable)e, (String)("Error getting index info for table: " + curTableName + " using lookupSchemaName " + lookupSchemaName));
                    }
                    while (rsCols != null && rsCols.next()) {
                        try {
                            String tableName;
                            if (rsCols.getShort("TYPE") == 0 || !rsCols.getBoolean("NON_UNIQUE") || !tableNames.contains(tableName = (tableName = rsCols.getString("TABLE_NAME")) == null ? null : tableName.toUpperCase())) continue;
                            String indexName = rsCols.getString("INDEX_NAME");
                            indexName = indexName == null ? null : indexName.toUpperCase();
                            TreeSet<String> tableIndexList = (TreeSet<String>)indexInfo.get(tableName);
                            if (tableIndexList == null) {
                                tableIndexList = new TreeSet<String>();
                                indexInfo.put(tableName, tableIndexList);
                                if (Debug.verboseOn()) {
                                    Debug.logVerbose((String)("Adding new Map for table: " + tableName));
                                }
                            }
                            if (!tableIndexList.contains(indexName)) {
                                ++totalIndices;
                            }
                            tableIndexList.add(indexName);
                        }
                        catch (SQLException sqle) {
                            message = "Error getting fk reference info for table. Error was:" + sqle.toString();
                            Debug.logError((String)message, (String)module);
                            if (messages == null) continue;
                            messages.add(message);
                        }
                    }
                    if (rsCols == null) continue;
                    try {
                        rsCols.close();
                    }
                    catch (SQLException sqle) {
                        message = "Unable to close ResultSet for fk reference list, continuing anyway... Error was:" + sqle.toString();
                        Debug.logError((String)message, (String)module);
                        if (messages == null) continue;
                        messages.add(message);
                    }
                }
                if (!Debug.infoOn()) break block35;
                Debug.logInfo((String)("There are " + totalIndices + " indices in the database"));
            }
            Object var15_27 = null;
            try {
                connection.close();
            }
            catch (SQLException sqle2) {
                String message2 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                Debug.logError((String)message2, (String)module);
                if (messages != null) {
                    messages.add(message2);
                }
                break block36;
            }
            {
                catch (SQLException sqle) {
                    String message = "Error getting fk reference meta data Error was:" + sqle.toString() + ". Not checking fk refs.";
                    Debug.logError((String)message, (String)module);
                    if (messages != null) {
                        messages.add(message);
                    }
                    indexInfo = null;
                    Object var15_28 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle2) {
                        String message2 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                        Debug.logError((String)message2, (String)module);
                        if (messages != null) {
                            messages.add(message2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block37: {
                    Object var15_29 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle2) {
                        String message2 = "Unable to close database connection, continuing anyway... Error was:" + sqle2.toString();
                        Debug.logError((String)message2, (String)module);
                        if (messages == null) break block37;
                        messages.add(message2);
                    }
                }
                throw throwable;
            }
        }
        return indexInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createTable(ModelEntity entity, Map modelEntities, boolean addFks, boolean usePkConstraintNames, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        block34: {
            if (entity == null) {
                return "ModelEntity was null and is required to create a table";
            }
            if (entity instanceof ModelViewEntity) {
                return "ERROR: Cannot create table for a view entity";
            }
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            StringBuffer sqlBuf = new StringBuffer("CREATE TABLE ");
            sqlBuf.append(entity.getTableName(this.datasourceInfo));
            sqlBuf.append(" (");
            for (int i = 0; i < entity.getFieldsSize(); ++i) {
                ModelField field = entity.getField(i);
                ModelFieldType type = this.modelFieldTypeReader.getModelFieldType(field.getType());
                if (type == null) {
                    return "Field type [" + type + "] not found for field [" + field.getName() + "] of entity [" + entity.getEntityName() + "], not creating table.";
                }
                sqlBuf.append(field.getColName());
                sqlBuf.append(" ");
                sqlBuf.append(type.getSqlType());
                if (field.getIsPk()) {
                    sqlBuf.append(" NOT NULL, ");
                    continue;
                }
                sqlBuf.append(", ");
            }
            String pkName = "PK_" + entity.getPlainTableName();
            if (pkName.length() > constraintNameClipLength) {
                pkName = pkName.substring(0, constraintNameClipLength);
            }
            if (usePkConstraintNames) {
                sqlBuf.append("CONSTRAINT ");
                sqlBuf.append(pkName);
            }
            sqlBuf.append(" PRIMARY KEY (");
            sqlBuf.append(entity.colNameString(entity.getPksCopy()));
            sqlBuf.append(")");
            if (addFks) {
                Iterator relationsIter = entity.getRelationsIterator();
                while (relationsIter.hasNext()) {
                    ModelRelation modelRelation = (ModelRelation)relationsIter.next();
                    if (!"one".equals(modelRelation.getType())) continue;
                    ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
                    if (relModelEntity == null) {
                        Debug.logError((String)("Error adding foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                        continue;
                    }
                    if (relModelEntity instanceof ModelViewEntity) {
                        Debug.logError((String)("Error adding foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                        continue;
                    }
                    sqlBuf.append(", ");
                    sqlBuf.append(this.makeFkConstraintClause(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred));
                }
            }
            sqlBuf.append(")");
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[createTable] sql=" + sqlBuf.toString()));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
            Object var16_19 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block34;
            }
            catch (SQLException sqle2) {}
            break block34;
            {
                catch (SQLException sqle) {
                    String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
                    Object var16_20 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String addColumn(ModelEntity entity, ModelField field) {
        block34: {
            if (entity == null || field == null) {
                return "ModelEntity or ModelField where null, cannot add column";
            }
            if (entity instanceof ModelViewEntity) {
                return "ERROR: Cannot add column for a view entity";
            }
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            ModelFieldType type = this.modelFieldTypeReader.getModelFieldType(field.getType());
            if (type == null) {
                return "Field type [" + type + "] not found for field [" + field.getName() + "] of entity [" + entity.getEntityName() + "], not adding column.";
            }
            StringBuffer sqlBuf = new StringBuffer("ALTER TABLE ");
            sqlBuf.append(entity.getTableName(this.datasourceInfo));
            sqlBuf.append(" ADD ");
            sqlBuf.append(field.getColName());
            sqlBuf.append(" ");
            sqlBuf.append(type.getSqlType());
            String sql = sqlBuf.toString();
            if (Debug.infoOn()) {
                Debug.logInfo((String)("[addColumn] sql=" + sql));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(sql);
            Object var13_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle3) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block34;
            }
            catch (SQLException sqle3) {}
            break block34;
            {
                catch (SQLException sqle) {
                    String sql2 = "ALTER TABLE " + entity.getTableName(this.datasourceInfo) + " ADD COLUMN " + field.getColName() + " " + type.getSqlType();
                    if (Debug.infoOn()) {
                        Debug.logInfo((String)("[addColumn] sql failed, trying sql2=" + sql2));
                    }
                    try {
                        stmt = connection.createStatement();
                        stmt.executeUpdate(sql2);
                    }
                    catch (SQLException sqle2) {
                        String string = "SQL Exception while executing the following:\n" + sql + "\nError was: " + sqle.toString();
                        Object var13_11 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException sqle3) {
                            // empty catch block
                        }
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        catch (SQLException sqle3) {
                            // empty catch block
                        }
                        return string;
                    }
                    try {
                        Object var13_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException sqle3) {
                            // empty catch block
                        }
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        catch (SQLException sqle3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle3) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle3) {}
                }
            }
        }
        return null;
    }

    public String makeFkConstraintName(ModelRelation modelRelation, int constraintNameClipLength) {
        String relConstraintName = modelRelation.getFkName();
        if (relConstraintName == null || relConstraintName.length() == 0) {
            relConstraintName = modelRelation.getTitle() + modelRelation.getRelEntityName();
            relConstraintName = relConstraintName.toUpperCase();
        }
        if (relConstraintName.length() > constraintNameClipLength) {
            relConstraintName = relConstraintName.substring(0, constraintNameClipLength);
        }
        return relConstraintName;
    }

    public String createForeignKeys(ModelEntity entity, Map modelEntities, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        if (entity == null) {
            return "ModelEntity was null and is required to create foreign keys for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create foreign keys for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType())) continue;
            ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
            if (relModelEntity == null) {
                Debug.logError((String)("Error adding foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            if (relModelEntity instanceof ModelViewEntity) {
                Debug.logError((String)("Error adding foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            String retMsg = this.createForeignKey(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createForeignKey(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        block23: {
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            StringBuffer sqlBuf = new StringBuffer("ALTER TABLE ");
            sqlBuf.append(entity.getTableName(this.datasourceInfo));
            sqlBuf.append(" ADD ");
            sqlBuf.append(this.makeFkConstraintClause(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred));
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[createForeignKey] sql=" + sqlBuf.toString()));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
            Object var13_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block23;
            }
            catch (SQLException sqle2) {}
            break block23;
            {
                catch (SQLException sqle) {
                    String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
                    Object var13_13 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    public String makeFkConstraintClause(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        String relConstraintName;
        Iterator keyMapsIter = modelRelation.getKeyMapsIterator();
        StringBuffer mainCols = new StringBuffer();
        StringBuffer relCols = new StringBuffer();
        while (keyMapsIter.hasNext()) {
            ModelKeyMap keyMap = (ModelKeyMap)keyMapsIter.next();
            ModelField mainField = entity.getField(keyMap.getFieldName());
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
            ModelField relField = relModelEntity.getField(keyMap.getRelFieldName());
            if (relCols.length() > 0) {
                relCols.append(", ");
            }
            relCols.append(relField.getColName());
        }
        StringBuffer sqlBuf = new StringBuffer("");
        if ("name_constraint".equals(fkStyle)) {
            sqlBuf.append("CONSTRAINT ");
            relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            sqlBuf.append(relConstraintName);
            sqlBuf.append(" FOREIGN KEY (");
            sqlBuf.append(mainCols.toString());
            sqlBuf.append(") REFERENCES ");
            sqlBuf.append(relModelEntity.getTableName(this.datasourceInfo));
            sqlBuf.append(" (");
            sqlBuf.append(relCols.toString());
            sqlBuf.append(")");
            if (useFkInitiallyDeferred) {
                sqlBuf.append(" INITIALLY DEFERRED");
            }
        } else if ("name_fk".equals(fkStyle)) {
            sqlBuf.append(" FOREIGN KEY ");
            relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            sqlBuf.append(relConstraintName);
            sqlBuf.append(" (");
            sqlBuf.append(mainCols.toString());
            sqlBuf.append(") REFERENCES ");
            sqlBuf.append(relModelEntity.getTableName(this.datasourceInfo));
            sqlBuf.append(" (");
            sqlBuf.append(relCols.toString());
            sqlBuf.append(")");
            if (useFkInitiallyDeferred) {
                sqlBuf.append(" INITIALLY DEFERRED");
            }
        } else {
            String emsg = "ERROR: fk-style specified for this data-source is not valid: " + fkStyle;
            Debug.logError((String)emsg);
            throw new IllegalArgumentException(emsg);
        }
        return sqlBuf.toString();
    }

    public String deleteForeignKeys(ModelEntity entity, Map modelEntities, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys for a view entity";
        }
        Iterator relationsIter = entity.getRelationsIterator();
        StringBuffer retMsgsBuffer = new StringBuffer();
        while (relationsIter.hasNext()) {
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType())) continue;
            ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
            if (relModelEntity == null) {
                Debug.logError((String)("Error removing foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            if (relModelEntity instanceof ModelViewEntity) {
                Debug.logError((String)("Error removing foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            String retMsg = this.deleteForeignKey(entity, modelRelation, relModelEntity, constraintNameClipLength);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String deleteForeignKey(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength) {
        block23: {
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            StringBuffer sqlBuf = new StringBuffer("ALTER TABLE ");
            sqlBuf.append(entity.getTableName(this.datasourceInfo));
            sqlBuf.append(" DROP CONSTRAINT ");
            sqlBuf.append(relConstraintName);
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[deleteForeignKey] sql=" + sqlBuf.toString()));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
            Object var12_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block23;
            }
            catch (SQLException sqle2) {}
            break block23;
            {
                catch (SQLException sqle) {
                    String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
                    Object var12_12 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    public String createDeclaredIndices(ModelEntity entity) {
        if (entity == null) {
            return "ModelEntity was null and is required to create declared indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create declared indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator indexesIter = entity.getIndexesIterator();
        while (indexesIter.hasNext()) {
            ModelIndex modelIndex = (ModelIndex)indexesIter.next();
            String retMsg = this.createDeclaredIndex(entity, modelIndex);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createDeclaredIndex(ModelEntity entity, ModelIndex modelIndex) {
        block23: {
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            String createIndexSql = this.makeIndexClause(entity, modelIndex);
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[createForeignKeyIndex] index sql=" + createIndexSql));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(createIndexSql);
            Object var9_8 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block23;
            }
            catch (SQLException sqle2) {}
            break block23;
            {
                catch (SQLException sqle) {
                    String string = "SQL Exception while executing the following:\n" + createIndexSql + "\nError was: " + sqle.toString();
                    Object var9_9 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    public String makeIndexClause(ModelEntity entity, ModelIndex modelIndex) {
        Iterator fieldNamesIter = modelIndex.getIndexFieldsIterator();
        StringBuffer mainCols = new StringBuffer();
        while (fieldNamesIter.hasNext()) {
            String fieldName = (String)fieldNamesIter.next();
            ModelField mainField = entity.getField(fieldName);
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
        }
        StringBuffer indexSqlBuf = new StringBuffer("CREATE ");
        if (modelIndex.getUnique()) {
            indexSqlBuf.append("UNIQUE ");
        }
        indexSqlBuf.append("INDEX ");
        indexSqlBuf.append(modelIndex.getName());
        indexSqlBuf.append(" ON ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(" (");
        indexSqlBuf.append(mainCols.toString());
        indexSqlBuf.append(")");
        return indexSqlBuf.toString();
    }

    public String deleteDeclaredIndices(ModelEntity entity) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator indexesIter = entity.getIndexesIterator();
        while (indexesIter.hasNext()) {
            ModelIndex modelIndex = (ModelIndex)indexesIter.next();
            String retMsg = this.deleteDeclaredIndex(entity, modelIndex);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String deleteDeclaredIndex(ModelEntity entity, ModelIndex modelIndex) {
        block23: {
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            StringBuffer indexSqlBuf = new StringBuffer("DROP INDEX ");
            indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
            indexSqlBuf.append(".");
            indexSqlBuf.append(modelIndex.getName());
            String deleteIndexSql = indexSqlBuf.toString();
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[deleteForeignKeyIndex] index sql=" + deleteIndexSql));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(deleteIndexSql);
            Object var10_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block23;
            }
            catch (SQLException sqle2) {}
            break block23;
            {
                catch (SQLException sqle) {
                    String string = "SQL Exception while executing the following:\n" + deleteIndexSql + "\nError was: " + sqle.toString();
                    Object var10_10 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    public String createForeignKeyIndices(ModelEntity entity, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to create foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create foreign keys indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            String retMsg;
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType()) || (retMsg = this.createForeignKeyIndex(entity, modelRelation, constraintNameClipLength)) == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createForeignKeyIndex(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        block23: {
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            String createIndexSql = this.makeFkIndexClause(entity, modelRelation, constraintNameClipLength);
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[createForeignKeyIndex] index sql=" + createIndexSql));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(createIndexSql);
            Object var10_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block23;
            }
            catch (SQLException sqle2) {}
            break block23;
            {
                catch (SQLException sqle) {
                    String string = "SQL Exception while executing the following:\n" + createIndexSql + "\nError was: " + sqle.toString();
                    Object var10_10 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    public String makeFkIndexClause(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        Iterator keyMapsIter = modelRelation.getKeyMapsIterator();
        StringBuffer mainCols = new StringBuffer();
        while (keyMapsIter.hasNext()) {
            ModelKeyMap keyMap = (ModelKeyMap)keyMapsIter.next();
            ModelField mainField = entity.getField(keyMap.getFieldName());
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
        }
        StringBuffer indexSqlBuf = new StringBuffer("CREATE INDEX ");
        String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
        indexSqlBuf.append(relConstraintName);
        indexSqlBuf.append(" ON ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(" (");
        indexSqlBuf.append(mainCols.toString());
        indexSqlBuf.append(")");
        return indexSqlBuf.toString();
    }

    public String deleteForeignKeyIndices(ModelEntity entity, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            String retMsg;
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType()) || (retMsg = this.deleteForeignKeyIndex(entity, modelRelation, constraintNameClipLength)) == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String deleteForeignKeyIndex(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        block23: {
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = this.getConnection();
            }
            catch (SQLException sqle) {
                return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
            }
            catch (GenericEntityException e) {
                return "Unable to esablish a connection with the database... Error was: " + e.toString();
            }
            StringBuffer indexSqlBuf = new StringBuffer("DROP INDEX ");
            String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
            indexSqlBuf.append(".");
            indexSqlBuf.append(relConstraintName);
            String deleteIndexSql = indexSqlBuf.toString();
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[deleteForeignKeyIndex] index sql=" + deleteIndexSql));
            }
            stmt = connection.createStatement();
            stmt.executeUpdate(deleteIndexSql);
            Object var12_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block23;
            }
            catch (SQLException sqle2) {}
            break block23;
            {
                catch (SQLException sqle) {
                    String string = "SQL Exception while executing the following:\n" + deleteIndexSql + "\nError was: " + sqle.toString();
                    Object var12_12 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    private String convertToSchemaTableName(String tableName, DatabaseMetaData dbData) throws SQLException {
        if (tableName != null && dbData.supportsSchemasInTableDefinitions() && this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 && !tableName.startsWith(this.datasourceInfo.getSchemaName())) {
            return this.datasourceInfo.getSchemaName().toUpperCase() + "." + tableName;
        }
        return tableName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ReferenceCheckInfo {
        public String pkTableName;
        public String pkColumnName;
        public String fkName;
        public String fkTableName;
        public String fkColumnName;

        public String toString() {
            return "FK Reference from table " + this.fkTableName + " called " + this.fkName + " to PK in table " + this.pkTableName;
        }
    }

    public static class ColumnCheckInfo {
        public String tableName;
        public String columnName;
        public String typeName;
        public int columnSize;
        public int decimalDigits;
        public String isNullable;
    }
}

