/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.MavenBasedPackageDependency;
import org.apache.jackrabbit.filevault.maven.packaging.ValidationHelper;
import org.apache.jackrabbit.filevault.maven.packaging.ValidatorSettings;
import org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context.DependencyResolver;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.validation.ValidationExecutorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractValidateMojo
extends AbstractMojo {
    public static final String IGNORE_GAV = "ignore";
    @Parameter(property="vault.skipValidation", defaultValue="false", required=true)
    boolean skipValidation;
    @Parameter
    private Map<String, ValidatorSettings> validatorsSettings;
    @Deprecated
    @Parameter(property="vault.failOnDependencyErrors", defaultValue="true", required=true)
    private boolean failOnDependencyErrors;
    @Parameter(property="project", readonly=true, required=false)
    protected MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=false)
    protected MavenSession session;
    @Parameter(property="vault.failOnValidationWarning", defaultValue="false")
    protected boolean failOnValidationWarnings;
    @Parameter(property="vault.dependencies")
    protected Collection<MavenBasedPackageDependency> dependencies = new LinkedList<MavenBasedPackageDependency>();
    @Parameter(property="vault.repository.structure.packages")
    protected Collection<MavenBasedPackageDependency> repositoryStructurePackages = new LinkedList<MavenBasedPackageDependency>();
    @Parameter(property="vault.package.dependency.to.maven.ga")
    protected Collection<String> mapPackageDependencyToMavenGa;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ResolutionErrorHandler resolutionErrorHandler;
    @Component
    protected BuildContext buildContext;
    protected final ValidationExecutorFactory validationExecutorFactory = new ValidationExecutorFactory(((Object)((Object)this)).getClass().getClassLoader());
    protected final ValidationHelper validationHelper = new ValidationHelper();
    protected DependencyResolver resolver;
    public static final Artifact IGNORE_ARTIFACT = new DefaultArtifact("ignore", "ignore", "1.0", "", "", "", null);

    static Map<Dependency, Artifact> resolveMap(Collection<String> mapPackageDependencyToMavenGa) {
        return mapPackageDependencyToMavenGa.stream().map(s -> s.split("=", 2)).peek(p -> {
            if (((String[])p).length != 2) {
                throw new IllegalArgumentException("Could not parse value");
            }
        }).collect(Collectors.toMap(a -> Dependency.fromString((String)a[0]), a -> {
            if (a[1].equalsIgnoreCase(IGNORE_GAV)) {
                return IGNORE_ARTIFACT;
            }
            String[] mavenGA = a[1].split(":", 2);
            if (mavenGA.length != 2) {
                throw new IllegalArgumentException("Could not parse Maven group Id and artifact Id (must be separated by ':')");
            }
            return new DefaultArtifact(mavenGA[0], mavenGA[1], "", "", "", "", null);
        }));
    }

    protected boolean shouldSkip() {
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkip()) {
            return;
        }
        if (this.skipValidation) {
            this.getLog().info((CharSequence)"Skipping validation");
            return;
        }
        this.translateLegacyParametersToValidatorParameters();
        LinkedList<PackageInfo> resolvedDependencies = new LinkedList<PackageInfo>();
        if (this.project != null) {
            this.validationHelper.clearPreviousValidationMessages(this.buildContext, this.project.getBasedir());
        }
        try {
            LinkedList<String> validRoots = new LinkedList<String>();
            for (PackageInfo packageInfo : this.getPackageInfoFromMavenBasedDependencies(this.repositoryStructurePackages)) {
                for (PathFilterSet set : packageInfo.getFilter().getFilterSets()) {
                    validRoots.add(set.getRoot());
                }
            }
            if (!validRoots.isEmpty()) {
                ValidatorSettings settings = null;
                if (this.validatorsSettings != null) {
                    settings = this.validatorsSettings.get("jackrabbit-filter");
                } else {
                    this.validatorsSettings = new HashMap<String, ValidatorSettings>();
                }
                if (settings == null) {
                    settings = new ValidatorSettings();
                    settings.addOption("validRoots", StringUtils.join(validRoots, (String)","));
                    this.validatorsSettings.put("jackrabbit-filter", settings);
                } else {
                    String oldValidRoots = settings.getOptions().get("validRoots");
                    settings.addOption("validRoots", oldValidRoots + "," + StringUtils.join(validRoots, (String)","));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not get meta information for repositoryStructurePackages '" + StringUtils.join(this.repositoryStructurePackages, (String)",") + "': " + e.getMessage(), (Exception)e);
        }
        try {
            resolvedDependencies.addAll(this.getPackageInfoFromMavenBasedDependencies(this.dependencies));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not get meta information for dependencies '" + StringUtils.join(this.dependencies, (String)",") + "': " + e.getMessage(), (Exception)e);
        }
        this.resolver = new DependencyResolver(DefaultRepositoryRequest.getRepositoryRequest((MavenSession)this.session, (MavenProject)this.project), this.repositorySystem, this.resolutionErrorHandler, AbstractValidateMojo.resolveMap(this.mapPackageDependencyToMavenGa), resolvedDependencies);
        this.doExecute();
    }

    private Collection<PackageInfo> getPackageInfoFromMavenBasedDependencies(Collection<MavenBasedPackageDependency> dependencies) throws IOException {
        LinkedList<PackageInfo> packageInfos = new LinkedList<PackageInfo>();
        MavenBasedPackageDependency.resolve(this.project, this.getLog(), dependencies);
        for (MavenBasedPackageDependency dependency : dependencies) {
            if (dependency.getInfo() == null) continue;
            packageInfos.add(dependency.getInfo());
        }
        return packageInfos;
    }

    private void translateLegacyParametersToValidatorParameters() throws MojoExecutionException {
        if (!this.failOnDependencyErrors) {
            ValidatorSettings filterValidatorSettings;
            this.getLog().warn((CharSequence)"Deprecated parameter 'failOnDependencyErrors' used.");
            if (this.validatorsSettings != null) {
                if (this.validatorsSettings.containsKey("jackrabbit-dependencies")) {
                    throw new MojoExecutionException("Can not set parameters 'failOnDependencyErrors' and 'validationSettings' for 'jackrabbit-dependencies' at the same time");
                }
            } else {
                this.validatorsSettings = new HashMap<String, ValidatorSettings>();
            }
            ValidatorSettings dependencyValidatorSettings = new ValidatorSettings(ValidationMessageSeverity.DEBUG);
            this.validatorsSettings.put("jackrabbit-dependencies", dependencyValidatorSettings);
            ValidatorSettings validatorSettings = filterValidatorSettings = this.validatorsSettings.containsKey("jackrabbit-filter") ? this.validatorsSettings.get("jackrabbit-filter") : new ValidatorSettings();
            if (filterValidatorSettings.getOptions().containsKey("severityForUncoveredAncestorNodes")) {
                throw new MojoExecutionException("Can not set parameters 'failOnDependencyErrors' and 'validationSettings' for 'jackrabbit-dependencies' with option'severityForUncoveredAncestorNodes' at the same time");
            }
            filterValidatorSettings.addOption("severityForUncoveredAncestorNodes", ValidationMessageSeverity.DEBUG.toString().toLowerCase(Locale.ROOT));
        }
    }

    protected void disableChecksOnlyWorkingForPackages() throws MojoExecutionException {
        ValidatorSettings filterValidatorSettings;
        if (this.validatorsSettings == null) {
            this.validatorsSettings = new HashMap<String, ValidatorSettings>();
        }
        if (this.validatorsSettings.containsKey("jackrabbit-filter")) {
            this.getLog().warn((CharSequence)"Overwriting settings for validator jackrabbit-filter as some checks do not work reliably for this mojo!");
            filterValidatorSettings = this.validatorsSettings.get("jackrabbit-filter");
        } else {
            filterValidatorSettings = new ValidatorSettings();
        }
        filterValidatorSettings.addOption("severityForOrphanedFilterRules", "debug");
    }

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected Map<String, ValidatorSettings> getValidatorSettingsForPackage(PackageId packageId, boolean isSubPackage) {
        return AbstractValidateMojo.getValidatorSettingsForPackage(this.getLog(), this.validatorsSettings, packageId, isSubPackage);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Map<String, ValidatorSettings> getValidatorSettingsForPackage(Log log, Map<String, ValidatorSettings> validatorsSettings, PackageId packageId, boolean isSubPackage) {
        HashMap<String, ValidatorSettings> validatorSettingsById = new HashMap<String, ValidatorSettings>();
        if (validatorsSettings == null) {
            return validatorSettingsById;
        }
        Iterator<Map.Entry<String, ValidatorSettings>> iterator = validatorsSettings.entrySet().iterator();
        while (true) {
            String validatorId;
            boolean shouldAdd;
            Map.Entry<String, ValidatorSettings> validatorSettingByIdAndPackage;
            block10: {
                if (!iterator.hasNext()) {
                    return validatorSettingsById;
                }
                validatorSettingByIdAndPackage = iterator.next();
                shouldAdd = false;
                String[] parts = validatorSettingByIdAndPackage.getKey().split(":", 3);
                validatorId = parts[0];
                if (parts.length == 2) {
                    if (parts[1].equals("subpackage")) {
                        shouldAdd = isSubPackage;
                        break block10;
                    } else {
                        log.warn((CharSequence)("Invalid validatorSettings key '" + validatorSettingByIdAndPackage.getKey() + "'"));
                        continue;
                    }
                }
                if (parts.length == 3) {
                    String group = parts[1];
                    String name = parts[2];
                    if (group != "*" && !group.equals(packageId.getGroup())) {
                        log.debug((CharSequence)("Not applying validator settings with id '" + validatorSettingByIdAndPackage.getKey() + "' as it does not match the package " + packageId));
                        continue;
                    }
                    if (!name.equals(packageId.getName())) {
                        log.debug((CharSequence)("Not applying validator settings with id '" + validatorSettingByIdAndPackage.getKey() + "' as it does not match the package " + packageId));
                        continue;
                    }
                    shouldAdd = true;
                } else {
                    shouldAdd = true;
                }
            }
            if (!shouldAdd) continue;
            validatorSettingsById.put(validatorId, validatorSettingByIdAndPackage.getValue());
        }
    }

    static final class DotContentXmlFirstComparator
    implements Comparator<String> {
        DotContentXmlFirstComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (".content.xml".equals(s1)) {
                return -1;
            }
            if (".content.xml".equals(s2)) {
                return 1;
            }
            return 0;
        }
    }
}

