/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.jcr.NoSuchWorkspaceException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.InitialContent;
import org.apache.jackrabbit.oak.OakInitializer;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.core.ContentRepositoryImpl;
import org.apache.jackrabbit.oak.management.RepositoryManager;
import org.apache.jackrabbit.oak.plugins.atomic.AtomicCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.CompositeIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexMBeanRegistration;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterMBean;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterOld;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindex;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceIndexProvider;
import org.apache.jackrabbit.oak.plugins.itemsave.ItemSaveValidatorProvider;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.name.NameValidatorProvider;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.observation.ChangeCollectorProvider;
import org.apache.jackrabbit.oak.plugins.version.VersionHook;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.stats.QueryStatsMBean;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandlers;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.descriptors.AggregatingDescriptors;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProviderAware;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.DefaultWhiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oak {
    private static final Logger LOG = LoggerFactory.getLogger(Oak.class);
    public static final String DEFAULT_WORKSPACE_NAME = "default";
    private final NodeStore store;
    private final List<RepositoryInitializer> initializers = Lists.newArrayList();
    private AnnotatedQueryEngineSettings queryEngineSettings = new AnnotatedQueryEngineSettings();
    private final List<QueryIndexProvider> queryIndexProviders = Lists.newArrayList();
    private final List<IndexEditorProvider> indexEditorProviders = Lists.newArrayList();
    private final List<CommitHook> commitHooks = Lists.newArrayList();
    private final List<Observer> observers = Lists.newArrayList();
    private List<EditorProvider> editorProviders = Lists.newArrayList();
    private CompositeConflictHandler conflictHandler;
    private SecurityProvider securityProvider;
    private ScheduledExecutorService scheduledExecutor;
    private Executor executor;
    private final Closer closer = Closer.create();
    private ContentRepository contentRepository;
    private Clusterable clusterable;
    private MBeanServer mbeanServer;
    private String defaultWorkspaceName = "default";
    private Whiteboard whiteboard = new DefaultWhiteboard(){

        public <T> Registration register(final Class<T> type, T service, Map<?, ?> properties) {
            final Registration registration = super.register(type, service, properties);
            final Closer observerSubscription = Closer.create();
            ScheduledFuture<?> future = null;
            if (type == Runnable.class) {
                Runnable runnable = (Runnable)service;
                Long period = (Long)Oak.getValue(properties, "scheduler.period", Long.class);
                if (period != null) {
                    Boolean concurrent = (Boolean)Oak.getValue(properties, "scheduler.concurrent", Boolean.class, Boolean.FALSE);
                    future = concurrent.booleanValue() ? Oak.this.getScheduledExecutor().scheduleAtFixedRate(runnable, period, period, TimeUnit.SECONDS) : Oak.this.getScheduledExecutor().scheduleWithFixedDelay(runnable, period, period, TimeUnit.SECONDS);
                }
            } else if (type == Observer.class && Oak.this.store instanceof Observable) {
                observerSubscription.register(((Observable)Oak.this.store).addObserver((Observer)service));
            }
            ObjectName objectName = null;
            Object name = properties.get("jmx.objectname");
            if (Oak.this.mbeanServer != null && name != null) {
                try {
                    objectName = name instanceof ObjectName ? (ObjectName)name : new ObjectName(String.valueOf(name));
                    if (type.getName().equals(service.getClass().getName().concat("MBean")) || service instanceof StandardMBean) {
                        Oak.this.mbeanServer.registerMBean(service, objectName);
                    } else {
                        Oak.this.mbeanServer.registerMBean(new StandardMBean(service, type), objectName);
                    }
                }
                catch (JMException e) {
                    LOG.warn("Unexpected exception while registering MBean of type [{}] against name [{}]", new Object[]{type, objectName, e});
                }
            }
            final ScheduledFuture<?> f = future;
            final ObjectName on = objectName;
            return new Registration(){

                public void unregister() {
                    if (f != null) {
                        f.cancel(false);
                    }
                    if (on != null) {
                        try {
                            Oak.this.mbeanServer.unregisterMBean(on);
                        }
                        catch (JMException e) {
                            LOG.warn("Unexpected exception while unregistering MBean of type {} against name {} ", new Object[]{type, on, e});
                        }
                    }
                    try {
                        observerSubscription.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Unexpected IOException while unsubscribing observer", (Throwable)e);
                    }
                    registration.unregister();
                }
            };
        }
    };
    private Map<String, Long> asyncTasks;
    private boolean failOnMissingIndexProvider;

    public static ScheduledExecutorService defaultScheduledExecutor() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(32, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                return thread;
            }

            private String createName() {
                return "oak-scheduled-executor-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ExecutorService defaultExecutorService() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                thread.setPriority(1);
                return thread;
            }

            private String createName() {
                return "oak-executor-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private synchronized ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Oak.defaultScheduledExecutor();
            this.closer.register((Closeable)new ExecutorCloser((ExecutorService)this.scheduledExecutor));
        }
        return this.scheduledExecutor;
    }

    private synchronized Executor getExecutor() {
        if (this.executor == null) {
            ExecutorService executorService = Oak.defaultExecutorService();
            this.executor = executorService;
            this.closer.register((Closeable)new ExecutorCloser(executorService));
        }
        return this.executor;
    }

    private static <T> T getValue(Map<?, ?> properties, String name, Class<T> type, T def) {
        Object value = properties.get(name);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return def;
    }

    private static <T> T getValue(Map<?, ?> properties, String name, Class<T> type) {
        return Oak.getValue(properties, name, type, null);
    }

    public Oak(NodeStore store) {
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
    }

    public Oak() {
        this((NodeStore)new MemoryNodeStore());
    }

    @Nonnull
    public Oak with(@Nonnull Clusterable c) {
        this.clusterable = (Clusterable)Preconditions.checkNotNull((Object)c);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull String defaultWorkspaceName) {
        this.defaultWorkspaceName = (String)Preconditions.checkNotNull((Object)defaultWorkspaceName);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull RepositoryInitializer initializer) {
        this.initializers.add((RepositoryInitializer)Preconditions.checkNotNull((Object)initializer));
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull QueryLimits settings) {
        QueryEngineSettings s = new QueryEngineSettings();
        s.setFailTraversal(settings.getFailTraversal());
        s.setFullTextComparisonWithoutIndex(settings.getFullTextComparisonWithoutIndex());
        s.setLimitInMemory(settings.getLimitInMemory());
        s.setLimitReads(settings.getLimitReads());
        this.queryEngineSettings = new AnnotatedQueryEngineSettings(s);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull QueryIndexProvider provider) {
        this.queryIndexProviders.add((QueryIndexProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull IndexEditorProvider provider) {
        this.indexEditorProviders.add((IndexEditorProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull CommitHook hook) {
        Preconditions.checkNotNull((Object)hook);
        this.withEditorHook();
        this.commitHooks.add(hook);
        return this;
    }

    private void withEditorHook() {
        if (!this.editorProviders.isEmpty()) {
            this.commitHooks.add((CommitHook)new EditorHook(CompositeEditorProvider.compose(this.editorProviders)));
            this.editorProviders = Lists.newArrayList();
        }
    }

    @Nonnull
    public Oak with(@Nonnull EditorProvider provider) {
        this.editorProviders.add((EditorProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @Nonnull
    public Oak with(final @Nonnull Editor editor) {
        Preconditions.checkNotNull((Object)editor);
        return this.with(new EditorProvider(){

            @Nonnull
            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
                return editor;
            }
        });
    }

    @Nonnull
    public Oak with(@Nonnull SecurityProvider securityProvider) {
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        if (securityProvider instanceof WhiteboardAware) {
            ((WhiteboardAware)securityProvider).setWhiteboard(this.whiteboard);
        }
        for (SecurityConfiguration sc : securityProvider.getConfigurations()) {
            RepositoryInitializer ri = sc.getRepositoryInitializer();
            if (ri != RepositoryInitializer.DEFAULT) {
                this.initializers.add(ri);
            }
            for (ThreeWayConflictHandler tch : sc.getConflictHandlers()) {
                this.with(tch);
            }
        }
        return this;
    }

    @Deprecated
    @Nonnull
    public Oak with(@Nonnull ConflictHandler conflictHandler) {
        return this.with(ConflictHandlers.wrap((PartialConflictHandler)conflictHandler));
    }

    @Nonnull
    public Oak with(@Nonnull ThreeWayConflictHandler conflictHandler) {
        Preconditions.checkNotNull((Object)conflictHandler);
        this.withEditorHook();
        if (this.conflictHandler == null) {
            if (conflictHandler instanceof CompositeConflictHandler) {
                this.conflictHandler = (CompositeConflictHandler)conflictHandler;
            } else {
                this.conflictHandler = new CompositeConflictHandler();
                this.conflictHandler.addHandler(conflictHandler);
            }
            this.commitHooks.add(new ConflictHook(conflictHandler));
        } else {
            this.conflictHandler.addHandler(conflictHandler);
        }
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutor);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull MBeanServer mbeanServer) {
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer);
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull Whiteboard whiteboard) {
        QueryEngineSettings queryEngineSettings;
        this.whiteboard = (Whiteboard)Preconditions.checkNotNull((Object)whiteboard);
        if (this.securityProvider instanceof WhiteboardAware) {
            ((WhiteboardAware)this.securityProvider).setWhiteboard(whiteboard);
        }
        if ((queryEngineSettings = (QueryEngineSettings)WhiteboardUtils.getService((Whiteboard)whiteboard, QueryEngineSettings.class)) != null) {
            this.queryEngineSettings = new AnnotatedQueryEngineSettings(queryEngineSettings);
        }
        return this;
    }

    @Nonnull
    public Oak with(@Nonnull Observer observer) {
        this.observers.add((Observer)Preconditions.checkNotNull((Object)observer));
        return this;
    }

    @Deprecated
    public Oak withAsyncIndexing() {
        return this.withAsyncIndexing("async", 5L);
    }

    public Oak withFailOnMissingIndexProvider() {
        this.failOnMissingIndexProvider = true;
        return this;
    }

    public Oak withAtomicCounter() {
        return this.with(new AtomicCounterEditorProvider(new Supplier<Clusterable>(){

            public Clusterable get() {
                return Oak.this.clusterable;
            }
        }, new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return Oak.this.scheduledExecutor;
            }
        }, new Supplier<NodeStore>(){

            public NodeStore get() {
                return Oak.this.store;
            }
        }, new Supplier<Whiteboard>(){

            public Whiteboard get() {
                return Oak.this.whiteboard;
            }
        }));
    }

    public Oak withAsyncIndexing(@Nonnull String name, long delayInSeconds) {
        if (this.asyncTasks == null) {
            this.asyncTasks = new HashMap<String, Long>();
        }
        Preconditions.checkState((delayInSeconds > 0L ? 1 : 0) != 0, (Object)"delayInSeconds value must be > 0");
        this.asyncTasks.put(AsyncIndexUpdate.checkValidName(name), delayInSeconds);
        return this;
    }

    @Nonnull
    public Whiteboard getWhiteboard() {
        return this.whiteboard;
    }

    public ContentRepository createContentRepository() {
        if (this.contentRepository == null) {
            this.contentRepository = this.createNewContentRepository();
        }
        return this.contentRepository;
    }

    private ContentRepository createNewContentRepository() {
        final RepoStateCheckHook repoStateCheckHook = new RepoStateCheckHook();
        final ArrayList regs = Lists.newArrayList();
        regs.add(this.whiteboard.register(Executor.class, (Object)this.getExecutor(), Collections.emptyMap()));
        IndexEditorProvider indexEditors = CompositeIndexEditorProvider.compose(this.indexEditorProviders);
        OakInitializer.initialize(this.store, (RepositoryInitializer)new CompositeInitializer(this.initializers), indexEditors);
        final QueryIndexProvider indexProvider = CompositeQueryIndexProvider.compose(this.queryIndexProviders);
        this.commitHooks.add(repoStateCheckHook);
        ArrayList<CommitHook> initHooks = new ArrayList<CommitHook>(this.commitHooks);
        initHooks.add((CommitHook)new EditorHook(CompositeEditorProvider.compose(this.editorProviders)));
        if (this.asyncTasks != null) {
            IndexMBeanRegistration indexRegistration = new IndexMBeanRegistration(this.whiteboard);
            regs.add(indexRegistration);
            for (Map.Entry<String, Long> t : this.asyncTasks.entrySet()) {
                AsyncIndexUpdate task = new AsyncIndexUpdate(t.getKey(), this.store, indexEditors);
                indexRegistration.registerAsyncIndexer(task, t.getValue());
                this.closer.register((Closeable)task);
            }
            PropertyIndexAsyncReindex asyncPI = new PropertyIndexAsyncReindex(new AsyncIndexUpdate("async-reindex", this.store, indexEditors, true), this.getExecutor());
            regs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, PropertyIndexAsyncReindexMBean.class, (Object)asyncPI, (String)"PropertyIndexAsyncReindex", (String)"async"));
        }
        if (NodeCounter.USE_OLD_COUNTER) {
            regs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, NodeCounterMBean.class, (Object)new NodeCounterOld(this.store), (String)"NodeCounter", (String)"nodeCounter"));
        } else {
            regs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, NodeCounterMBean.class, (Object)new NodeCounter(this.store), (String)"NodeCounter", (String)"nodeCounter"));
        }
        regs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, QueryEngineSettingsMBean.class, (Object)((Object)this.queryEngineSettings), (String)"QueryEngineSettings", (String)"settings"));
        regs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, QueryStatsMBean.class, (Object)this.queryEngineSettings.getQueryStats(), (String)"QueryStats", (String)"Oak Query Statistics (Extended)"));
        Iterable workspaceInitializers = Iterables.transform((Iterable)this.securityProvider.getConfigurations(), (Function)new Function<SecurityConfiguration, WorkspaceInitializer>(){

            public WorkspaceInitializer apply(SecurityConfiguration sc) {
                WorkspaceInitializer wi = sc.getWorkspaceInitializer();
                if (wi instanceof QueryIndexProviderAware) {
                    ((QueryIndexProviderAware)wi).setQueryIndexProvider(indexProvider);
                }
                return wi;
            }
        });
        OakInitializer.initialize(workspaceInitializers, this.store, this.defaultWorkspaceName, indexEditors);
        this.with(new IndexUpdateProvider(indexEditors, this.failOnMissingIndexProvider));
        this.withEditorHook();
        for (Observer observer : this.observers) {
            regs.add(this.whiteboard.register(Observer.class, (Object)observer, Collections.emptyMap()));
        }
        RepositoryManager repositoryManager = new RepositoryManager(this.whiteboard);
        regs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, RepositoryManagementMBean.class, (Object)((Object)repositoryManager), (String)"RepositoryManagement", (String)repositoryManager.getName()));
        CommitHook composite = CompositeHook.compose(this.commitHooks);
        regs.add(this.whiteboard.register(CommitHook.class, (Object)composite, Collections.emptyMap()));
        Tracker t = this.whiteboard.track(Descriptors.class);
        return new ContentRepositoryImpl(this.store, composite, this.defaultWorkspaceName, this.queryEngineSettings.unwrap(), indexProvider, this.securityProvider, (Descriptors)new AggregatingDescriptors(t)){

            @Override
            public void close() throws IOException {
                super.close();
                repoStateCheckHook.close();
                new CompositeRegistration(regs).unregister();
                Oak.this.closer.close();
            }
        };
    }

    public ContentSession createContentSession() {
        try {
            return this.createContentRepository().login(null, null);
        }
        catch (NoSuchWorkspaceException e) {
            throw new IllegalStateException("Default workspace not found", e);
        }
        catch (LoginException e) {
            throw new IllegalStateException("Anonymous login not allowed", e);
        }
    }

    public Root createRoot() {
        return this.createContentSession().getLatestRoot();
    }

    public static class OakDefaultComponents {
        public static final OakDefaultComponents INSTANCE = new OakDefaultComponents();
        private final Iterable<CommitHook> commitHooks = ImmutableList.of((Object)new VersionHook());
        private final Iterable<RepositoryInitializer> repositoryInitializers = ImmutableList.of((Object)new InitialContent());
        private final Iterable<EditorProvider> editorProviders = ImmutableList.of((Object)((Object)new ItemSaveValidatorProvider()), (Object)((Object)new NameValidatorProvider()), (Object)new NamespaceEditorProvider(), (Object)new TypeEditorProvider(), (Object)((Object)new ConflictValidatorProvider()), (Object)((Object)new ChangeCollectorProvider()));
        private final Iterable<IndexEditorProvider> indexEditorProviders = ImmutableList.of((Object)new ReferenceEditorProvider(), (Object)new PropertyIndexEditorProvider(), (Object)new NodeCounterEditorProvider(), (Object)new OrderedPropertyIndexEditorProvider());
        private final Iterable<QueryIndexProvider> queryIndexProviders = ImmutableList.of((Object)new ReferenceIndexProvider(), (Object)new PropertyIndexProvider(), (Object)new NodeTypeIndexProvider());
        private final SecurityProvider securityProvider = new SecurityProviderImpl();

        private OakDefaultComponents() {
        }

        public Iterable<CommitHook> commitHooks() {
            return this.commitHooks;
        }

        public Iterable<RepositoryInitializer> repositoryInitializers() {
            return this.repositoryInitializers;
        }

        public Iterable<EditorProvider> editorProviders() {
            return this.editorProviders;
        }

        public Iterable<IndexEditorProvider> indexEditorProviders() {
            return this.indexEditorProviders;
        }

        public Iterable<QueryIndexProvider> queryIndexProviders() {
            return this.queryIndexProviders;
        }

        public SecurityProvider securityProvider() {
            return this.securityProvider;
        }
    }

    private static final class AnnotatedQueryEngineSettings
    extends AnnotatedStandardMBean
    implements QueryEngineSettingsMBean {
        private final QueryEngineSettings settings;

        private AnnotatedQueryEngineSettings(QueryEngineSettings settings) {
            super(QueryEngineSettingsMBean.class);
            this.settings = settings;
        }

        private AnnotatedQueryEngineSettings() {
            this(new QueryEngineSettings());
        }

        public long getLimitInMemory() {
            return this.settings.getLimitInMemory();
        }

        public void setLimitInMemory(long limitInMemory) {
            this.settings.setLimitInMemory(limitInMemory);
        }

        public long getLimitReads() {
            return this.settings.getLimitReads();
        }

        public void setLimitReads(long limitReads) {
            this.settings.setLimitReads(limitReads);
        }

        public boolean getFailTraversal() {
            return this.settings.getFailTraversal();
        }

        public void setFailTraversal(boolean failQueriesWithoutIndex) {
            this.settings.setFailTraversal(failQueriesWithoutIndex);
        }

        public boolean isFastQuerySize() {
            return this.settings.isFastQuerySize();
        }

        public void setFastQuerySize(boolean fastQuerySize) {
            this.settings.setFastQuerySize(fastQuerySize);
        }

        public QueryStatsMBean getQueryStats() {
            return this.settings.getQueryStats();
        }

        public QueryEngineSettings unwrap() {
            return this.settings;
        }

        public String toString() {
            return this.settings.toString();
        }
    }

    private static class RepoStateCheckHook
    implements CommitHook,
    Closeable {
        private volatile boolean closed;

        private RepoStateCheckHook() {
        }

        @Nonnull
        public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
            if (this.closed) {
                throw new CommitFailedException("Oak", 2, "ContentRepository closed");
            }
            return after;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

