/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractMutableTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

final class MutableTree
extends AbstractMutableTree {
    private final MutableRoot root;
    private MutableTree parent;
    private String name;
    private NodeBuilder nodeBuilder;
    private MutableRoot.Move pendingMoves;

    MutableTree(@Nonnull MutableRoot root, @Nonnull NodeBuilder nodeBuilder, @Nonnull MutableRoot.Move pendingMoves) {
        this(root, pendingMoves, null, nodeBuilder, "");
    }

    private MutableTree(@Nonnull MutableRoot root, @Nonnull MutableRoot.Move pendingMoves, @Nullable MutableTree parent, @Nonnull NodeBuilder nodeBuilder, @Nonnull String name) {
        this.root = (MutableRoot)Preconditions.checkNotNull((Object)root);
        this.parent = parent;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.nodeBuilder = nodeBuilder;
        this.pendingMoves = (MutableRoot.Move)Preconditions.checkNotNull((Object)pendingMoves);
    }

    @Override
    @CheckForNull
    protected AbstractMutableTree getParentOrNull() {
        return this.parent;
    }

    @Override
    @Nonnull
    protected NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    @Nonnull
    protected MutableTree createChild(@Nonnull String name) throws IllegalArgumentException {
        return new MutableTree(this.root, this.pendingMoves, this, this.nodeBuilder.getChildNode((String)Preconditions.checkNotNull((Object)name)), name);
    }

    @Nonnull
    public String getName() {
        this.beforeRead();
        return this.name;
    }

    @Override
    @Nonnull
    public String getPath() {
        this.beforeRead();
        return super.getPath();
    }

    @Override
    @Nonnull
    public Tree.Status getStatus() {
        this.beforeRead();
        return super.getStatus();
    }

    @Override
    public boolean exists() {
        this.beforeRead();
        return super.exists();
    }

    @Override
    public PropertyState getProperty(@Nonnull String name) {
        this.beforeRead();
        return super.getProperty((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public boolean hasProperty(@Nonnull String name) {
        this.beforeRead();
        return super.hasProperty((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public long getPropertyCount() {
        this.beforeRead();
        return super.getPropertyCount();
    }

    @Override
    @CheckForNull
    public Tree.Status getPropertyStatus(@Nonnull String name) {
        this.beforeRead();
        return super.getPropertyStatus((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        this.beforeRead();
        return super.getProperties();
    }

    @Override
    @Nonnull
    public Tree getChild(@Nonnull String name) {
        this.beforeRead();
        return super.getChild((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public boolean hasChild(@Nonnull String name) {
        this.beforeRead();
        return super.hasChild((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public long getChildrenCount(long max) {
        this.beforeRead();
        return super.getChildrenCount(max);
    }

    @Override
    @Nonnull
    public Iterable<Tree> getChildren() {
        this.beforeRead();
        return super.getChildren();
    }

    @Override
    public boolean remove() {
        this.beforeWrite();
        boolean success = super.remove();
        if (success) {
            this.root.updated();
        }
        return success;
    }

    @Override
    @Nonnull
    public Tree addChild(@Nonnull String name) {
        MutableTree child;
        this.beforeWrite();
        if (this.hasChild(name)) {
            child = this.createChild(name);
        } else {
            child = super.addChild(name);
            this.root.updated();
        }
        return child;
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        this.beforeWrite();
        super.setOrderableChildren(enable);
    }

    @Override
    public boolean orderBefore(@Nullable String name) {
        this.beforeWrite();
        boolean success = super.orderBefore(name);
        if (success) {
            this.root.updated();
        }
        return success;
    }

    @Override
    public void setProperty(@Nonnull PropertyState property) {
        this.beforeWrite();
        super.setProperty(property);
        this.root.updated();
    }

    @Override
    public <T> void setProperty(@Nonnull String name, @Nonnull T value) {
        this.beforeWrite();
        super.setProperty(name, value);
        this.root.updated();
    }

    @Override
    public <T> void setProperty(@Nonnull String name, @Nonnull T value, @Nonnull Type<T> type) {
        this.beforeWrite();
        super.setProperty(name, value, type);
        this.root.updated();
    }

    @Override
    public void removeProperty(@Nonnull String name) {
        this.beforeWrite();
        super.removeProperty(name);
        this.root.updated();
    }

    void setParentAndName(@Nonnull MutableTree parent, @Nonnull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.parent = (MutableTree)Preconditions.checkNotNull((Object)parent);
    }

    boolean moveTo(@Nonnull MutableTree newParent, @Nonnull String newName) {
        this.name = (String)Preconditions.checkNotNull((Object)newName);
        this.parent = (MutableTree)Preconditions.checkNotNull((Object)newParent);
        boolean success = this.nodeBuilder.moveTo(newParent.nodeBuilder, newName);
        if (success) {
            this.parent.updateChildOrder(false);
            newParent.updateChildOrder(false);
        }
        return success;
    }

    @Nonnull
    MutableTree getTree(@Nonnull String path) {
        Preconditions.checkArgument((boolean)PathUtils.isAbsolute((String)((String)Preconditions.checkNotNull((Object)path))));
        this.beforeRead();
        MutableTree child = this;
        for (String name : PathUtils.elements((String)path)) {
            child = new MutableTree(this.root, this.pendingMoves, child, child.nodeBuilder.getChildNode(name), name);
        }
        return child;
    }

    @Nonnull
    String getPathInternal() {
        if (this.parent == null) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        this.buildPath(sb);
        return sb.toString();
    }

    @Override
    protected void buildPath(@Nonnull StringBuilder sb) {
        if (this.parent != null) {
            this.parent.buildPath((StringBuilder)Preconditions.checkNotNull((Object)sb));
            sb.append('/').append(this.name);
        }
    }

    private void reconnect() {
        if (this.parent != null) {
            this.parent.reconnect();
            this.nodeBuilder = this.parent.nodeBuilder.getChildNode(this.name);
        }
    }

    private void beforeRead() throws IllegalStateException {
        this.root.checkLive();
        if (this.applyPendingMoves()) {
            this.reconnect();
        }
    }

    private void beforeWrite() throws IllegalStateException {
        this.beforeRead();
        if (!super.exists()) {
            throw new IllegalStateException("This tree does not exist");
        }
    }

    private boolean applyPendingMoves() {
        boolean movesApplied = false;
        if (this.parent != null) {
            movesApplied = this.parent.applyPendingMoves();
        }
        MutableRoot.Move old = this.pendingMoves;
        this.pendingMoves = this.pendingMoves.apply(this);
        if (this.pendingMoves != old) {
            movesApplied = true;
        }
        return movesApplied;
    }
}

