/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.core.ContentSessionImpl;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class SystemRoot
extends MutableRoot {
    private static final LoginContext LOGIN_CONTEXT = new LoginContext(){

        public Subject getSubject() {
            return SystemSubject.INSTANCE;
        }

        public void login() {
        }

        public void logout() {
        }
    };

    public static SystemRoot create(@Nonnull NodeStore store, @Nonnull CommitHook hook, @Nonnull String workspaceName, @Nonnull SecurityProvider securityProvider, @Nonnull QueryIndexProvider indexProvider) {
        return SystemRoot.create(store, hook, workspaceName, securityProvider, null, indexProvider);
    }

    public static SystemRoot create(@Nonnull NodeStore store, @Nonnull CommitHook hook, @Nonnull String workspaceName, @Nonnull SecurityProvider securityProvider, @Nullable QueryEngineSettings queryEngineSettings, @Nonnull QueryIndexProvider indexProvider) {
        if (queryEngineSettings == null) {
            queryEngineSettings = new QueryEngineSettings();
        }
        return new SystemRoot(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider);
    }

    private SystemRoot(final @Nonnull NodeStore store, final @Nonnull CommitHook hook, final @Nonnull String workspaceName, final @Nonnull SecurityProvider securityProvider, final @Nonnull QueryEngineSettings queryEngineSettings, final @Nonnull QueryIndexProvider indexProvider) {
        this(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider, new ContentSessionImpl(LOGIN_CONTEXT, securityProvider, workspaceName, store, hook, queryEngineSettings, indexProvider){

            @Override
            @Nonnull
            public Root getLatestRoot() {
                return new SystemRoot(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider, this);
            }
        });
    }

    private SystemRoot(@Nonnull NodeStore store, @Nonnull CommitHook hook, @Nonnull String workspaceName, @Nonnull SecurityProvider securityProvider, @Nullable QueryEngineSettings queryEngineSettings, @Nonnull QueryIndexProvider indexProvider, @Nonnull ContentSessionImpl session) {
        super(store, hook, workspaceName, SystemSubject.INSTANCE, securityProvider, queryEngineSettings, indexProvider, session);
    }
}

