/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.cow;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.jmx.CopyOnWriteStoreMBean;
import org.apache.jackrabbit.oak.plugins.cow.BranchNodeStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class COWNodeStore
implements NodeStore,
Observable {
    private final List<Observer> observers = new CopyOnWriteArrayList<Observer>();
    private final NodeStore store;
    private volatile BranchNodeStore branchStore;

    public COWNodeStore(NodeStore store) {
        this.store = store;
    }

    public void enableCopyOnWrite() throws CommitFailedException {
        BranchNodeStore branchStore = new BranchNodeStore(this.store);
        NodeBuilder b = branchStore.getRoot().builder();
        b.setProperty(":cow", (Object)true);
        branchStore.merge(b, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        branchStore.addObserver((root, info) -> this.observers.stream().forEach(o -> o.contentChanged(root, info)));
        this.branchStore = branchStore;
    }

    public void disableCopyOnWrite() {
        BranchNodeStore branchStore = this.branchStore;
        this.branchStore = null;
        branchStore.dispose();
    }

    private NodeStore getNodeStore() {
        BranchNodeStore s = this.branchStore;
        if (s == null) {
            s = this.store;
        }
        return s;
    }

    private NodeStore getNodeStore(NodeBuilder builder) {
        if (builder.hasProperty(":cow")) {
            BranchNodeStore s = this.branchStore;
            if (s == null) {
                throw new IllegalStateException("Node store for this builder is no longer available");
            }
            return s;
        }
        return this.store;
    }

    public Closeable addObserver(Observer observer) {
        observer.contentChanged(this.getRoot(), CommitInfo.EMPTY_EXTERNAL);
        this.observers.add(observer);
        return () -> this.observers.remove(observer);
    }

    @Nonnull
    public NodeState getRoot() {
        return this.getNodeStore().getRoot();
    }

    @Nonnull
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nonnull CommitInfo info) throws CommitFailedException {
        return this.getNodeStore(builder).merge(builder, commitHook, info);
    }

    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        return this.getNodeStore(builder).rebase(builder);
    }

    public NodeState reset(@Nonnull NodeBuilder builder) {
        return this.getNodeStore(builder).reset(builder);
    }

    @Nonnull
    public Blob createBlob(InputStream inputStream) throws IOException {
        return this.getNodeStore().createBlob(inputStream);
    }

    public Blob getBlob(@Nonnull String reference) {
        return this.getNodeStore().getBlob(reference);
    }

    @Nonnull
    public String checkpoint(long lifetime, @Nonnull Map<String, String> properties) {
        return this.getNodeStore().checkpoint(lifetime, properties);
    }

    @Nonnull
    public String checkpoint(long lifetime) {
        return this.getNodeStore().checkpoint(lifetime);
    }

    @Nonnull
    public Map<String, String> checkpointInfo(@Nonnull String checkpoint) {
        return this.getNodeStore().checkpointInfo(checkpoint);
    }

    @Nonnull
    public Iterable<String> checkpoints() {
        return this.getNodeStore().checkpoints();
    }

    public NodeState retrieve(@Nonnull String checkpoint) {
        return this.getNodeStore().retrieve(checkpoint);
    }

    public boolean release(@Nonnull String checkpoint) {
        return this.getNodeStore().release(checkpoint);
    }

    class MBeanImpl
    implements CopyOnWriteStoreMBean {
        MBeanImpl() {
        }

        public String enableCopyOnWrite() {
            try {
                COWNodeStore.this.enableCopyOnWrite();
            }
            catch (CommitFailedException e) {
                return "can't enable the copy on write: " + e.getMessage();
            }
            return "success";
        }

        public String disableCopyOnWrite() {
            COWNodeStore.this.disableCopyOnWrite();
            return "success";
        }

        public String getStatus() {
            return COWNodeStore.this.branchStore == null ? "disabled" : "enabled";
        }
    }
}

