/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.identifier;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.QueryUtils;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeTypeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierManager {
    private static final Logger log = LoggerFactory.getLogger(IdentifierManager.class);
    private final Root root;
    private final EffectiveNodeTypeProvider effectiveNodeTypeProvider;

    public IdentifierManager(Root root) {
        this.root = root;
        this.effectiveNodeTypeProvider = ReadOnlyNodeTypeManager.getInstance(root, NamePathMapper.DEFAULT);
    }

    @Nonnull
    public static String generateUUID() {
        return UUIDUtils.generateUUID();
    }

    @Nonnull
    public static String generateUUID(String hint) {
        return UUIDUtils.generateUUID((String)hint);
    }

    public static boolean isValidUUID(String uuid) {
        return UUIDUtils.isValidUUID((String)uuid);
    }

    @Nonnull
    public static String getIdentifier(Tree tree) {
        PropertyState property = tree.getProperty("jcr:uuid");
        if (property != null) {
            return (String)property.getValue(Type.STRING);
        }
        if (tree.isRoot()) {
            return "/";
        }
        String parentId = IdentifierManager.getIdentifier(tree.getParent());
        return PathUtils.concat((String)parentId, (String)tree.getName());
    }

    @CheckForNull
    public Tree getTree(String identifier) {
        if (identifier.startsWith("/")) {
            return this.root.getTree(identifier);
        }
        int k = identifier.indexOf(47);
        String uuid = k == -1 ? identifier : identifier.substring(0, k);
        Preconditions.checkArgument((boolean)UUIDUtils.isValidUUID((String)uuid), (Object)("Not a valid identifier '" + identifier + '\''));
        String basePath = this.resolveUUID(uuid);
        if (basePath == null) {
            return null;
        }
        if (k == -1) {
            return this.root.getTree(basePath);
        }
        return this.root.getTree(PathUtils.concat((String)basePath, (String)identifier.substring(k + 1)));
    }

    @CheckForNull
    public String getPath(String identifier) {
        Tree tree = this.getTree(identifier);
        return tree != null && tree.exists() ? tree.getPath() : null;
    }

    @CheckForNull
    public String getPath(PropertyState referenceValue) {
        int type = referenceValue.getType().tag();
        if (type == 9 || type == 10) {
            return this.resolveUUID(referenceValue);
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @CheckForNull
    public String getPath(PropertyValue referenceValue) {
        int type = referenceValue.getType().tag();
        if (type == 9 || type == 10) {
            return this.resolveUUID(referenceValue);
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @Nonnull
    public Iterable<String> getReferences(boolean weak, @Nonnull Tree tree, @Nullable String propertyName) {
        if (!this.effectiveNodeTypeProvider.isNodeType(tree, "mix:referenceable")) {
            return Collections.emptySet();
        }
        String uuid = IdentifierManager.getIdentifier(tree);
        String reference = weak ? "WeakReference" : "Reference";
        String pName = propertyName == null ? "*" : QueryUtils.escapeForQuery((String)propertyName);
        Map<String, PropertyValue> bindings = Collections.singletonMap("uuid", PropertyValues.newString((String)uuid));
        try {
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [nt:base] WHERE PROPERTY([" + pName + "], '" + reference + "') = $uuid" + " /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            return this.findPaths(result, uuid, propertyName, weak);
        }
        catch (ParseException e) {
            log.error("query failed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Nonnull
    private Iterable<String> findPaths(final @Nonnull Result result, final @Nonnull String uuid, final @Nullable String propertyName, final boolean weak) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Iterators.concat((Iterator)Iterators.transform(result.getRows().iterator(), (Function)new RowToPaths()));
            }

            class RowToPaths
            implements Function<ResultRow, Iterator<String>> {
                RowToPaths() {
                }

                public Iterator<String> apply(ResultRow row) {
                    final String rowPath = row.getPath();
                    if (!rowPath.startsWith("/jcr:system/jcr:versionStorage")) {
                        if (propertyName == null) {
                            class PropertyToPath
                            implements Function<PropertyState, String> {
                                PropertyToPath() {
                                }

                                public String apply(PropertyState pState) {
                                    if (pState.isArray()) {
                                        Type types;
                                        Type type = types = weak ? Type.WEAKREFERENCES : Type.REFERENCES;
                                        if (pState.getType() == types) {
                                            for (String value : (Iterable)pState.getValue(Type.STRINGS)) {
                                                if (!uuid.equals(value)) continue;
                                                return PathUtils.concat((String)rowPath, (String)pState.getName());
                                            }
                                        }
                                    } else {
                                        Type type;
                                        Type type2 = type = weak ? Type.WEAKREFERENCE : Type.REFERENCE;
                                        if (pState.getType() == type && uuid.equals(pState.getValue(Type.STRING))) {
                                            return PathUtils.concat((String)rowPath, (String)pState.getName());
                                        }
                                    }
                                    return null;
                                }
                            }
                            return Iterators.filter((Iterator)Iterators.transform(IdentifierManager.this.root.getTree(rowPath).getProperties().iterator(), (Function)new PropertyToPath()), (Predicate)Predicates.notNull());
                        }
                        return Iterators.singletonIterator((Object)PathUtils.concat((String)rowPath, (String)propertyName));
                    }
                    return Iterators.emptyIterator();
                }
            }
        };
    }

    @Nonnull
    public Iterable<String> getReferences(@Nonnull Tree tree, final @Nonnull String propertyName, @Nonnull String ntName, boolean weak) {
        if (!this.effectiveNodeTypeProvider.isNodeType(tree, "mix:referenceable")) {
            return Collections.emptySet();
        }
        String uuid = IdentifierManager.getIdentifier(tree);
        String reference = weak ? "WeakReference" : "Reference";
        Map<String, PropertyValue> bindings = Collections.singletonMap("uuid", PropertyValues.newString((String)uuid));
        try {
            String escapedPropName = QueryUtils.escapeForQuery((String)propertyName);
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [" + ntName + "] WHERE PROPERTY([" + escapedPropName + "], '" + reference + "') = $uuid" + " /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            Iterable resultPaths = Iterables.transform((Iterable)result.getRows(), (Function)new Function<ResultRow, String>(){

                public String apply(ResultRow row) {
                    return PathUtils.concat((String)row.getPath(), (String)propertyName);
                }
            });
            return Iterables.filter((Iterable)resultPaths, (Predicate)new Predicate<String>(){

                public boolean apply(String path) {
                    return !path.startsWith("/jcr:system/jcr:versionStorage");
                }
            });
        }
        catch (ParseException e) {
            log.error("query failed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @CheckForNull
    public String resolveUUID(String uuid) {
        return this.resolveUUID(StringPropertyState.stringProperty((String)"", (String)uuid));
    }

    private String resolveUUID(PropertyState uuid) {
        return this.resolveUUID(PropertyValues.create((PropertyState)uuid));
    }

    private String resolveUUID(PropertyValue uuid) {
        try {
            Map<String, PropertyValue> bindings = Collections.singletonMap("id", uuid);
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [nt:base] WHERE [jcr:uuid] = $id OPTION(INDEX NAME [uuid], INDEX TAG [uuid]) /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            String path = null;
            for (ResultRow rr : result.getRows()) {
                if (path != null) {
                    log.error("multiple results for identifier lookup: " + path + " vs. " + rr.getPath());
                    return null;
                }
                path = rr.getPath();
            }
            return path;
        }
        catch (ParseException ex) {
            log.error("query failed", (Throwable)ex);
            return null;
        }
    }
}

