/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.fulltext;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ExtractedText {
    public static final ExtractedText ERROR = new ExtractedText(ExtractionResult.ERROR);
    public static final ExtractedText EMPTY = new ExtractedText(ExtractionResult.EMPTY, "");
    private final ExtractionResult extractionResult;
    private final CharSequence extractedText;

    public ExtractedText(@Nonnull ExtractionResult extractionResult) {
        this(extractionResult, null);
    }

    public ExtractedText(@Nonnull ExtractionResult extractionResult, CharSequence extractedText) {
        this.extractionResult = extractionResult;
        this.extractedText = extractedText;
        this.checkState();
    }

    @Nonnull
    public ExtractionResult getExtractionResult() {
        return this.extractionResult;
    }

    @CheckForNull
    public CharSequence getExtractedText() {
        return this.extractedText;
    }

    private void checkState() {
        if (this.extractionResult == ExtractionResult.SUCCESS) {
            Preconditions.checkNotNull((Object)this.extractedText, (Object)"extractedText must not be null for SUCCESS");
        }
    }

    public static enum ExtractionResult {
        SUCCESS,
        EMPTY,
        ERROR;

    }
}

