/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncIndexerLock;
import org.apache.jackrabbit.oak.plugins.index.importer.ClusteredLockToken;
import org.apache.jackrabbit.oak.plugins.index.importer.NodeStoreUtils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeStoreLock
implements AsyncIndexerLock<ClusteredLockToken> {
    private static final long LOCK_TIMEOUT = TimeUnit.DAYS.toMillis(100L);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final Clock clock;

    public ClusterNodeStoreLock(NodeStore nodeStore) {
        this(nodeStore, Clock.SIMPLE);
    }

    public ClusterNodeStoreLock(NodeStore nodeStore, Clock clock) {
        this.nodeStore = nodeStore;
        this.clock = clock;
    }

    @Override
    public ClusteredLockToken lock(String asyncIndexerLane) throws CommitFailedException {
        NodeBuilder builder = this.nodeStore.getRoot().builder();
        NodeBuilder async = builder.child(":async");
        String leaseName = AsyncIndexUpdate.leasify(asyncIndexerLane);
        long leaseEndTime = this.clock.getTime() + LOCK_TIMEOUT;
        if (async.hasProperty(leaseName)) {
            this.log.info("AsyncIndexer found to be running currently. Lease update would cause itscommit to fail. Such a failure should be ignored");
        }
        async.setProperty(leaseName, (Object)leaseEndTime);
        async.setProperty(ClusterNodeStoreLock.lockName(asyncIndexerLane), (Object)true);
        NodeStoreUtils.mergeWithConcurrentCheck(this.nodeStore, builder);
        this.log.info("Acquired the lock for async indexer lane [{}]", (Object)asyncIndexerLane);
        return new ClusteredLockToken(asyncIndexerLane, leaseEndTime);
    }

    @Override
    public void unlock(ClusteredLockToken token) throws CommitFailedException {
        String leaseName = AsyncIndexUpdate.leasify(token.laneName);
        NodeBuilder builder = this.nodeStore.getRoot().builder();
        NodeBuilder async = builder.child(":async");
        async.removeProperty(leaseName);
        async.removeProperty(ClusterNodeStoreLock.lockName(token.laneName));
        NodeStoreUtils.mergeWithConcurrentCheck(this.nodeStore, builder);
        this.log.info("Remove the lock for async indexer lane [{}]", (Object)token.laneName);
    }

    public boolean isLocked(String asyncIndexerLane) {
        NodeState async = this.nodeStore.getRoot().getChildNode(":async");
        String leaseName = ClusterNodeStoreLock.lockName(asyncIndexerLane);
        return async.hasProperty(leaseName);
    }

    private static String lockName(String asyncIndexerLane) {
        return asyncIndexerLane + "-lock";
    }
}

