/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.List;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfo;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexInfo;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoService;
import org.apache.jackrabbit.util.ISO8601;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InventoryPrinter.class}, property={"felix.inventory.printer.name=oak-index-stats", "felix.inventory.printer.title=Oak Index Stats", "felix.inventory.printer.format=TEXT"})
public class IndexPrinter
implements InventoryPrinter {
    @Reference
    private IndexInfoService indexInfoService;
    @Reference
    private AsyncIndexInfoService asyncIndexInfoService;

    public IndexPrinter() {
    }

    public IndexPrinter(IndexInfoService indexInfoService, AsyncIndexInfoService asyncIndexInfoService) {
        this.indexInfoService = (IndexInfoService)Preconditions.checkNotNull((Object)indexInfoService);
        this.asyncIndexInfoService = (AsyncIndexInfoService)Preconditions.checkNotNull((Object)asyncIndexInfoService);
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        this.printAsyncIndexInfo(pw);
        this.printIndexInfo(pw);
    }

    private void printAsyncIndexInfo(PrintWriter pw) {
        ImmutableList asyncLanes = ImmutableList.copyOf(this.asyncIndexInfoService.getAsyncLanes());
        String title = "Async Indexers State";
        IndexPrinter.printTitle(pw, title);
        pw.printf("Number of async indexer lanes : %d%n", asyncLanes.size());
        pw.println();
        for (String lane : asyncLanes) {
            pw.println(lane);
            AsyncIndexInfo info = this.asyncIndexInfoService.getInfo(lane);
            if (info == null) continue;
            pw.printf("    Last indexed to      : %s%n", IndexPrinter.formatTime(info.getLastIndexedTo()));
            IndexStatsMBean stats = info.getStatsMBean();
            if (stats != null) {
                pw.printf("    Status              : %s%n", stats.getStatus());
                pw.printf("    Failing             : %s%n", stats.isFailing());
                pw.printf("    Paused              : %s%n", stats.isPaused());
                if (stats.isFailing()) {
                    pw.printf("    Failing since       : %s%n", stats.getFailingSince());
                    pw.printf("    Latest error        : %s%n", stats.getLatestError());
                }
            }
            pw.println();
        }
    }

    private static void printTitle(PrintWriter pw, String title) {
        pw.println(title);
        pw.println(Strings.repeat((String)"=", (int)title.length()));
    }

    private void printIndexInfo(PrintWriter pw) {
        ArrayListMultimap infos = ArrayListMultimap.create();
        for (IndexInfo info : this.indexInfoService.getAllIndexInfo()) {
            infos.put((Object)info.getType(), (Object)info);
        }
        pw.printf("Total number of indexes : %d%n", infos.size());
        for (String type : infos.keySet()) {
            List typedInfo = infos.get((Object)type);
            String title = String.format("%s(%d)", type, typedInfo.size());
            IndexPrinter.printTitle(pw, title);
            pw.println();
            for (IndexInfo info : typedInfo) {
                IndexPrinter.printIndexInfo(pw, info);
            }
        }
    }

    private static void printIndexInfo(PrintWriter pw, IndexInfo info) {
        pw.println(info.getIndexPath());
        pw.printf("    Type                    : %s%n", info.getType());
        if (info.getAsyncLaneName() != null) {
            pw.printf("    Async                   : true%n", new Object[0]);
            pw.printf("    Async lane name         : %s%n", info.getAsyncLaneName());
        }
        if (info.getIndexedUpToTime() > 0L) {
            pw.printf("    Last indexed up to      : %s%n", IndexPrinter.formatTime(info.getIndexedUpToTime()));
        }
        if (info.getLastUpdatedTime() > 0L) {
            pw.printf("    Last updated time       : %s%n", IndexPrinter.formatTime(info.getLastUpdatedTime()));
        }
        if (info.getSizeInBytes() >= 0L) {
            pw.printf("    Size                    : %s%n", IOUtils.humanReadableByteCount((long)info.getSizeInBytes()));
        }
        if (info.getEstimatedEntryCount() >= 0L) {
            pw.printf("    Estimated entry count   : %d%n", info.getEstimatedEntryCount());
        }
        if (info.hasIndexDefinitionChangedWithoutReindexing()) {
            pw.println("    Index definition changed without reindexing");
            String diff = info.getIndexDefinitionDiff();
            if (diff != null) {
                pw.println("    " + diff);
            }
        }
        pw.println();
    }

    private static String formatTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return ISO8601.format((Calendar)cal);
    }
}

