/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.migration.AbstractDecoratedNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class FilteringNodeState
extends AbstractDecoratedNodeState {
    public static final Set<String> ALL = ImmutableSet.of((Object)"/");
    public static final Set<String> NONE = ImmutableSet.of();
    private final String path;
    private final Set<String> includedPaths;
    private final Set<String> excludedPaths;
    private final Set<String> fragmentPaths;
    private final Set<String> excludedFragments;

    @Nonnull
    public static NodeState wrap(@Nonnull String path, @Nonnull NodeState delegate, @Nullable Set<String> includePaths, @Nullable Set<String> excludePaths, @Nullable Set<String> fragmentPaths, @Nullable Set<String> excludedFragments) {
        Set<String> safeExcludedFragments;
        Set<String> safeFragmentPaths;
        Set<String> excludes;
        Set<String> includes = FilteringNodeState.defaultIfEmpty(includePaths, ALL);
        if (FilteringNodeState.hasHiddenDescendants(path, includes, excludes = FilteringNodeState.defaultIfEmpty(excludePaths, NONE), safeFragmentPaths = FilteringNodeState.defaultIfEmpty(fragmentPaths, NONE), safeExcludedFragments = FilteringNodeState.defaultIfEmpty(excludedFragments, NONE))) {
            return new FilteringNodeState(path, delegate, includes, excludes, fragmentPaths, safeExcludedFragments);
        }
        return delegate;
    }

    private FilteringNodeState(@Nonnull String path, @Nonnull NodeState delegate, @Nonnull Set<String> includedPaths, @Nonnull Set<String> excludedPaths, @Nonnull Set<String> fragmentPaths, @Nonnull Set<String> excludedFragments) {
        super(delegate);
        this.path = path;
        this.includedPaths = includedPaths;
        this.excludedPaths = excludedPaths;
        this.fragmentPaths = fragmentPaths;
        this.excludedFragments = excludedFragments;
    }

    @Override
    @Nonnull
    protected NodeState decorateChild(@Nonnull String name, @Nonnull NodeState child) {
        String childPath = PathUtils.concat((String)this.path, (String)name);
        return FilteringNodeState.wrap(childPath, child, this.includedPaths, this.excludedPaths, this.fragmentPaths, this.excludedFragments);
    }

    @Override
    protected boolean hideChild(@Nonnull String name, @Nonnull NodeState delegateChild) {
        return FilteringNodeState.isHidden(PathUtils.concat((String)this.path, (String)name), this.includedPaths, this.excludedPaths, this.excludedFragments);
    }

    @Override
    protected PropertyState decorateProperty(@Nonnull PropertyState propertyState) {
        return FilteringNodeState.fixChildOrderPropertyState((NodeState)this, propertyState);
    }

    private static boolean isHidden(@Nonnull String path, @Nonnull Set<String> includes, @Nonnull Set<String> excludes, @Nonnull Set<String> excludedFragments) {
        return FilteringNodeState.isExcluded(path, excludes, excludedFragments) || !FilteringNodeState.isIncluded(path, includes);
    }

    private static boolean hasHiddenDescendants(@Nonnull String path, @Nonnull Set<String> includePaths, @Nonnull Set<String> excludePaths, @Nonnull Set<String> fragmentPaths, @Nonnull Set<String> excludedFragments) {
        return FilteringNodeState.isHidden(path, includePaths, excludePaths, excludedFragments) || FilteringNodeState.isAncestorOfAnyPath(path, fragmentPaths) || FilteringNodeState.isDescendantOfAnyPath(path, fragmentPaths) || fragmentPaths.contains(path) || FilteringNodeState.isAncestorOfAnyPath(path, excludePaths) || FilteringNodeState.isAncestorOfAnyPath(path, includePaths);
    }

    private static boolean isIncluded(@Nonnull String path, @Nonnull Set<String> includePaths) {
        return FilteringNodeState.isAncestorOfAnyPath(path, includePaths) || includePaths.contains(path) || FilteringNodeState.isDescendantOfAnyPath(path, includePaths);
    }

    private static boolean isExcluded(@Nonnull String path, @Nonnull Set<String> excludePaths, @Nonnull Set<String> excludedFragments) {
        return excludePaths.contains(path) || FilteringNodeState.isDescendantOfAnyPath(path, excludePaths) || FilteringNodeState.containsAnyFragment(path, excludedFragments);
    }

    private static boolean isAncestorOfAnyPath(@Nonnull String ancestor, @Nonnull Set<String> paths) {
        for (String p : paths) {
            if (!PathUtils.isAncestor((String)ancestor, (String)p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDescendantOfAnyPath(@Nonnull String descendant, @Nonnull Set<String> paths) {
        for (String p : paths) {
            if (!PathUtils.isAncestor((String)p, (String)descendant)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAnyFragment(@Nonnull String path, @Nonnull Set<String> fragments) {
        for (String f : fragments) {
            if (!path.contains(f)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private static <T> Set<T> defaultIfEmpty(@Nullable Set<T> value, @Nonnull Set<T> defaultValue) {
        return !FilteringNodeState.isEmpty(value) ? value : defaultValue;
    }

    private static <T> boolean isEmpty(@Nullable Set<T> set) {
        return set == null || set.isEmpty();
    }
}

