/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.migration.FilteringNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStateCopier {
    private static final Logger LOG = LoggerFactory.getLogger(NodeStateCopier.class);
    private final Set<String> includePaths;
    private final Set<String> excludePaths;
    private final Set<String> fragmentPaths;
    private final Set<String> excludeFragments;
    private final Set<String> mergePaths;

    private NodeStateCopier(Set<String> includePaths, Set<String> excludePaths, Set<String> fragmentPaths, Set<String> excludeFragments, Set<String> mergePaths) {
        this.includePaths = includePaths;
        this.excludePaths = excludePaths;
        this.fragmentPaths = fragmentPaths;
        this.excludeFragments = excludeFragments;
        this.mergePaths = mergePaths;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean copyNodeStore(@Nonnull NodeStore source, @Nonnull NodeStore target) throws CommitFailedException {
        return NodeStateCopier.builder().copy((NodeStore)Preconditions.checkNotNull((Object)source), (NodeStore)Preconditions.checkNotNull((Object)target));
    }

    public static boolean copyProperties(NodeState source, NodeBuilder target) {
        boolean hasChanges = false;
        for (PropertyState property : target.getProperties()) {
            String name = property.getName();
            if (source.hasProperty(name)) continue;
            target.removeProperty(name);
            hasChanges = true;
        }
        for (PropertyState property : source.getProperties()) {
            if (property.equals(target.getProperty(property.getName()))) continue;
            target.setProperty(property);
            hasChanges = true;
        }
        return hasChanges;
    }

    private boolean copyNodeState(@Nonnull NodeState sourceRoot, @Nonnull NodeBuilder targetRoot) {
        NodeState wrappedSource = FilteringNodeState.wrap("/", sourceRoot, this.includePaths, this.excludePaths, this.fragmentPaths, this.excludeFragments);
        boolean hasChanges = false;
        for (String includePath : this.includePaths) {
            boolean bl = hasChanges = NodeStateCopier.copyMissingAncestors(sourceRoot, targetRoot, includePath) || hasChanges;
            NodeState sourceState = NodeStateUtils.getNode((NodeState)wrappedSource, (String)includePath);
            if (!sourceState.exists()) continue;
            NodeBuilder targetBuilder = NodeStateCopier.getChildNodeBuilder(targetRoot, includePath);
            hasChanges = NodeStateCopier.copyNodeState(sourceState, targetBuilder, includePath, this.mergePaths) || hasChanges;
        }
        return hasChanges;
    }

    private static boolean copyNodeState(@Nonnull NodeState source, @Nonnull NodeBuilder target, @Nonnull String currentPath, @Nonnull Set<String> mergePaths) {
        boolean hasChanges = false;
        for (String childName : target.getChildNodeNames()) {
            if (source.hasChildNode(childName) || NodeStateCopier.isMerge(PathUtils.concat((String)currentPath, (String)childName), mergePaths)) continue;
            target.setChildNode(childName, EmptyNodeState.MISSING_NODE);
            hasChanges = true;
        }
        for (ChildNodeEntry child : source.getChildNodeEntries()) {
            String childPath;
            String childName = child.getName();
            NodeState childSource = child.getNodeState();
            if (!target.hasChildNode(childName)) {
                target.setChildNode(childName, childSource);
                hasChanges = true;
                continue;
            }
            NodeBuilder childTarget = target.getChildNode(childName);
            hasChanges = NodeStateCopier.copyNodeState(childSource, childTarget, childPath = PathUtils.concat((String)currentPath, (String)childName), mergePaths) || hasChanges;
        }
        boolean bl = hasChanges = NodeStateCopier.copyProperties(source, target) || hasChanges;
        if (hasChanges) {
            LOG.trace("Node {} has changes", (Object)target);
        }
        return hasChanges;
    }

    private static boolean isMerge(String path, Set<String> mergePaths) {
        for (String mergePath : mergePaths) {
            if (!PathUtils.isAncestor((String)mergePath, (String)path) && !mergePath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private static boolean copyMissingAncestors(NodeState sourceRoot, NodeBuilder targetRoot, String path) {
        NodeState current = sourceRoot;
        NodeBuilder currentBuilder = targetRoot;
        boolean hasChanges = false;
        for (String name : PathUtils.elements((String)path)) {
            if (!current.hasChildNode(name)) continue;
            boolean targetHasChild = currentBuilder.hasChildNode(name);
            current = current.getChildNode(name);
            currentBuilder = currentBuilder.child(name);
            if (targetHasChild) continue;
            hasChanges = NodeStateCopier.copyProperties(current, currentBuilder) || hasChanges;
        }
        return hasChanges;
    }

    @Nonnull
    private static NodeBuilder getChildNodeBuilder(@Nonnull NodeBuilder root, @Nonnull String path) {
        NodeBuilder child = root;
        for (String name : PathUtils.elements((String)path)) {
            child = child.child(name);
        }
        return child;
    }

    public static class Builder {
        private Set<String> includePaths = ImmutableSet.of((Object)"/");
        private Set<String> excludePaths = Collections.emptySet();
        private Set<String> fragmentPaths = Collections.emptySet();
        private Set<String> excludeFragments = Collections.emptySet();
        private Set<String> mergePaths = Collections.emptySet();

        private Builder() {
        }

        @Nonnull
        public Builder include(@Nonnull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.includePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @Nonnull
        public Builder include(String ... paths) {
            return this.include((Set<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)paths))));
        }

        @Nonnull
        public Builder exclude(@Nonnull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.excludePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @Nonnull
        public Builder exclude(String ... paths) {
            return this.exclude((Set<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)paths))));
        }

        @Nonnull
        public Builder supportFragment(@Nonnull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.fragmentPaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @Nonnull
        public Builder supportFragment(String ... paths) {
            return this.supportFragment((Set<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)paths))));
        }

        @Nonnull
        public Builder excludeFragments(@Nonnull Set<String> fragments) {
            if (!((Set)Preconditions.checkNotNull(fragments)).isEmpty()) {
                this.excludeFragments = ImmutableSet.copyOf(fragments);
            }
            return this;
        }

        @Nonnull
        public Builder excludeFragments(String ... fragments) {
            return this.exclude((Set<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)fragments))));
        }

        @Nonnull
        public Builder merge(@Nonnull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.mergePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @Nonnull
        public Builder merge(String ... paths) {
            return this.merge((Set<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)paths))));
        }

        public boolean copy(@Nonnull NodeState sourceRoot, @Nonnull NodeBuilder targetRoot) {
            NodeStateCopier copier = new NodeStateCopier(this.includePaths, this.excludePaths, this.fragmentPaths, this.excludeFragments, this.mergePaths);
            return copier.copyNodeState((NodeState)Preconditions.checkNotNull((Object)sourceRoot), (NodeBuilder)Preconditions.checkNotNull((Object)targetRoot));
        }

        public boolean copy(@Nonnull NodeStore source, @Nonnull NodeStore target) throws CommitFailedException {
            NodeBuilder targetRoot = ((NodeStore)Preconditions.checkNotNull((Object)target)).getRoot().builder();
            if (this.copy(((NodeStore)Preconditions.checkNotNull((Object)source)).getRoot(), targetRoot)) {
                target.merge(targetRoot, EmptyHook.INSTANCE, CommitInfo.EMPTY);
                return true;
            }
            return false;
        }
    }
}

