/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.namespace.NamespaceConstants;

public class ReadOnlyNamespaceRegistry
implements NamespaceRegistry,
NamespaceConstants {
    protected final Tree namespaces;
    protected final Tree nsdata;

    public ReadOnlyNamespaceRegistry(Root root) {
        this.namespaces = root.getTree("/jcr:system/rep:namespaces");
        this.nsdata = this.namespaces.getChild("rep:nsdata");
    }

    private Iterable<String> getNSData(String name) {
        PropertyState property = this.nsdata.getProperty(name);
        if (property != null && property.getType() == Type.STRINGS) {
            return (Iterable)property.getValue(Type.STRINGS);
        }
        return Collections.emptyList();
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNamespace(String prefix) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Nonnull
    public String[] getPrefixes() {
        return (String[])Iterables.toArray(this.getNSData("rep:prefixes"), String.class);
    }

    @Nonnull
    public String[] getURIs() {
        return (String[])Iterables.toArray(this.getNSData("rep:uris"), String.class);
    }

    @Nonnull
    public String getURI(String prefix) throws NamespaceException {
        if (prefix.isEmpty()) {
            return prefix;
        }
        PropertyState property = this.namespaces.getProperty(prefix);
        if (property != null && property.getType() == Type.STRING) {
            return (String)property.getValue(Type.STRING);
        }
        throw new NamespaceException("No namespace registered for prefix " + prefix);
    }

    @Nonnull
    public String getPrefix(String uri) throws NamespaceException {
        if (uri.isEmpty()) {
            return uri;
        }
        PropertyState property = this.nsdata.getProperty(Namespaces.encodeUri(uri));
        if (property != null && property.getType() == Type.STRING) {
            return (String)property.getValue(Type.STRING);
        }
        throw new NamespaceException("No namespace prefix registered for URI " + uri);
    }
}

