/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.namepath.JcrNameParser;
import org.apache.jackrabbit.oak.namepath.NameMapper;

abstract class NamedTemplate {
    private final NameMapper mapper;
    private String oakName = null;

    protected NamedTemplate(@Nonnull NameMapper mapper) {
        this.mapper = mapper;
    }

    protected NamedTemplate(@Nonnull NameMapper mapper, @Nullable String jcrName) throws ConstraintViolationException {
        this(mapper);
        if (jcrName != null) {
            this.setName(jcrName);
        }
    }

    @CheckForNull
    protected String getOakName() {
        return this.oakName;
    }

    @CheckForNull
    public String getName() {
        return this.getJcrNameAllowNull(this.oakName);
    }

    public void setName(@Nonnull String jcrName) throws ConstraintViolationException {
        this.oakName = this.getOakNameOrThrowConstraintViolation(jcrName);
    }

    @CheckForNull
    protected String getJcrNameAllowNull(@CheckForNull String oakName) {
        if (oakName != null) {
            return this.mapper.getJcrName(oakName);
        }
        return null;
    }

    @CheckForNull
    protected String[] getJcrNamesAllowNull(@CheckForNull String[] oakNames) {
        String[] jcrNames = null;
        if (oakNames != null) {
            jcrNames = new String[oakNames.length];
            for (int i = 0; i < oakNames.length; ++i) {
                jcrNames[i] = this.mapper.getJcrName(oakNames[i]);
            }
        }
        return jcrNames;
    }

    @Nonnull
    protected String getOakNameOrThrowConstraintViolation(@CheckForNull String jcrName) throws ConstraintViolationException {
        if (jcrName == null) {
            throw new ConstraintViolationException("Missing JCR name");
        }
        String oakName = this.mapper.getOakNameOrNull(jcrName);
        if (oakName == null || !JcrNameParser.validate((String)jcrName)) {
            throw new ConstraintViolationException("Invalid name: " + jcrName);
        }
        return oakName;
    }

    @CheckForNull
    protected String getOakNameAllowNullOrThrowConstraintViolation(@CheckForNull String jcrName) throws ConstraintViolationException {
        if (jcrName == null) {
            return null;
        }
        return this.getOakNameOrThrowConstraintViolation(jcrName);
    }

    @Nonnull
    protected String[] getOakNamesOrThrowConstraintViolation(@CheckForNull String[] jcrNames) throws ConstraintViolationException {
        if (jcrNames != null) {
            String[] oakNames = new String[jcrNames.length];
            for (int i = 0; i < jcrNames.length; ++i) {
                oakNames[i] = this.getOakNameOrThrowConstraintViolation(jcrNames[i]);
            }
            return oakNames;
        }
        throw new ConstraintViolationException("Missing JCR names");
    }
}

