/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public abstract class AbstractMutableTree
extends AbstractTree {
    public boolean remove() {
        String name = this.getName();
        AbstractTree parent = this.getParentOrNull();
        if (parent != null && parent.hasChild(name)) {
            this.getNodeBuilder().remove();
            NodeBuilder parentBuilder = parent.getNodeBuilder();
            PropertyState order = parentBuilder.getProperty(":childOrder");
            if (order != null) {
                ArrayList names = Lists.newArrayListWithCapacity((int)order.count());
                for (String n : (Iterable)order.getValue(Type.NAMES)) {
                    if (n.equals(name)) continue;
                    names.add(n);
                }
                parentBuilder.setProperty(":childOrder", (Object)names, Type.NAMES);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Tree addChild(@Nonnull String name) throws IllegalArgumentException {
        Preconditions.checkArgument((!this.isHidden(name) ? 1 : 0) != 0);
        if (!this.hasChild(name)) {
            NodeBuilder nodeBuilder = this.getNodeBuilder();
            nodeBuilder.setChildNode(name);
            PropertyState order = nodeBuilder.getProperty(":childOrder");
            if (order != null) {
                ArrayList names = Lists.newArrayListWithCapacity((int)(order.count() + 1));
                for (String n : (Iterable)order.getValue(Type.NAMES)) {
                    if (n.equals(name)) continue;
                    names.add(n);
                }
                names.add(name);
                nodeBuilder.setProperty(":childOrder", (Object)names, Type.NAMES);
            }
        }
        return this.createChild(name);
    }

    public void setOrderableChildren(boolean enable) {
        if (enable) {
            this.updateChildOrder(true);
        } else {
            this.getNodeBuilder().removeProperty(":childOrder");
        }
    }

    protected void updateChildOrder(boolean force) {
        if (force || this.hasOrderableChildren()) {
            this.getNodeBuilder().setProperty(PropertyStates.createProperty((String)":childOrder", this.getChildNames(), (Type)Type.NAMES));
        }
    }

    public boolean orderBefore(@Nullable String name) {
        String thisName = this.getName();
        AbstractTree parent = this.getParentOrNull();
        if (parent == null) {
            return false;
        }
        if (thisName.equals(name)) {
            return false;
        }
        ArrayList names = Lists.newArrayListWithCapacity((int)10000);
        NodeBuilder builder = parent.getNodeBuilder();
        boolean found = false;
        for (String n : builder.getNames(":childOrder")) {
            if (n.equals(name) && parent.hasChild(name)) {
                names.add(thisName);
                found = true;
            }
            if (n.equals(thisName)) continue;
            names.add(n);
        }
        if (!found) {
            names.clear();
            for (String n : parent.getChildNames()) {
                if (n.equals(name)) {
                    names.add(thisName);
                    found = true;
                }
                if (n.equals(thisName)) continue;
                names.add(n);
            }
        }
        if (name == null) {
            names.add(thisName);
            found = true;
        }
        if (found) {
            builder.setProperty(":childOrder", (Object)names, Type.NAMES);
            return true;
        }
        return false;
    }

    public void setProperty(@Nonnull PropertyState property) {
        Preconditions.checkArgument((!this.isHidden(((PropertyState)Preconditions.checkNotNull((Object)property)).getName()) ? 1 : 0) != 0);
        this.getNodeBuilder().setProperty(property);
    }

    public <T> void setProperty(@Nonnull String name, @Nonnull T value) throws IllegalArgumentException {
        Preconditions.checkArgument((!this.isHidden((String)Preconditions.checkNotNull((Object)name)) ? 1 : 0) != 0);
        this.getNodeBuilder().setProperty(name, Preconditions.checkNotNull(value));
    }

    public <T> void setProperty(@Nonnull String name, @Nonnull T value, @Nonnull Type<T> type) throws IllegalArgumentException {
        Preconditions.checkArgument((!this.isHidden((String)Preconditions.checkNotNull((Object)name)) ? 1 : 0) != 0);
        this.getNodeBuilder().setProperty(name, Preconditions.checkNotNull(value), (Type)Preconditions.checkNotNull(type));
    }

    public void removeProperty(@Nonnull String name) {
        this.getNodeBuilder().removeProperty((String)Preconditions.checkNotNull((Object)name));
    }
}

