/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;

class HiddenTree
implements Tree {
    private final Tree parent;
    private final String name;

    HiddenTree(Tree parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String toString() {
        return this.getPath() + ": {}";
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return false;
    }

    @Nonnull
    public String getPath() {
        return PathUtils.concat((String)this.parent.getPath(), (String)this.name);
    }

    @Nonnull
    public Tree.Status getStatus() {
        return Tree.Status.UNCHANGED;
    }

    public boolean exists() {
        return false;
    }

    @Nonnull
    public Tree getParent() {
        return this.parent;
    }

    @CheckForNull
    public PropertyState getProperty(@Nonnull String name) {
        return null;
    }

    @CheckForNull
    public Tree.Status getPropertyStatus(@Nonnull String name) {
        return null;
    }

    public boolean hasProperty(@Nonnull String name) {
        return false;
    }

    public long getPropertyCount() {
        return 0L;
    }

    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return Collections.emptyList();
    }

    @Nonnull
    public Tree getChild(@Nonnull String name) {
        return new HiddenTree(this, (String)Preconditions.checkNotNull((Object)name));
    }

    public boolean hasChild(@Nonnull String name) {
        return false;
    }

    public long getChildrenCount(long max) {
        return 0L;
    }

    @Nonnull
    public Iterable<Tree> getChildren() {
        return Collections.emptyList();
    }

    public boolean remove() {
        return false;
    }

    @Nonnull
    public Tree addChild(@Nonnull String name) {
        throw HiddenTree.nonExistingTree();
    }

    public void setOrderableChildren(boolean enable) {
        throw HiddenTree.nonExistingTree();
    }

    public boolean orderBefore(@Nullable String name) {
        throw HiddenTree.nonExistingTree();
    }

    public void setProperty(@Nonnull PropertyState property) {
        throw HiddenTree.nonExistingTree();
    }

    public <T> void setProperty(@Nonnull String name, @Nonnull T value) {
        throw HiddenTree.nonExistingTree();
    }

    public <T> void setProperty(@Nonnull String name, @Nonnull T value, @Nonnull Type<T> type) {
        throw HiddenTree.nonExistingTree();
    }

    public void removeProperty(@Nonnull String name) {
        throw HiddenTree.nonExistingTree();
    }

    private static IllegalStateException nonExistingTree() {
        return new IllegalStateException("This tree does not exist");
    }
}

