/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.plugins.version.VersionExceptionCode;
import org.apache.jackrabbit.oak.plugins.version.VersionSelector;
import org.apache.jackrabbit.oak.plugins.version.VersionableState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.Text;

public class ReadWriteVersionManager
extends ReadOnlyVersionManager {
    private final NodeBuilder versionStorageNode;
    private final NodeBuilder workspaceRoot;
    private final TypePredicate isVersion;
    private ReadOnlyNodeTypeManager ntMgr;

    public ReadWriteVersionManager(NodeBuilder versionStorageNode, NodeBuilder workspaceRoot) {
        this.versionStorageNode = (NodeBuilder)Preconditions.checkNotNull((Object)versionStorageNode);
        this.workspaceRoot = (NodeBuilder)Preconditions.checkNotNull((Object)workspaceRoot);
        this.isVersion = new TypePredicate(workspaceRoot.getNodeState(), "nt:version");
    }

    @Override
    @Nonnull
    protected Tree getVersionStorage() {
        return TreeFactory.createReadOnlyTree(this.versionStorageNode.getNodeState());
    }

    @Override
    @Nonnull
    protected Root getWorkspaceRoot() {
        return RootFactory.createReadOnlyRoot(this.workspaceRoot.getNodeState());
    }

    @Override
    @Nonnull
    protected ReadOnlyNodeTypeManager getNodeTypeManager() {
        if (this.ntMgr == null) {
            this.ntMgr = ReadOnlyNodeTypeManager.getInstance(this.getWorkspaceRoot(), NamePathMapper.DEFAULT);
        }
        return this.ntMgr;
    }

    @Nonnull
    public NodeBuilder getOrCreateVersionHistory(@Nonnull NodeBuilder versionable, @Nonnull Map<String, Object> infoMap) throws CommitFailedException {
        Preconditions.checkNotNull((Object)versionable);
        String vUUID = Utils.uuidFromNode(versionable);
        String relPath = this.getVersionHistoryPath(vUUID);
        NodeBuilder node = this.versionStorageNode;
        Iterator it = PathUtils.elements((String)relPath).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if ((node = node.child(name)).hasProperty("jcr:primaryType")) continue;
            String nt = it.hasNext() ? "rep:versionStorage" : "nt:versionHistory";
            node.setProperty("jcr:primaryType", (Object)nt, Type.NAME);
        }
        Object copiedFrom = infoMap.get("jcr:copiedFrom");
        if (copiedFrom != null) {
            node.setProperty("jcr:copiedFrom", (Object)copiedFrom.toString(), Type.WEAKREFERENCE);
        }
        if (!node.hasChildNode("jcr:rootVersion")) {
            node.setProperty("jcr:versionableUuid", (Object)vUUID, Type.STRING);
            node.setProperty("jcr:uuid", (Object)UUIDUtils.generateUUID(), Type.STRING);
            NodeBuilder vLabels = node.child("jcr:versionLabels");
            vLabels.setProperty("jcr:primaryType", (Object)"nt:versionLabels", Type.NAME);
            this.createVersion(node, versionable);
        } else if (!versionable.hasProperty("jcr:versionHistory")) {
            this.connectHistory(node.getChildNode("jcr:rootVersion"), Utils.uuidFromNode(node), versionable);
        }
        return node;
    }

    void removeVersion(String versionRelPath) throws CommitFailedException {
        PropertyBuilder pb;
        String historyRelPath = PathUtils.getAncestorPath((String)versionRelPath, (int)1);
        String versionName = Text.getName((String)versionRelPath);
        NodeBuilder vh = this.resolve(this.versionStorageNode, historyRelPath);
        if ("jcr:rootVersion".equals(versionName)) {
            String msg = "Removal of root version not allowed.";
            throw new CommitFailedException("Version", VersionExceptionCode.ROOT_VERSION_REMOVAL.ordinal(), msg);
        }
        NodeBuilder versionNode = vh.getChildNode(versionName);
        String versionId = (String)versionNode.getProperty("jcr:uuid").getValue(Type.STRING);
        for (String label : this.getVersionLabels(versionRelPath, versionId)) {
            this.removeVersionLabel(historyRelPath, label);
        }
        PropertyState successorIds = versionNode.getProperty("jcr:successors");
        PropertyState predecessorIds = versionNode.getProperty("jcr:predecessors");
        for (String succId : (Iterable)successorIds.getValue(Type.REFERENCES)) {
            NodeBuilder successor = this.getVersionById(vh, succId);
            pb = PropertyBuilder.array((Type)Type.REFERENCE);
            pb.setName("jcr:predecessors").setValues((Iterable)successor.getProperty("jcr:predecessors").getValue(Type.REFERENCES));
            pb.removeValue((Object)versionId);
            pb.addValues((Iterable)predecessorIds.getValue(Type.REFERENCES));
            successor.setProperty(pb.getPropertyState());
        }
        for (String predId : (Iterable)predecessorIds.getValue(Type.REFERENCES)) {
            NodeBuilder predecessor = this.getVersionById(vh, predId);
            pb = PropertyBuilder.array((Type)Type.REFERENCE);
            pb.setName("jcr:successors").setValues((Iterable)predecessor.getProperty("jcr:successors").getValue(Type.REFERENCES));
            pb.removeValue((Object)versionId);
            pb.addValues((Iterable)successorIds.getValue(Type.REFERENCES));
            predecessor.setProperty(pb.getPropertyState());
        }
        versionNode.remove();
    }

    public void checkout(NodeBuilder versionable) {
        versionable.setProperty("jcr:isCheckedOut", (Object)true, Type.BOOLEAN);
        PropertyState baseVersion = versionable.getProperty("jcr:baseVersion");
        List<Object> predecessors = Collections.singletonList(baseVersion.getValue(Type.REFERENCE));
        versionable.setProperty("jcr:predecessors", predecessors, Type.REFERENCES);
    }

    public void checkin(@Nonnull NodeBuilder versionable) throws CommitFailedException {
        NodeBuilder history = this.getOrCreateVersionHistory(versionable, Collections.emptyMap());
        this.createVersion(history, versionable);
    }

    public void restore(@Nonnull NodeBuilder versionable, @Nonnull String versionUUID, @Nullable VersionSelector selector) throws CommitFailedException {
        String versionName;
        String versionPath = this.getIdentifierManager().getPath(versionUUID);
        NodeBuilder history = this.getOrCreateVersionHistory(versionable, Collections.emptyMap());
        NodeBuilder version = null;
        if (versionPath != null && history.hasChildNode(versionName = PathUtils.getName((String)versionPath))) {
            version = history.getChildNode(versionName);
        }
        if (version == null) {
            throw new CommitFailedException("Version", VersionExceptionCode.NO_SUCH_VERSION.ordinal(), "The VersionHistory with UUID: " + Utils.uuidFromNode(versionable) + " does not have a Version with UUID: " + versionUUID);
        }
        VersionableState versionableState = VersionableState.forRestore(version, history, versionable, this, this.ntMgr);
        versionableState.restore(selector);
    }

    void restore(@Nonnull String historyIdentifier, @Nonnull VersionSelector selector, @Nonnull NodeBuilder versionable) throws CommitFailedException, RepositoryException {
        String historyPath = this.getIdentifierManager().getPath(historyIdentifier);
        String historyRelPath = PathUtils.relativize((String)"/jcr:system/jcr:versionStorage", (String)historyPath);
        NodeBuilder history = this.resolve(this.versionStorageNode, historyRelPath);
        Preconditions.checkState((boolean)history.exists(), (Object)("Version history does not exist: " + historyPath));
        NodeBuilder version = selector.select(history);
        if (version == null) {
            throw new CommitFailedException("Version", VersionExceptionCode.NO_VERSION_TO_RESTORE.ordinal(), "VersionSelector did not select any version from history: " + historyPath);
        }
        String versionableUUUID = (String)history.getProperty("jcr:versionableUuid").getValue(Type.STRING);
        versionable.setProperty("jcr:uuid", (Object)versionableUUUID, Type.STRING);
        this.restore(versionable, Utils.uuidFromNode(version), selector);
    }

    public void removeVersionLabel(@Nonnull String historyRelPath, @Nonnull String label) throws CommitFailedException {
        NodeBuilder labels = this.getVersionLabelsFor((String)Preconditions.checkNotNull((Object)historyRelPath));
        if (!labels.hasProperty((String)Preconditions.checkNotNull((Object)label))) {
            throw new CommitFailedException("Version", VersionExceptionCode.NO_SUCH_VERSION_LABEL.ordinal(), "Version label " + label + " does not exist on this version history");
        }
        labels.removeProperty(label);
    }

    void removeEmptyHistory(@Nonnull NodeState versionable) {
        NodeBuilder history = this.getVersionHistory(versionable);
        if (this.isEmptyHistory(history.getNodeState())) {
            history.remove();
        }
    }

    @Nonnull
    private NodeBuilder resolve(NodeBuilder node, String relPath) {
        Preconditions.checkArgument((!PathUtils.isAbsolute((String)relPath) ? 1 : 0) != 0, (Object)"Not a relative path");
        for (String name : PathUtils.elements((String)relPath)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    private NodeBuilder createVersion(@Nonnull NodeBuilder vHistory, @Nonnull NodeBuilder versionable) throws IllegalArgumentException, CommitFailedException {
        NodeBuilder version;
        Object predecessors;
        boolean isRootVersion;
        if (!vHistory.hasChildNode("jcr:rootVersion")) {
            isRootVersion = true;
            predecessors = Collections.emptyList();
            version = vHistory.child("jcr:rootVersion");
        } else {
            isRootVersion = false;
            Preconditions.checkState((boolean)versionable.hasProperty("jcr:predecessors"));
            PropertyState state = versionable.getProperty("jcr:predecessors");
            predecessors = ImmutableList.copyOf((Iterable)((Iterable)state.getValue(Type.REFERENCES)));
            version = vHistory.child(this.calculateVersion(vHistory, versionable));
        }
        String versionUUID = UUIDUtils.generateUUID();
        version.setProperty("jcr:uuid", (Object)versionUUID, Type.STRING);
        version.setProperty("jcr:primaryType", (Object)"nt:version", Type.NAME);
        version.setProperty("jcr:created", (Object)ISO8601.format((Calendar)Calendar.getInstance()), Type.DATE);
        version.setProperty("jcr:predecessors", predecessors, Type.REFERENCES);
        version.setProperty("jcr:successors", Collections.emptyList(), Type.REFERENCES);
        for (String id : predecessors) {
            String name = PathUtils.getName((String)this.getIdentifierManager().getPath(id));
            NodeBuilder predecessor = vHistory.getChildNode(name);
            PropertyState state = predecessor.getProperty("jcr:successors");
            if (state == null) {
                throw new IllegalStateException("Missing jcr:successors property on " + predecessor);
            }
            HashSet refs = Sets.newHashSet((Iterable)((Iterable)state.getValue(Type.REFERENCES)));
            refs.add(versionUUID);
            predecessor.setProperty("jcr:successors", (Object)refs, Type.REFERENCES);
        }
        VersionableState versionableState = VersionableState.fromVersion(version, vHistory, versionable, this, this.getNodeTypeManager());
        if (!isRootVersion) {
            versionableState.create();
        }
        versionable.setProperty("jcr:isCheckedOut", (Object)isRootVersion, Type.BOOLEAN);
        versionable.setProperty("jcr:versionHistory", (Object)Utils.uuidFromNode(vHistory), Type.REFERENCE);
        versionable.setProperty("jcr:baseVersion", (Object)versionUUID, Type.REFERENCE);
        predecessors = isRootVersion ? Collections.singletonList(versionUUID) : Collections.emptyList();
        versionable.setProperty("jcr:predecessors", predecessors, Type.REFERENCES);
        return version;
    }

    private void connectHistory(@Nonnull NodeBuilder rootVersion, @Nonnull String vHistoryUUID, @Nonnull NodeBuilder versionable) {
        String rootVersionUUID = Utils.uuidFromNode(rootVersion);
        versionable.setProperty("jcr:isCheckedOut", (Object)true, Type.BOOLEAN);
        versionable.setProperty("jcr:versionHistory", (Object)vHistoryUUID, Type.REFERENCE);
        versionable.setProperty("jcr:baseVersion", (Object)rootVersionUUID, Type.REFERENCE);
        versionable.setProperty("jcr:predecessors", Collections.singleton(rootVersionUUID), Type.REFERENCES);
    }

    protected String calculateVersion(@Nonnull NodeBuilder history, @Nonnull NodeBuilder versionable) throws IllegalStateException {
        PropertyState predecessors = versionable.getProperty("jcr:predecessors");
        if (predecessors == null || predecessors.count() == 0) {
            String message = predecessors == null ? "Mandatory jcr:predecessors property missing on node " + Utils.uuidFromNode(versionable) : "Mandatory jcr:predecessors property is empty on node " + Utils.uuidFromNode(versionable);
            throw new IllegalStateException(message);
        }
        String best = null;
        for (String id : (Iterable)predecessors.getValue(Type.REFERENCES)) {
            String name = PathUtils.getName((String)this.getIdentifierManager().getPath(id));
            if (best != null && name.length() >= best.length()) continue;
            best = name;
        }
        if (best == null) {
            String message = "Could not find 'best' predecessor node for " + Utils.uuidFromNode(versionable);
            throw new IllegalStateException(message);
        }
        String versionName = best;
        int pos = versionName.lastIndexOf(46);
        if (pos > 0) {
            String newVersionName = versionName.substring(0, pos + 1) + (Integer.parseInt(versionName.substring(pos + 1)) + 1);
            while (history.hasChildNode(newVersionName)) {
                newVersionName = versionName = versionName + ".0";
            }
            return newVersionName;
        }
        Preconditions.checkState((boolean)history.hasChildNode("jcr:rootVersion"));
        NodeBuilder v = history.getChildNode("jcr:rootVersion");
        return String.valueOf(v.getProperty("jcr:successors").count() + 1) + ".0";
    }

    private NodeBuilder getVersionLabelsFor(String historyRelPath) throws CommitFailedException {
        NodeBuilder history = this.resolve(this.versionStorageNode, historyRelPath);
        if (!history.exists()) {
            throw new CommitFailedException("Version", VersionExceptionCode.UNEXPECTED_REPOSITORY_EXCEPTION.ordinal(), "Version history does not exist: " + PathUtils.concat((String)"/jcr:system/jcr:versionStorage", (String)historyRelPath));
        }
        return history.child("jcr:versionLabels");
    }

    @Nonnull
    private Iterable<String> getVersionLabels(@Nonnull String historyRelPath, @Nonnull String versionId) throws CommitFailedException {
        ArrayList<String> labels = new ArrayList<String>();
        NodeBuilder labelNode = this.getVersionLabelsFor(historyRelPath);
        for (PropertyState ps : labelNode.getProperties()) {
            if (Type.REFERENCE != ps.getType() || !versionId.equals(ps.getValue(Type.REFERENCE))) continue;
            labels.add(ps.getName());
        }
        return labels;
    }

    @CheckForNull
    private NodeBuilder getVersionById(@Nonnull NodeBuilder vhBuilder, @Nonnull String versionId) {
        for (String childName : vhBuilder.getChildNodeNames()) {
            NodeBuilder nb = vhBuilder.getChildNode(childName);
            PropertyState uuid = nb.getProperty("jcr:uuid");
            if (uuid == null || !versionId.equals(uuid.getValue(Type.STRING))) continue;
            return nb;
        }
        return null;
    }

    @Nonnull
    private NodeBuilder getVersionHistory(@Nonnull NodeState versionable) {
        Preconditions.checkNotNull((Object)versionable);
        String vUUID = Utils.uuidFromNode(versionable);
        String relPath = this.getVersionHistoryPath(vUUID);
        NodeBuilder node = this.versionStorageNode;
        for (String name : PathUtils.elements((String)relPath)) {
            if ((node = node.getChildNode(name)).exists()) continue;
            throw new IllegalArgumentException("No version history for this node");
        }
        return node;
    }

    private boolean isEmptyHistory(NodeState versionHistory) {
        for (ChildNodeEntry entry : versionHistory.getChildNodeEntries()) {
            String name = entry.getName();
            NodeState node = entry.getNodeState();
            if ("jcr:rootVersion".equals(name) || !this.isVersion.apply(node)) continue;
            return false;
        }
        NodeState labels = versionHistory.getChildNode("jcr:versionLabels");
        for (PropertyState prop : labels.getProperties()) {
            if (prop.getType() != Type.REFERENCE) continue;
            return false;
        }
        return true;
    }
}

