/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

final class Utils {
    private Utils() {
    }

    @Nonnull
    static String uuidFromNode(@Nonnull NodeBuilder node) throws IllegalArgumentException {
        return Utils.uuidFromNode(node.getNodeState());
    }

    @Nonnull
    static String uuidFromNode(@Nonnull NodeState node) {
        PropertyState p = ((NodeState)Preconditions.checkNotNull((Object)node)).getProperty("jcr:uuid");
        if (p == null) {
            throw new IllegalArgumentException("Not referenceable");
        }
        return (String)p.getValue(Type.STRING);
    }

    @Nonnull
    static String primaryTypeOf(@Nonnull NodeBuilder node) throws IllegalStateException {
        String primaryType = ((NodeBuilder)Preconditions.checkNotNull((Object)node)).getName("jcr:primaryType");
        if (primaryType == null) {
            throw new IllegalStateException("Node does not have a jcr:primaryType");
        }
        return primaryType;
    }

    static <T> T throwProtected(String path) throws CommitFailedException {
        throw new CommitFailedException("Constraint", 100, "Item is protected: " + path);
    }
}

