/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.plugins.version.VersionLabelsEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;

class VersionStorageEditor
extends DefaultEditor {
    private static final int VERSION_HISTORY_DEPTH = 6;
    private final NodeBuilder versionStorageNode;
    private final NodeBuilder workspaceRoot;
    private final NodeBuilder builder;
    private final String path;
    private ReadWriteVersionManager vMgr;

    VersionStorageEditor(@Nonnull NodeBuilder versionStorageNode, @Nonnull NodeBuilder workspaceRoot) {
        this(versionStorageNode, workspaceRoot, versionStorageNode, "/jcr:system/jcr:versionStorage");
    }

    private VersionStorageEditor(@Nonnull NodeBuilder versionStorageNode, @Nonnull NodeBuilder workspaceRoot, @Nonnull NodeBuilder builder, @Nonnull String path) {
        this.versionStorageNode = (NodeBuilder)Preconditions.checkNotNull((Object)versionStorageNode);
        this.workspaceRoot = (NodeBuilder)Preconditions.checkNotNull((Object)workspaceRoot);
        this.builder = (NodeBuilder)Preconditions.checkNotNull((Object)builder);
        this.path = (String)Preconditions.checkNotNull((Object)path);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        int d = PathUtils.getDepth((String)this.path);
        String p = PathUtils.concat((String)this.path, (String)name);
        if (d == 6 && name.equals("jcr:versionLabels")) {
            return new VersionLabelsEditor(p, this.getVersionManager());
        }
        if (d < 6 && !VersionStorageEditor.isVersionStorageNode(after)) {
            return null;
        }
        return new VersionStorageEditor(this.versionStorageNode, this.workspaceRoot, this.builder.child(name), p);
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        int d = PathUtils.getDepth((String)this.path);
        if (d == PathUtils.getDepth((String)"/jcr:system/jcr:versionStorage") && !VersionStorageEditor.isVersionStorageNode(after)) {
            return null;
        }
        return this.throwProtected(name);
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        int d = PathUtils.getDepth((String)this.path);
        if (d == 6) {
            this.builder.setChildNode(name, before);
            String relPath = PathUtils.relativize((String)"/jcr:system/jcr:versionStorage", (String)PathUtils.concat((String)this.path, (String)name));
            this.getVersionManager().removeVersion(relPath);
            return null;
        }
        if (VersionStorageEditor.isVersionStorageNode(before) || d > 6) {
            this.throwProtected(name);
        }
        return null;
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (PathUtils.getDepth((String)this.path) < 6) {
            return;
        }
        this.throwProtected(after.getName());
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (PathUtils.getDepth((String)this.path) < 6) {
            return;
        }
        this.throwProtected(before.getName());
    }

    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (PathUtils.getDepth((String)this.path) < 6) {
            return;
        }
        this.throwProtected(before.getName());
    }

    private static boolean isVersionStorageNode(NodeState state) {
        String ntName = state.getName("jcr:primaryType");
        return VersionConstants.VERSION_STORE_NT_NAMES.contains(ntName) || VersionConstants.VERSION_NODE_TYPE_NAMES.contains(ntName);
    }

    private ReadWriteVersionManager getVersionManager() {
        if (this.vMgr == null) {
            this.vMgr = new ReadWriteVersionManager(this.versionStorageNode, this.workspaceRoot);
        }
        return this.vMgr;
    }

    private Editor throwProtected(String name) throws CommitFailedException {
        return (Editor)Utils.throwProtected(PathUtils.concat((String)this.path, (String)name));
    }
}

