/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.NodeNameImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class NodeLocalNameImpl
extends DynamicOperandImpl {
    private final String selectorName;
    private SelectorImpl selector;

    public NodeLocalNameImpl(String selectorName) {
        this.selectorName = selectorName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "localname(" + this.quote(this.selectorName) + ')';
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return null;
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public PropertyValue currentProperty() {
        String path = this.selector.currentPath();
        if (path == null) {
            return null;
        }
        String name = PathUtils.getName((String)path);
        String localName = NodeLocalNameImpl.getLocalName(name);
        return PropertyValues.newString((String)localName);
    }

    static String getLocalName(String name) {
        int colon = name.indexOf(58);
        return colon < 0 ? name : name.substring(colon + 1);
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (v == null) {
            return;
        }
        if (operator == Operator.NOT_EQUAL && v != null) {
            return;
        }
        String name = NodeNameImpl.getName(this.query, v);
        if (name != null && f.getSelector().equals(this.selector) && NodeNameImpl.supportedOperator(operator)) {
            f.restrictProperty(":localname", operator, PropertyValues.newString((String)name));
        }
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
    }

    @Override
    public String getFunction(SelectorImpl s) {
        if (!s.equals(this.selector)) {
            return null;
        }
        return "@:localname";
    }

    @Override
    public boolean supportsRangeConditions() {
        return false;
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return s.equals(this.selector);
    }

    @Override
    int getPropertyType() {
        return 1;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new NodeLocalNameImpl(this.selectorName);
    }

    @Override
    public QueryIndex.OrderEntry getOrderEntry(SelectorImpl s, OrderingImpl o) {
        if (!s.equals(this.selector)) {
            return null;
        }
        return new QueryIndex.OrderEntry(":localname", Type.STRING, o.isDescending() ? QueryIndex.OrderEntry.Order.DESCENDING : QueryIndex.OrderEntry.Order.ASCENDING);
    }
}

