/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestImpl
extends ConstraintImpl {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NATIVE_LUCENE_LANGUAGE = "lucene";
    public static final String SUGGEST_PREFIX = "suggest?term=";
    private final String selectorName;
    private final StaticOperandImpl expression;
    private SelectorImpl selector;

    SuggestImpl(String selectorName, StaticOperandImpl expression) {
        this.selectorName = selectorName;
        this.expression = expression;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("suggest(");
        builder.append(this.quote(this.selectorName));
        builder.append(", ");
        builder.append(this.getExpression());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public boolean evaluate() {
        if (!(this.selector.getIndex() instanceof QueryIndex.FulltextQueryIndex)) {
            this.log.warn("No full-text index was found that can process the condition " + this.toString());
            return false;
        }
        return true;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector)) {
            PropertyValue p = this.expression.currentValue();
            String term = (String)p.getValue(Type.STRING);
            String query = SUGGEST_PREFIX + term;
            PropertyValue v = PropertyValues.newString((String)query);
            f.restrictProperty("native*lucene", Operator.EQUAL, v);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            this.selector.restrictSelector(this);
        }
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.emptySet();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    public StaticOperandImpl getExpression() {
        return this.expression;
    }

    @Override
    public AstElement copyOf() {
        return new SuggestImpl(this.selectorName, this.expression);
    }

    @Override
    public boolean requiresFullTextIndex() {
        return true;
    }
}

