/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.user;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginModuleImpl
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(LoginModuleImpl.class);
    protected static final Set<Class> SUPPORTED_CREDENTIALS = new HashSet<Class>(3);
    private Credentials credentials;
    private String userId;
    private Principal principal;
    private boolean success;

    public boolean login() throws LoginException {
        this.credentials = this.getCredentials();
        PreAuthenticatedLogin preAuthLogin = this.getSharedPreAuthLogin();
        String loginName = this.getLoginId(preAuthLogin);
        Authentication authentication = this.getUserAuthentication(loginName);
        if (authentication != null) {
            this.success = preAuthLogin != null ? authentication.authenticate(PreAuthenticatedLogin.PRE_AUTHENTICATED) : authentication.authenticate(this.credentials);
            if (this.success) {
                log.debug("Adding Credentials to shared state.");
                this.sharedState.put("org.apache.jackrabbit.credentials", this.credentials);
                log.debug("Adding login name to shared state.");
                this.sharedState.put("javax.security.auth.login.name", loginName);
                this.userId = authentication.getUserId();
                if (this.userId == null) {
                    this.userId = loginName;
                }
                this.principal = authentication.getUserPrincipal();
            }
        } else {
            this.credentials = null;
            this.userId = null;
        }
        return this.success;
    }

    public boolean commit() {
        if (!this.success) {
            this.clearState();
            return false;
        }
        if (!this.subject.isReadOnly()) {
            Set<Principal> principals = this.subject.getPrincipals();
            if (this.principal != null) {
                principals.addAll(this.getPrincipals(this.principal));
            } else if (this.userId != null) {
                principals.addAll(this.getPrincipals(this.userId));
            }
            this.subject.getPublicCredentials().add(this.credentials);
            LoginModuleImpl.setAuthInfo((AuthInfo)this.createAuthInfo(principals), (Subject)this.subject);
        } else {
            log.debug("Could not add information to read only subject {}", (Object)this.subject);
        }
        this.clearState();
        return true;
    }

    @Nonnull
    protected Set<Class> getSupportedCredentials() {
        return SUPPORTED_CREDENTIALS;
    }

    protected void clearState() {
        super.clearState();
        this.credentials = null;
        this.userId = null;
        this.principal = null;
    }

    @CheckForNull
    private String getLoginId(@CheckForNull PreAuthenticatedLogin preAuthenticatedLogin) {
        if (preAuthenticatedLogin != null) {
            return preAuthenticatedLogin.getUserId();
        }
        String uid = null;
        if (this.credentials != null) {
            if (this.credentials instanceof SimpleCredentials) {
                uid = ((SimpleCredentials)this.credentials).getUserID();
            } else if (this.credentials instanceof GuestCredentials) {
                uid = this.getAnonymousId();
            } else if (this.credentials instanceof ImpersonationCredentials) {
                Credentials bc = ((ImpersonationCredentials)this.credentials).getBaseCredentials();
                if (bc instanceof SimpleCredentials) {
                    uid = ((SimpleCredentials)bc).getUserID();
                }
            } else {
                try {
                    NameCallback callback = new NameCallback("User-ID: ");
                    this.callbackHandler.handle(new Callback[]{callback});
                    uid = callback.getName();
                }
                catch (UnsupportedCallbackException e) {
                    log.warn("Credentials- or NameCallback must be supported");
                }
                catch (IOException e) {
                    log.error("Name-Callback failed: " + e.getMessage());
                }
            }
        }
        if (uid == null) {
            uid = this.getSharedLoginName();
        }
        return uid;
    }

    private String getAnonymousId() {
        SecurityProvider sp = this.getSecurityProvider();
        if (sp == null) {
            return null;
        }
        ConfigurationParameters params = ((UserConfiguration)sp.getConfiguration(UserConfiguration.class)).getParameters();
        return UserUtil.getAnonymousId((ConfigurationParameters)params);
    }

    @CheckForNull
    private Authentication getUserAuthentication(@Nullable String loginName) {
        SecurityProvider securityProvider = this.getSecurityProvider();
        Root root = this.getRoot();
        if (securityProvider != null && root != null) {
            UserConfiguration uc = (UserConfiguration)securityProvider.getConfiguration(UserConfiguration.class);
            UserAuthenticationFactory factory = (UserAuthenticationFactory)uc.getParameters().getConfigValue("userAuthenticationFactory", null, UserAuthenticationFactory.class);
            if (factory != null) {
                return factory.getAuthentication(uc, root, loginName);
            }
            log.error("No user authentication factory configured in user configuration.");
        }
        return null;
    }

    private AuthInfo createAuthInfo(@Nonnull Set<? extends Principal> principals) {
        HashMap<String, Object> attributes;
        block3: {
            Credentials creds;
            block2: {
                creds = this.credentials instanceof ImpersonationCredentials ? ((ImpersonationCredentials)this.credentials).getBaseCredentials() : this.credentials;
                attributes = new HashMap<String, Object>();
                Object shared = this.sharedState.get("javax.security.auth.login.attributes");
                if (!(shared instanceof Map)) break block2;
                for (Object key : ((Map)shared).keySet()) {
                    attributes.put(key.toString(), ((Map)shared).get(key));
                }
                break block3;
            }
            if (!(creds instanceof SimpleCredentials)) break block3;
            SimpleCredentials sc = (SimpleCredentials)creds;
            for (String attrName : sc.getAttributeNames()) {
                attributes.put(attrName, sc.getAttribute(attrName));
            }
        }
        return new AuthInfoImpl(this.userId, attributes, principals);
    }

    static {
        SUPPORTED_CREDENTIALS.add(SimpleCredentials.class);
        SUPPORTED_CREDENTIALS.add(GuestCredentials.class);
        SUPPORTED_CREDENTIALS.add(ImpersonationCredentials.class);
    }
}

