/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractTree;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;

class AccessControlValidator
extends DefaultValidator
implements AccessControlConstants {
    private final Tree parentAfter;
    private final PrivilegeBitsProvider privilegeBitsProvider;
    private final PrivilegeManager privilegeManager;
    private final RestrictionProvider restrictionProvider;
    private final TypePredicate isRepoAccessControllable;
    private final TypePredicate isAccessControllable;

    AccessControlValidator(@Nonnull NodeState parentAfter, @Nonnull PrivilegeManager privilegeManager, @Nonnull PrivilegeBitsProvider privilegeBitsProvider, @Nonnull RestrictionProvider restrictionProvider, @Nonnull TreeProvider treeProvider) {
        this.parentAfter = treeProvider.createReadOnlyTree(parentAfter);
        this.privilegeBitsProvider = privilegeBitsProvider;
        this.privilegeManager = privilegeManager;
        this.restrictionProvider = restrictionProvider;
        this.isRepoAccessControllable = new TypePredicate(parentAfter, "rep:RepoAccessControllable");
        this.isAccessControllable = new TypePredicate(parentAfter, "rep:AccessControllable");
    }

    private AccessControlValidator(AccessControlValidator parent, Tree parentAfter) {
        this.parentAfter = parentAfter;
        this.privilegeBitsProvider = parent.privilegeBitsProvider;
        this.privilegeManager = parent.privilegeManager;
        this.restrictionProvider = parent.restrictionProvider;
        this.isRepoAccessControllable = parent.isRepoAccessControllable;
        this.isAccessControllable = parent.isAccessControllable;
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (AccessControlValidator.isAccessControlEntry(this.parentAfter)) {
            this.checkValidAccessControlEntry(this.parentAfter);
        }
        if ("jcr:mixinTypes".equals(after.getName())) {
            AccessControlValidator.checkMixinTypes(this.parentAfter);
        }
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (AccessControlValidator.isAccessControlEntry(this.parentAfter)) {
            this.checkValidAccessControlEntry(this.parentAfter);
        }
        if ("jcr:mixinTypes".equals(after.getName())) {
            AccessControlValidator.checkMixinTypes(this.parentAfter);
        }
    }

    public void propertyDeleted(PropertyState before) throws CommitFailedException {
    }

    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        Tree treeAfter = (Tree)Preconditions.checkNotNull((Object)this.parentAfter.getChild(name));
        this.checkValidTree(this.parentAfter, treeAfter, after);
        return AccessControlValidator.newValidator(this, treeAfter);
    }

    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        Tree treeAfter = (Tree)Preconditions.checkNotNull((Object)this.parentAfter.getChild(name));
        this.checkValidTree(this.parentAfter, treeAfter, after);
        return AccessControlValidator.newValidator(this, treeAfter);
    }

    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        return null;
    }

    private static Validator newValidator(AccessControlValidator parent, Tree parentAfter) {
        return new VisibleValidator((Validator)new AccessControlValidator(parent, parentAfter), true, true);
    }

    private void checkValidTree(Tree parentAfter, Tree treeAfter, NodeState nodeAfter) throws CommitFailedException {
        if (AccessControlValidator.isPolicy(treeAfter)) {
            this.checkValidPolicy(parentAfter, treeAfter, nodeAfter);
        } else if (AccessControlValidator.isAccessControlEntry(treeAfter)) {
            this.checkValidAccessControlEntry(treeAfter);
        } else if ("rep:Restrictions".equals(TreeUtil.getPrimaryTypeName((Tree)treeAfter))) {
            AccessControlValidator.checkIsAccessControlEntry(parentAfter);
            this.checkValidRestrictions(parentAfter);
        }
    }

    private static boolean isPolicy(Tree tree) {
        return "rep:ACL".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    private static boolean isAccessControlEntry(Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName((Tree)tree);
        return "rep:DenyACE".equals(ntName) || "rep:GrantACE".equals(ntName);
    }

    private static void checkIsAccessControlEntry(Tree tree) throws CommitFailedException {
        if (!AccessControlValidator.isAccessControlEntry(tree)) {
            throw AccessControlValidator.accessViolation(2, "Access control entry node expected at " + tree.getPath());
        }
    }

    private void checkValidPolicy(Tree parent, Tree policyTree, NodeState policyNode) throws CommitFailedException {
        Set<String> validPolicyNames;
        if ("rep:repoPolicy".equals(policyTree.getName())) {
            AccessControlValidator.checkValidAccessControlledNode(parent, this.isRepoAccessControllable);
            AccessControlValidator.checkValidRepoAccessControlled(parent);
        } else {
            AccessControlValidator.checkValidAccessControlledNode(parent, this.isAccessControllable);
        }
        Set<String> set = validPolicyNames = parent.isRoot() ? POLICY_NODE_NAMES : Collections.singleton("rep:policy");
        if (!validPolicyNames.contains(policyTree.getName())) {
            throw AccessControlValidator.accessViolation(3, "Invalid policy name " + policyTree.getName() + " at " + parent.getPath());
        }
        if (!policyNode.hasProperty(":childOrder")) {
            throw AccessControlValidator.accessViolation(4, "Invalid policy node at " + policyTree.getPath() + ": Order of children is not stable.");
        }
        HashSet aceSet = Sets.newHashSet();
        for (Tree child : policyTree.getChildren()) {
            if (!AccessControlValidator.isAccessControlEntry(child) || aceSet.add(new Entry(parent.getPath(), child))) continue;
            throw AccessControlValidator.accessViolation(13, "Duplicate ACE '" + child.getPath() + "' found in policy");
        }
    }

    private static void checkValidAccessControlledNode(@Nonnull Tree accessControlledTree, @Nonnull TypePredicate requiredMixin) throws CommitFailedException {
        NodeState ns;
        if (AC_NODETYPE_NAMES.contains(TreeUtil.getPrimaryTypeName((Tree)accessControlledTree))) {
            throw AccessControlValidator.accessViolation(5, "Access control policy within access control content (" + accessControlledTree.getPath() + ')');
        }
        NodeState nodeState = ns = accessControlledTree instanceof AbstractTree ? ((AbstractTree)accessControlledTree).getNodeState() : null;
        if (!requiredMixin.apply(ns)) {
            String msg = "Isolated policy node (" + accessControlledTree.getPath() + "). Parent is not of type " + requiredMixin;
            throw AccessControlValidator.accessViolation(6, msg);
        }
    }

    private void checkValidAccessControlEntry(@Nonnull Tree aceNode) throws CommitFailedException {
        Tree parent = aceNode.getParent();
        if (!parent.exists() || !"rep:ACL".equals(TreeUtil.getPrimaryTypeName((Tree)parent))) {
            throw AccessControlValidator.accessViolation(7, "Isolated access control entry at " + aceNode.getPath());
        }
        this.checkValidPrincipal(aceNode);
        this.checkValidPrivileges(aceNode);
        this.checkValidRestrictions(aceNode);
    }

    private void checkValidPrincipal(@Nonnull Tree aceNode) throws CommitFailedException {
        String principalName = TreeUtil.getString((Tree)aceNode, (String)"rep:principalName");
        if (principalName == null || principalName.isEmpty()) {
            throw AccessControlValidator.accessViolation(8, "Missing principal name at " + aceNode.getPath());
        }
    }

    private void checkValidPrivileges(@Nonnull Tree aceNode) throws CommitFailedException {
        Iterable privilegeNames = TreeUtil.getStrings((Tree)aceNode, (String)"rep:privileges");
        if (privilegeNames == null || Iterables.isEmpty((Iterable)privilegeNames)) {
            throw AccessControlValidator.accessViolation(9, "Missing privileges at " + aceNode.getPath());
        }
        for (String privilegeName : privilegeNames) {
            try {
                Privilege privilege = this.privilegeManager.getPrivilege(privilegeName);
                if (!privilege.isAbstract()) continue;
                throw AccessControlValidator.accessViolation(11, "Abstract privilege " + privilegeName + " at " + aceNode.getPath());
            }
            catch (AccessControlException e) {
                throw AccessControlValidator.accessViolation(10, "Invalid privilege " + privilegeName + " at " + aceNode.getPath());
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Failed to read privileges", e);
            }
        }
    }

    private void checkValidRestrictions(@Nonnull Tree aceTree) throws CommitFailedException {
        Tree aclTree = (Tree)Preconditions.checkNotNull((Object)aceTree.getParent());
        String aclPath = aclTree.getPath();
        String path = "rep:repoPolicy".equals(Text.getName((String)aclPath)) ? null : Text.getRelativeParent((String)aclPath, (int)1);
        try {
            this.restrictionProvider.validateRestrictions(path, aceTree);
        }
        catch (AccessControlException e) {
            throw new CommitFailedException("AccessControl", 1, "Access control violation", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CommitFailedException("Oak", 13, "Internal error", (Throwable)e);
        }
    }

    private static void checkMixinTypes(Tree parentTree) throws CommitFailedException {
        Iterable mixinNames = TreeUtil.getNames((Tree)parentTree, (String)"jcr:mixinTypes");
        if (Iterables.contains((Iterable)mixinNames, (Object)"rep:RepoAccessControllable")) {
            AccessControlValidator.checkValidRepoAccessControlled(parentTree);
        }
    }

    private static void checkValidRepoAccessControlled(Tree accessControlledTree) throws CommitFailedException {
        if (!accessControlledTree.isRoot()) {
            throw AccessControlValidator.accessViolation(12, "Only root can store repository level policies (" + accessControlledTree.getPath() + ')');
        }
    }

    private static CommitFailedException accessViolation(int code, String message) {
        return new CommitFailedException("AccessControl", code, message);
    }

    private final class Entry {
        private final String principalName;
        private final PrivilegeBits privilegeBits;
        private final Set<Restriction> restrictions;

        private Entry(String path, Tree aceTree) {
            this.principalName = (String)aceTree.getProperty("rep:principalName").getValue(Type.STRING);
            this.privilegeBits = AccessControlValidator.this.privilegeBitsProvider.getBits((Iterable)aceTree.getProperty("rep:privileges").getValue(Type.NAMES));
            this.restrictions = AccessControlValidator.this.restrictionProvider.readRestrictions(path, aceTree);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.principalName, this.privilegeBits, this.restrictions});
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                return Objects.equal((Object)this.principalName, (Object)other.principalName) && this.privilegeBits.equals((Object)other.privilegeBits) && this.restrictions.equals(other.restrictions);
            }
            return false;
        }
    }
}

