/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeContext;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeTreePermission;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;

class CompositePermissionProvider
implements AggregatedPermissionProvider {
    private final Root root;
    private final AggregatedPermissionProvider[] pps;
    private final Context ctx;
    private final CompositeAuthorizationConfiguration.CompositionType compositionType;
    private final RootProvider rootProvider;
    private final RepositoryPermission repositoryPermission;
    private Root immutableRoot;
    private PrivilegeBitsProvider privilegeBitsProvider;
    private TreeTypeProvider typeProvider;

    CompositePermissionProvider(@Nonnull Root root, @Nonnull List<AggregatedPermissionProvider> pps, @Nonnull Context acContext, @Nonnull CompositeAuthorizationConfiguration.CompositionType compositionType, @Nonnull RootProvider rootProvider) {
        this.root = root;
        this.pps = pps.toArray(new AggregatedPermissionProvider[pps.size()]);
        this.ctx = acContext;
        this.compositionType = compositionType;
        this.rootProvider = rootProvider;
        this.repositoryPermission = new CompositeRepositoryPermission(this.pps, this.compositionType);
        this.immutableRoot = rootProvider.createReadOnlyRoot(root);
        this.privilegeBitsProvider = new PrivilegeBitsProvider(this.immutableRoot);
        this.typeProvider = new TreeTypeProvider((TreeContext)this.ctx);
    }

    public void refresh() {
        this.immutableRoot = this.rootProvider.createReadOnlyRoot(this.root);
        this.privilegeBitsProvider = new PrivilegeBitsProvider(this.immutableRoot);
        for (AggregatedPermissionProvider pp : this.pps) {
            pp.refresh();
        }
    }

    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        Tree immutableTree = PermissionUtil.getImmutableTree(tree, this.immutableRoot);
        PrivilegeBits result = PrivilegeBits.getInstance();
        PrivilegeBits denied = PrivilegeBits.getInstance();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(immutableTree, null).modifiable();
            if (!CompositePermissionProvider.doEvaluate(supported)) continue;
            PrivilegeBits granted = this.privilegeBitsProvider.getBits((Iterable)aggregatedPermissionProvider.getPrivileges(immutableTree));
            if (!granted.isEmpty()) {
                result.add(granted);
            }
            if (this.compositionType != CompositeAuthorizationConfiguration.CompositionType.AND) continue;
            denied.add(supported.diff(granted));
        }
        if (!denied.isEmpty()) {
            result.diff(denied);
        }
        return this.privilegeBitsProvider.getPrivilegeNames(result);
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        Tree immutableTree = PermissionUtil.getImmutableTree(tree, this.immutableRoot);
        PrivilegeBits privilegeBits = this.privilegeBitsProvider.getBits(privilegeNames);
        if (privilegeBits.isEmpty()) {
            return true;
        }
        boolean hasPrivileges = false;
        PrivilegeBits coveredPrivs = PrivilegeBits.getInstance();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(immutableTree, privilegeBits);
            if (!CompositePermissionProvider.doEvaluate(supported)) continue;
            Set supportedNames = this.privilegeBitsProvider.getPrivilegeNames(supported);
            if (this.compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
                hasPrivileges = aggregatedPermissionProvider.hasPrivileges(immutableTree, supportedNames.toArray(new String[supportedNames.size()]));
                if (!hasPrivileges) {
                    return false;
                }
                coveredPrivs.add(supported);
                continue;
            }
            for (String p : supportedNames) {
                if (!aggregatedPermissionProvider.hasPrivileges(immutableTree, new String[]{p})) continue;
                PrivilegeBits granted = this.privilegeBitsProvider.getBits(new String[]{p});
                coveredPrivs.add(granted);
                hasPrivileges = true;
            }
        }
        return hasPrivileges && coveredPrivs.includes(privilegeBits);
    }

    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return this.repositoryPermission;
    }

    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        ImmutableTree immutableTree = (ImmutableTree)PermissionUtil.getImmutableTree(tree, this.immutableRoot);
        if (tree.isRoot()) {
            return CompositeTreePermission.create(immutableTree, this.typeProvider, this.pps, this.compositionType);
        }
        if (parentPermission instanceof CompositeTreePermission) {
            return CompositeTreePermission.create(immutableTree, (CompositeTreePermission)parentPermission);
        }
        return parentPermission.getChildPermission(immutableTree.getName(), immutableTree.getNodeState());
    }

    public boolean isGranted(@Nonnull Tree parent, @Nullable PropertyState property, long permissions) {
        Tree immParent = PermissionUtil.getImmutableTree(parent, this.immutableRoot);
        boolean isGranted = false;
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            long supportedPermissions = aggregatedPermissionProvider.supportedPermissions(immParent, property, permissions);
            if (!CompositePermissionProvider.doEvaluate(supportedPermissions)) continue;
            if (this.compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
                isGranted = aggregatedPermissionProvider.isGranted(immParent, property, supportedPermissions);
                if (!isGranted) {
                    return false;
                }
                coveredPermissions |= supportedPermissions;
                continue;
            }
            Iterator iterator = Permissions.aggregates((long)permissions).iterator();
            while (iterator.hasNext()) {
                long p = (Long)iterator.next();
                if (!aggregatedPermissionProvider.isGranted(immParent, property, p)) continue;
                coveredPermissions |= p;
                isGranted = true;
            }
        }
        return isGranted && coveredPermissions == permissions;
    }

    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        TreeLocation location = TreeLocation.create((Root)this.immutableRoot, (String)oakPath);
        boolean isAcContent = this.ctx.definesLocation(location);
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)location, (boolean)isAcContent);
        return this.isGranted(location, permissions);
    }

    private static boolean doEvaluate(long supportedPermissions) {
        return supportedPermissions != 0L;
    }

    private static boolean doEvaluate(PrivilegeBits supportedPrivileges) {
        return !supportedPrivileges.isEmpty();
    }

    @Nonnull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        PrivilegeBits result = PrivilegeBits.getInstance();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(tree, privilegeBits);
            result.add(supported);
        }
        return result;
    }

    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        return this.supportedPermissions(aggregatedPermissionProvider -> aggregatedPermissionProvider.supportedPermissions(tree, property, permissions));
    }

    public long supportedPermissions(TreeLocation location, long permissions) {
        return this.supportedPermissions(aggregatedPermissionProvider -> aggregatedPermissionProvider.supportedPermissions(location, permissions));
    }

    public long supportedPermissions(TreePermission treePermission, PropertyState property, long permissions) {
        return this.supportedPermissions(aggregatedPermissionProvider -> aggregatedPermissionProvider.supportedPermissions(treePermission, property, permissions));
    }

    private long supportedPermissions(Function<AggregatedPermissionProvider, Long> supported) {
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            long supportedPermissions = supported.apply(aggregatedPermissionProvider);
            coveredPermissions |= supportedPermissions;
        }
        return coveredPermissions;
    }

    public boolean isGranted(@Nonnull TreeLocation location, long permissions) {
        Tree tree;
        PropertyState property = location.getProperty();
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return this.isGranted(tree, property, permissions);
        }
        boolean isGranted = false;
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            long supportedPermissions = aggregatedPermissionProvider.supportedPermissions(location, permissions);
            if (!CompositePermissionProvider.doEvaluate(supportedPermissions)) continue;
            if (this.compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
                isGranted = aggregatedPermissionProvider.isGranted(location, supportedPermissions);
                if (!isGranted) {
                    return false;
                }
                coveredPermissions |= supportedPermissions;
                continue;
            }
            Iterator iterator = Permissions.aggregates((long)permissions).iterator();
            while (iterator.hasNext()) {
                long p = (Long)iterator.next();
                if (!aggregatedPermissionProvider.isGranted(location, p)) continue;
                coveredPermissions |= p;
                isGranted = true;
            }
        }
        return isGranted && coveredPermissions == permissions;
    }

    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parentPermission) {
        ImmutableTree immutableTree = (ImmutableTree)PermissionUtil.getImmutableTree(tree, this.immutableRoot);
        if (tree.isRoot()) {
            return CompositeTreePermission.create(immutableTree, this.typeProvider, this.pps, this.compositionType);
        }
        if (parentPermission instanceof CompositeTreePermission) {
            return CompositeTreePermission.create(immutableTree, (CompositeTreePermission)parentPermission, type);
        }
        return parentPermission.getChildPermission(immutableTree.getName(), immutableTree.getNodeState());
    }

    private static final class CompositeRepositoryPermission
    implements RepositoryPermission {
        private final AggregatedPermissionProvider[] pps;
        private final CompositeAuthorizationConfiguration.CompositionType compositionType;

        public CompositeRepositoryPermission(@Nonnull AggregatedPermissionProvider[] pps, @Nonnull CompositeAuthorizationConfiguration.CompositionType compositionType) {
            this.pps = pps;
            this.compositionType = compositionType;
        }

        public boolean isGranted(long repositoryPermissions) {
            boolean isGranted = false;
            long coveredPermissions = 0L;
            for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
                long supportedPermissions = aggregatedPermissionProvider.supportedPermissions((Tree)null, null, repositoryPermissions);
                if (!CompositePermissionProvider.doEvaluate(supportedPermissions)) continue;
                RepositoryPermission rp = aggregatedPermissionProvider.getRepositoryPermission();
                if (this.compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
                    isGranted = rp.isGranted(supportedPermissions);
                    if (!isGranted) {
                        return false;
                    }
                    coveredPermissions |= supportedPermissions;
                    continue;
                }
                Iterator iterator = Permissions.aggregates((long)repositoryPermissions).iterator();
                while (iterator.hasNext()) {
                    long p = (Long)iterator.next();
                    if (!rp.isGranted(p)) continue;
                    coveredPermissions |= p;
                    isGranted = true;
                }
            }
            return isGranted && coveredPermissions == repositoryPermissions;
        }
    }
}

