/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PermissionStoreEditor
implements AccessControlConstants,
PermissionConstants {
    private static final Logger log = LoggerFactory.getLogger(PermissionStoreEditor.class);
    private final String accessControlledPath;
    private final String nodeName;
    private final Map<String, List<AcEntry>> entries = Maps.newHashMap();
    private final NodeBuilder permissionRoot;

    PermissionStoreEditor(@Nonnull String aclPath, @Nonnull String name, @Nonnull NodeState node, @Nonnull NodeBuilder permissionRoot, @Nonnull TypePredicate isACE, @Nonnull TypePredicate isGrantACE, @Nonnull PrivilegeBitsProvider bitsProvider, @Nonnull RestrictionProvider restrictionProvider, @Nonnull TreeProvider treeProvider) {
        this.permissionRoot = permissionRoot;
        this.accessControlledPath = name.equals("rep:repoPolicy") ? "" : (aclPath.isEmpty() ? "/" : aclPath);
        this.nodeName = PermissionUtil.getEntryName(this.accessControlledPath);
        LinkedHashSet orderedChildNames = Sets.newLinkedHashSet((Iterable)node.getNames(":childOrder"));
        long n = orderedChildNames.size();
        if (node.getChildNodeCount(n + 1L) > n) {
            Iterables.addAll((Collection)orderedChildNames, (Iterable)node.getChildNodeNames());
        }
        PrivilegeBits jcrAll = bitsProvider.getBits(new String[]{"jcr:all"});
        int index = 0;
        for (String childName : orderedChildNames) {
            NodeState ace = node.getChildNode(childName);
            if (!isACE.apply(ace)) continue;
            boolean isAllow = isGrantACE.apply(ace);
            PrivilegeBits privilegeBits = bitsProvider.getBits(ace.getNames("rep:privileges"));
            Set restrictions = restrictionProvider.readRestrictions(Strings.emptyToNull((String)this.accessControlledPath), treeProvider.createReadOnlyTree(ace));
            AcEntry entry = privilegeBits.equals((Object)jcrAll) ? new JcrAllAcEntry(ace, this.accessControlledPath, index, isAllow, privilegeBits, restrictions) : new AcEntry(ace, this.accessControlledPath, index, isAllow, privilegeBits, restrictions);
            List<AcEntry> list = this.entries.get(entry.principalName);
            if (list == null) {
                list = new ArrayList<AcEntry>();
                this.entries.put(entry.principalName, list);
            }
            list.add(entry);
            ++index;
        }
    }

    String getPath() {
        return this.accessControlledPath;
    }

    boolean isEmpty() {
        return this.entries.isEmpty();
    }

    void removePermissionEntries(PermissionStoreEditor otherEditor) {
        this.entries.keySet().removeAll(otherEditor.entries.keySet());
    }

    void removePermissionEntries() {
        for (String principalName : this.entries.keySet()) {
            if (this.permissionRoot.hasChildNode(principalName)) {
                NodeBuilder principalRoot = this.permissionRoot.getChildNode(principalName);
                NodeBuilder parent = principalRoot.getChildNode(this.nodeName);
                if (!parent.exists()) continue;
                if (PermissionUtil.checkACLPath(parent, this.accessControlledPath)) {
                    NodeBuilder newParent = null;
                    for (String childName : parent.getChildNodeNames()) {
                        if (childName.charAt(0) != 'c') continue;
                        NodeBuilder child = parent.getChildNode(childName);
                        if (newParent == null) {
                            newParent = child;
                            continue;
                        }
                        newParent.setChildNode(childName, child.getNodeState());
                        child.remove();
                    }
                    parent.remove();
                    if (newParent == null) continue;
                    principalRoot.setChildNode(this.nodeName, newParent.getNodeState());
                    continue;
                }
                for (String childName : parent.getChildNodeNames()) {
                    NodeBuilder child;
                    if (childName.charAt(0) != 'c' || !PermissionUtil.checkACLPath(child = parent.getChildNode(childName), this.accessControlledPath)) continue;
                    child.remove();
                }
                continue;
            }
            log.error("Unable to remove permission entry {}: Principal root missing.", (Object)this);
        }
    }

    void updatePermissionEntries() {
        for (Map.Entry<String, List<AcEntry>> entry : this.entries.entrySet()) {
            NodeBuilder parent;
            String principalName = entry.getKey();
            NodeBuilder principalRoot = this.permissionRoot.child(principalName);
            if (!principalRoot.hasProperty("jcr:primaryType")) {
                principalRoot.setProperty("jcr:primaryType", (Object)"rep:PermissionStore", Type.NAME);
            }
            if (!(parent = principalRoot.child(this.nodeName)).hasProperty("jcr:primaryType")) {
                parent.setProperty("jcr:primaryType", (Object)"rep:PermissionStore", Type.NAME);
            }
            if (parent.hasProperty("rep:accessControlledPath")) {
                if (!PermissionUtil.checkACLPath(parent, this.accessControlledPath)) {
                    NodeBuilder child = null;
                    int idx = 0;
                    for (String childName : parent.getChildNodeNames()) {
                        if (childName.charAt(0) != 'c') continue;
                        child = parent.getChildNode(childName);
                        if (PermissionUtil.checkACLPath(child, this.accessControlledPath)) break;
                        child = null;
                        ++idx;
                    }
                    while (child == null) {
                        String name = 'c' + String.valueOf(idx++);
                        child = parent.getChildNode(name);
                        if (child.exists()) {
                            child = null;
                            continue;
                        }
                        child = parent.child(name);
                        child.setProperty("jcr:primaryType", (Object)"rep:PermissionStore", Type.NAME);
                    }
                    parent = child;
                    parent.setProperty("rep:accessControlledPath", (Object)this.accessControlledPath);
                }
            } else {
                parent.setProperty("rep:accessControlledPath", (Object)this.accessControlledPath);
            }
            this.updateEntries(parent, entry.getValue());
        }
    }

    private void updateEntries(NodeBuilder parent, List<AcEntry> list) {
        for (String childName : parent.getChildNodeNames()) {
            if (childName.charAt(0) == 'c') continue;
            parent.getChildNode(childName).remove();
        }
        for (AcEntry ace : list) {
            ace.writeToPermissionStore(parent);
        }
    }

    private class AcEntry {
        private final String accessControlledPath;
        private final String principalName;
        private final PrivilegeBits privilegeBits;
        private final boolean isAllow;
        private final Set<Restriction> restrictions;
        private final int index;
        private int hashCode = -1;

        private AcEntry(@Nonnull NodeState node, String accessControlledPath, int index, @Nonnull boolean isAllow, @Nonnull PrivilegeBits privilegeBits, Set<Restriction> restrictions) {
            this.accessControlledPath = accessControlledPath;
            this.index = index;
            this.principalName = Text.escapeIllegalJcrChars((String)node.getString("rep:principalName"));
            this.privilegeBits = privilegeBits;
            this.isAllow = isAllow;
            this.restrictions = restrictions;
        }

        private void writeToPermissionStore(NodeBuilder parent) {
            NodeBuilder n = parent.child(String.valueOf(this.index)).setProperty("jcr:primaryType", (Object)"rep:Permissions", Type.NAME).setProperty("rep:isAllow", (Object)this.isAllow).setProperty(this.getPrivilegeBitsProperty());
            for (Restriction restriction : this.restrictions) {
                n.setProperty(restriction.getProperty());
            }
        }

        protected PropertyState getPrivilegeBitsProperty() {
            return this.privilegeBits.asPropertyState("rep:privileges");
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = Objects.hashCode((Object[])new Object[]{this.accessControlledPath, this.principalName, this.privilegeBits, this.isAllow, this.restrictions});
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AcEntry) {
                AcEntry other = (AcEntry)o;
                return this.isAllow == other.isAllow && this.privilegeBits.equals((Object)other.privilegeBits) && this.principalName.equals(other.principalName) && this.accessControlledPath.equals(other.accessControlledPath) && this.restrictions.equals(other.restrictions);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.accessControlledPath);
            sb.append(';').append(this.principalName);
            sb.append(';').append(this.isAllow ? "allow" : "deny");
            sb.append(';').append(this.privilegeBits);
            sb.append(';').append(this.restrictions);
            return sb.toString();
        }
    }

    private final class JcrAllAcEntry
    extends AcEntry {
        private JcrAllAcEntry(@Nonnull NodeState node, String accessControlledPath, int index, @Nonnull boolean isAllow, @Nonnull PrivilegeBits privilegeBits, Set<Restriction> restrictions) {
            super(node, accessControlledPath, index, isAllow, privilegeBits, restrictions);
        }

        @Override
        protected PropertyState getPrivilegeBitsProperty() {
            return PropertyStates.createProperty((String)"rep:privileges", (Object)Longs.asList((long[])new long[]{-1L}), (Type)Type.LONGS);
        }
    }
}

