/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.privilege.JcrAllCommitHook;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeContext;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeInitializer;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeManagerImpl;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={PrivilegeConfiguration.class, SecurityConfiguration.class})
public class PrivilegeConfigurationImpl
extends ConfigurationBase
implements PrivilegeConfiguration {
    @Nonnull
    public PrivilegeManager getPrivilegeManager(Root root, NamePathMapper namePathMapper) {
        return new PrivilegeManagerImpl(root, namePathMapper);
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.privilege";
    }

    @Nonnull
    public RepositoryInitializer getRepositoryInitializer() {
        return new PrivilegeInitializer(this.getRootProvider());
    }

    @Nonnull
    public List<? extends CommitHook> getCommitHooks(@Nonnull String workspaceName) {
        return Collections.singletonList(new JcrAllCommitHook());
    }

    @Nonnull
    public List<? extends ValidatorProvider> getValidators(@Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull MoveTracker moveTracker) {
        return Collections.singletonList(new PrivilegeValidatorProvider(this.getRootProvider()));
    }

    @Nonnull
    public Context getContext() {
        return PrivilegeContext.getInstance();
    }
}

