/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueFactoryImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.AuthorizableProperties;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthorizablePropertiesImpl
implements AuthorizableProperties {
    private static final Logger log = LoggerFactory.getLogger(AuthorizablePropertiesImpl.class);
    private final AuthorizableImpl authorizable;
    private final NamePathMapper namePathMapper;

    AuthorizablePropertiesImpl(@Nonnull AuthorizableImpl authorizable, @Nonnull NamePathMapper namePathMapper) {
        this.authorizable = authorizable;
        this.namePathMapper = namePathMapper;
    }

    @Override
    @Nonnull
    public Iterator<String> getNames(@Nonnull String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        Tree tree = this.getTree();
        TreeLocation location = AuthorizablePropertiesImpl.getLocation(tree, oakPath);
        Tree parent = location.getTree();
        if (parent != null && Text.isDescendantOrEqual((String)tree.getPath(), (String)parent.getPath())) {
            ArrayList<String> l = new ArrayList<String>();
            for (PropertyState property : parent.getProperties()) {
                String propName = property.getName();
                if (!this.isAuthorizableProperty(tree, location.getChild(propName), false)) continue;
                l.add(this.namePathMapper.getJcrName(propName));
            }
            return l.iterator();
        }
        throw new RepositoryException("Relative path " + relPath + " refers to non-existing tree or tree outside of scope of authorizable.");
    }

    @Override
    public boolean hasProperty(@Nonnull String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        return this.isAuthorizableProperty(this.getTree(), AuthorizablePropertiesImpl.getLocation(this.getTree(), oakPath), true);
    }

    @Override
    public Value[] getProperty(@Nonnull String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        Tree tree = this.getTree();
        Value[] values = null;
        PropertyState property = this.getAuthorizableProperty(tree, AuthorizablePropertiesImpl.getLocation(tree, oakPath), true);
        if (property != null) {
            if (property.isArray()) {
                List vs = ValueFactoryImpl.createValues((PropertyState)property, (NamePathMapper)this.namePathMapper);
                values = vs.toArray(new Value[vs.size()]);
            } else {
                values = new Value[]{ValueFactoryImpl.createValue((PropertyState)property, (NamePathMapper)this.namePathMapper)};
            }
        }
        return values;
    }

    @Override
    public void setProperty(@Nonnull String relPath, @Nullable Value value) throws RepositoryException {
        if (value == null) {
            this.removeProperty(relPath);
        } else {
            String oakPath = this.getOakPath(relPath);
            String name = Text.getName((String)oakPath);
            PropertyState propertyState = PropertyStates.createProperty((String)name, (Value)value);
            String intermediate = oakPath.equals(name) ? null : Text.getRelativeParent((String)oakPath, (int)1);
            Tree parent = this.getOrCreateTargetTree(intermediate);
            this.checkProtectedProperty(parent, propertyState);
            parent.setProperty(propertyState);
        }
    }

    @Override
    public void setProperty(@Nonnull String relPath, @Nullable Value[] values) throws RepositoryException {
        if (values == null) {
            this.removeProperty(relPath);
        } else {
            String oakPath = this.getOakPath(relPath);
            String name = Text.getName((String)oakPath);
            PropertyState propertyState = PropertyStates.createProperty((String)name, Arrays.asList(values));
            String intermediate = oakPath.equals(name) ? null : Text.getRelativeParent((String)oakPath, (int)1);
            Tree parent = this.getOrCreateTargetTree(intermediate);
            this.checkProtectedProperty(parent, propertyState);
            parent.setProperty(propertyState);
        }
    }

    @Override
    public boolean removeProperty(@Nonnull String relPath) throws RepositoryException {
        String oakPath = this.getOakPath(relPath);
        Tree node = this.getTree();
        TreeLocation propertyLocation = AuthorizablePropertiesImpl.getLocation(node, oakPath);
        if (propertyLocation.getProperty() != null) {
            if (this.isAuthorizableProperty(node, propertyLocation, true)) {
                return propertyLocation.remove();
            }
            throw new ConstraintViolationException("Property " + relPath + " isn't a modifiable authorizable property");
        }
        AuthorizablePropertiesImpl.checkScope(node.getPath(), propertyLocation.getPath(), relPath);
        return false;
    }

    @Nonnull
    private Tree getTree() {
        return this.authorizable.getTree();
    }

    private boolean isAuthorizableProperty(@Nonnull Tree authorizableTree, @Nonnull TreeLocation propertyLocation, boolean verifyAncestor) throws RepositoryException {
        return this.getAuthorizableProperty(authorizableTree, propertyLocation, verifyAncestor) != null;
    }

    @CheckForNull
    private PropertyState getAuthorizableProperty(@Nonnull Tree authorizableTree, @Nonnull TreeLocation propertyLocation, boolean verifyAncestor) throws RepositoryException {
        PropertyState property = propertyLocation.getProperty();
        if (property == null) {
            return null;
        }
        String authorizablePath = authorizableTree.getPath();
        if (verifyAncestor && !Text.isDescendant((String)authorizablePath, (String)propertyLocation.getPath())) {
            log.debug("Attempt to access property outside of authorizable scope.");
            return null;
        }
        Tree parent = propertyLocation.getParent().getTree();
        if (parent == null) {
            log.debug("Unable to determine definition of authorizable property at " + propertyLocation.getPath());
            return null;
        }
        ReadOnlyNodeTypeManager nodeTypeManager = this.authorizable.getUserManager().getNodeTypeManager();
        PropertyDefinition def = nodeTypeManager.getDefinition(parent, property, true);
        if (def.isProtected() || authorizablePath.equals(parent.getPath()) && !def.getDeclaringNodeType().isNodeType("rep:Authorizable")) {
            return null;
        }
        return property;
    }

    private void checkProtectedProperty(@Nonnull Tree parent, @Nonnull PropertyState property) throws RepositoryException {
        ReadOnlyNodeTypeManager nodeTypeManager = this.authorizable.getUserManager().getNodeTypeManager();
        PropertyDefinition def = nodeTypeManager.getDefinition(parent, property, false);
        if (def.isProtected()) {
            throw new ConstraintViolationException("Attempt to set an protected property " + property.getName());
        }
    }

    @Nonnull
    private Tree getOrCreateTargetTree(@CheckForNull String relPath) throws RepositoryException {
        Tree targetTree;
        Tree userTree = this.getTree();
        if (relPath != null) {
            String userPath = userTree.getPath();
            targetTree = AuthorizablePropertiesImpl.getLocation(userTree, relPath).getTree();
            if (targetTree != null) {
                AuthorizablePropertiesImpl.checkScope(userPath, targetTree.getPath(), relPath);
            } else {
                targetTree = Utils.getOrAddTree(userTree, relPath, "nt:unstructured");
                AuthorizablePropertiesImpl.checkScope(userPath, targetTree.getPath(), relPath);
            }
        } else {
            targetTree = userTree;
        }
        return targetTree;
    }

    @Nonnull
    private static TreeLocation getLocation(@Nonnull Tree tree, @Nonnull String relativePath) {
        TreeLocation loc = TreeLocation.create((Tree)tree);
        for (String element : Text.explode((String)relativePath, (int)47, (boolean)false)) {
            if (PathUtils.denotesParent((String)element)) {
                loc = loc.getParent();
                continue;
            }
            if (PathUtils.denotesCurrent((String)element)) continue;
            loc = loc.getChild(element);
        }
        return loc;
    }

    @Nonnull
    private String getOakPath(@CheckForNull String relPath) throws RepositoryException {
        if (relPath == null || relPath.isEmpty() || relPath.charAt(0) == '/') {
            throw new RepositoryException("Relative path expected. Found " + relPath);
        }
        String oakPath = this.namePathMapper.getOakPath(relPath);
        if (oakPath == null) {
            throw new RepositoryException("Failed to resolve relative path: " + relPath);
        }
        return oakPath;
    }

    private static void checkScope(@Nonnull String userPath, @Nonnull String targetPath, @Nonnull String relPath) throws RepositoryException {
        if (!Text.isDescendantOrEqual((String)userPath, (String)targetPath)) {
            throw new RepositoryException("Relative path " + relPath + " outside of scope of " + userPath);
        }
    }
}

