/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.GroupImpl;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.SystemUserImpl;
import org.apache.jackrabbit.oak.security.user.UserImpl;
import org.apache.jackrabbit.oak.security.user.UserProvider;
import org.apache.jackrabbit.oak.security.user.query.UserQueryManager;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.GroupAction;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerImpl
implements UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private final Root root;
    private final NamePathMapper namePathMapper;
    private final SecurityProvider securityProvider;
    private final UserProvider userProvider;
    private final MembershipProvider membershipProvider;
    private final ConfigurationParameters config;
    private final AuthorizableActionProvider actionProvider;
    private UserQueryManager queryManager;
    private ReadOnlyNodeTypeManager ntMgr;

    public UserManagerImpl(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper, @Nonnull SecurityProvider securityProvider) {
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.securityProvider = securityProvider;
        UserConfiguration uc = (UserConfiguration)securityProvider.getConfiguration(UserConfiguration.class);
        this.config = uc.getParameters();
        this.userProvider = new UserProvider(root, this.config);
        this.membershipProvider = new MembershipProvider(root, this.config);
        this.actionProvider = UserManagerImpl.getActionProvider(this.config);
    }

    @Nonnull
    private static AuthorizableActionProvider getActionProvider(@Nonnull ConfigurationParameters config) {
        AuthorizableActionProvider actionProvider = (AuthorizableActionProvider)config.getConfigValue("authorizableActionProvider", null, AuthorizableActionProvider.class);
        if (actionProvider == null) {
            actionProvider = new DefaultAuthorizableActionProvider(config);
        }
        return actionProvider;
    }

    public Authorizable getAuthorizable(String id) throws RepositoryException {
        Tree tree;
        Authorizable authorizable = null;
        Tree tree2 = tree = Strings.isNullOrEmpty((String)id) ? null : this.userProvider.getAuthorizable(id);
        if (tree != null) {
            authorizable = this.getAuthorizable(UserUtil.getAuthorizableId((Tree)tree), tree);
        }
        return authorizable;
    }

    public <T extends Authorizable> T getAuthorizable(String id, Class<T> authorizableClass) throws RepositoryException {
        return (T)UserUtil.castAuthorizable((Authorizable)this.getAuthorizable(id), authorizableClass);
    }

    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        return principal == null ? null : this.getAuthorizable(this.userProvider.getAuthorizableByPrincipal(principal));
    }

    public Authorizable getAuthorizableByPath(String path) throws RepositoryException {
        String oakPath = this.namePathMapper.getOakPath(path);
        if (oakPath == null) {
            throw new RepositoryException("Invalid path " + path);
        }
        return this.getAuthorizableByOakPath(oakPath);
    }

    public Iterator<Authorizable> findAuthorizables(String relPath, String value) throws RepositoryException {
        return this.findAuthorizables(relPath, value, 3);
    }

    public Iterator<Authorizable> findAuthorizables(String relPath, String value, int searchType) throws RepositoryException {
        return this.getQueryManager().findAuthorizables(relPath, value, AuthorizableType.getType((int)searchType));
    }

    public Iterator<Authorizable> findAuthorizables(Query query) throws RepositoryException {
        return this.getQueryManager().findAuthorizables(query);
    }

    public User createUser(String userID, String password) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(userID);
        return this.createUser(userID, password, (Principal)principal, null);
    }

    public User createUser(String userID, String password, Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        this.checkValidId(userID);
        this.checkValidPrincipal(principal, false);
        if (intermediatePath != null) {
            intermediatePath = this.namePathMapper.getOakPath(intermediatePath);
        }
        Tree userTree = this.userProvider.createUser(userID, intermediatePath);
        this.setPrincipal(userTree, principal);
        if (password != null) {
            this.setPassword(userTree, userID, password, true);
        }
        UserImpl user = new UserImpl(userID, userTree, this);
        this.onCreate(user, password);
        log.debug("User created: " + userID);
        return user;
    }

    public User createSystemUser(String userID, String intermediatePath) throws RepositoryException {
        this.checkValidId(userID);
        PrincipalImpl principal = new PrincipalImpl(userID);
        this.checkValidPrincipal((Principal)principal, false);
        Tree userTree = this.userProvider.createSystemUser(userID, intermediatePath);
        this.setPrincipal(userTree, (Principal)principal);
        SystemUserImpl user = new SystemUserImpl(userID, userTree, this);
        log.debug("System user created: " + userID);
        return user;
    }

    public Group createGroup(String groupId) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(groupId);
        return this.createGroup(groupId, (Principal)principal, null);
    }

    public Group createGroup(Principal principal) throws RepositoryException {
        return this.createGroup(principal, null);
    }

    public Group createGroup(Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.createGroup(principal.getName(), principal, intermediatePath);
    }

    public Group createGroup(String groupID, Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        this.checkValidId(groupID);
        this.checkValidPrincipal(principal, true);
        if (intermediatePath != null) {
            intermediatePath = this.namePathMapper.getOakPath(intermediatePath);
        }
        Tree groupTree = this.userProvider.createGroup(groupID, intermediatePath);
        this.setPrincipal(groupTree, principal);
        GroupImpl group = new GroupImpl(groupID, groupTree, this);
        this.onCreate(group);
        log.debug("Group created: " + groupID);
        return group;
    }

    public boolean isAutoSave() {
        return false;
    }

    public void autoSave(boolean enable) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Session#save() is always required.");
    }

    void onCreate(@Nonnull User user, @CheckForNull String password) throws RepositoryException {
        if (!user.isSystemUser()) {
            for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
                action.onCreate(user, password, this.root, this.namePathMapper);
            }
        } else {
            log.debug("Omit onCreate action for system users.");
        }
    }

    void onCreate(@Nonnull Group group) throws RepositoryException {
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            action.onCreate(group, this.root, this.namePathMapper);
        }
    }

    void onRemove(@Nonnull Authorizable authorizable) throws RepositoryException {
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            action.onRemove(authorizable, this.root, this.namePathMapper);
        }
    }

    void onPasswordChange(@Nonnull User user, @Nonnull String password) throws RepositoryException {
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            action.onPasswordChange(user, password, this.root, this.namePathMapper);
        }
    }

    void onGroupUpdate(@Nonnull Group group, boolean isRemove, @Nonnull Authorizable member) throws RepositoryException {
        for (GroupAction action : this.selectGroupActions()) {
            if (isRemove) {
                action.onMemberRemoved(group, member, this.root, this.namePathMapper);
                continue;
            }
            action.onMemberAdded(group, member, this.root, this.namePathMapper);
        }
    }

    void onGroupUpdate(@Nonnull Group group, boolean isRemove, boolean isContentId, @Nonnull Set<String> memberIds, @Nonnull Set<String> failedIds) throws RepositoryException {
        for (GroupAction action : this.selectGroupActions()) {
            if (isRemove) {
                action.onMembersRemoved(group, memberIds, failedIds, this.root, this.namePathMapper);
                continue;
            }
            if (isContentId) {
                action.onMembersAddedContentId(group, memberIds, failedIds, this.root, this.namePathMapper);
                continue;
            }
            action.onMembersAdded(group, memberIds, failedIds, this.root, this.namePathMapper);
        }
    }

    @CheckForNull
    public Authorizable getAuthorizable(@CheckForNull Tree tree) throws RepositoryException {
        if (tree == null || !tree.exists()) {
            return null;
        }
        return this.getAuthorizable(UserUtil.getAuthorizableId((Tree)tree), tree);
    }

    @CheckForNull
    Authorizable getAuthorizableByOakPath(@Nonnull String oakPath) throws RepositoryException {
        return this.getAuthorizable(this.userProvider.getAuthorizableByPath(oakPath));
    }

    @Nonnull
    NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @Nonnull
    ReadOnlyNodeTypeManager getNodeTypeManager() {
        if (this.ntMgr == null) {
            this.ntMgr = ReadOnlyNodeTypeManager.getInstance(this.root, NamePathMapper.DEFAULT);
        }
        return this.ntMgr;
    }

    @Nonnull
    MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }

    @Nonnull
    PrincipalManager getPrincipalManager() throws RepositoryException {
        return ((PrincipalConfiguration)this.securityProvider.getConfiguration(PrincipalConfiguration.class)).getPrincipalManager(this.root, this.namePathMapper);
    }

    @Nonnull
    ConfigurationParameters getConfig() {
        return this.config;
    }

    @CheckForNull
    private Authorizable getAuthorizable(@CheckForNull String id, @CheckForNull Tree tree) throws RepositoryException {
        if (id == null || tree == null) {
            return null;
        }
        if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.USER)) {
            if (UserUtil.isSystemUser((Tree)tree)) {
                return new SystemUserImpl(id, tree, this);
            }
            return new UserImpl(id, tree, this);
        }
        if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.GROUP)) {
            return new GroupImpl(id, tree, this);
        }
        throw new RepositoryException("Not a user or group tree " + tree.getPath() + '.');
    }

    private void checkValidId(@CheckForNull String id) throws RepositoryException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid ID " + id);
        }
        if (this.getAuthorizable(id) != null) {
            throw new AuthorizableExistsException("Authorizable with ID " + id + " already exists");
        }
    }

    void checkValidPrincipal(@CheckForNull Principal principal, boolean isGroup) throws RepositoryException {
        if (principal == null || Strings.isNullOrEmpty((String)principal.getName())) {
            throw new IllegalArgumentException("Principal may not be null and must have a valid name.");
        }
        if (!isGroup && "everyone".equals(principal.getName())) {
            throw new IllegalArgumentException("'everyone' is a reserved group principal name.");
        }
        if (this.getAuthorizable(principal) != null) {
            throw new AuthorizableExistsException("Authorizable with principal " + principal.getName() + " already exists.");
        }
    }

    void setPrincipal(@Nonnull Tree authorizableTree, @Nonnull Principal principal) {
        authorizableTree.setProperty("rep:principalName", (Object)principal.getName());
    }

    void setPassword(@Nonnull Tree userTree, @Nonnull String userId, @Nonnull String password, boolean forceHash) throws RepositoryException {
        boolean isNewUser;
        String pwHash;
        if (forceHash || PasswordUtil.isPlainTextPassword((String)password)) {
            try {
                pwHash = PasswordUtil.buildPasswordHash((String)password, (ConfigurationParameters)this.config);
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new RepositoryException((Throwable)e);
            }
        } else {
            pwHash = password;
        }
        userTree.setProperty("rep:password", (Object)pwHash);
        boolean expiryEnabled = this.passwordExpiryEnabled();
        boolean forceInitialPwChange = this.forceInitialPasswordChangeEnabled();
        boolean bl = isNewUser = userTree.getStatus() == Tree.Status.NEW;
        if (!UserUtil.isAdmin((ConfigurationParameters)this.config, (String)userId) && (expiryEnabled && !forceInitialPwChange || forceInitialPwChange && !isNewUser)) {
            Tree pwdTree = TreeUtil.getOrAddChild((Tree)userTree, (String)"rep:pwd", (String)"rep:Password");
            pwdTree.setProperty("rep:passwordLastModified", (Object)System.currentTimeMillis(), Type.LONG);
        }
    }

    private boolean passwordExpiryEnabled() {
        return (Integer)this.config.getConfigValue("passwordMaxAge", (Object)0) > 0;
    }

    private boolean forceInitialPasswordChangeEnabled() {
        return (Boolean)this.config.getConfigValue("initialPasswordChange", (Object)false);
    }

    @Nonnull
    private UserQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.queryManager = new UserQueryManager(this, this.namePathMapper, this.config, this.root);
        }
        return this.queryManager;
    }

    @Nonnull
    private List<GroupAction> selectGroupActions() {
        ArrayList actions = Lists.newArrayList();
        for (AuthorizableAction action : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            if (!(action instanceof GroupAction)) continue;
            actions.add((GroupAction)action);
        }
        return actions;
    }
}

