/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.namepath.PathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.AbstractGroupPrincipal;
import org.apache.jackrabbit.oak.security.user.AdminPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.CacheValidatorProvider;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.SystemUserPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserProvider;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserPrincipalProvider
implements PrincipalProvider {
    private static final Logger log = LoggerFactory.getLogger(UserPrincipalProvider.class);
    static final String PARAM_CACHE_EXPIRATION = "cacheExpiration";
    static final long EXPIRATION_NO_CACHE = 0L;
    private static final long MEMBERSHIP_THRESHOLD = 0L;
    private final Root root;
    private final UserConfiguration config;
    private final NamePathMapper namePathMapper;
    private final UserProvider userProvider;
    private final MembershipProvider membershipProvider;
    private final long expiration;
    private final boolean cacheEnabled;

    UserPrincipalProvider(@Nonnull Root root, @Nonnull UserConfiguration userConfiguration, @Nonnull NamePathMapper namePathMapper) {
        this.root = root;
        this.config = userConfiguration;
        this.namePathMapper = namePathMapper;
        this.userProvider = new UserProvider(root, this.config.getParameters());
        this.membershipProvider = new MembershipProvider(root, this.config.getParameters());
        this.expiration = (Long)this.config.getParameters().getConfigValue(PARAM_CACHE_EXPIRATION, (Object)0L);
        this.cacheEnabled = this.expiration > 0L && root.getContentSession().getAuthInfo().getPrincipals().contains(SystemPrincipal.INSTANCE);
    }

    public Principal getPrincipal(@Nonnull String principalName) {
        Tree authorizableTree = this.userProvider.getAuthorizableByPrincipal((Principal)new PrincipalImpl(principalName));
        Principal principal = this.createPrincipal(authorizableTree);
        if (principal == null) {
            return "everyone".equals(principalName) ? EveryonePrincipal.getInstance() : null;
        }
        return principal;
    }

    @Nonnull
    public Set<Group> getGroupMembership(@Nonnull Principal principal) {
        Tree tree = this.getAuthorizableTree(principal);
        if (tree == null) {
            return Collections.emptySet();
        }
        return this.getGroupMembership(tree);
    }

    @Nonnull
    public Set<? extends Principal> getPrincipals(@Nonnull String userID) {
        Principal userPrincipal;
        HashSet<Principal> principals = new HashSet<Principal>();
        Tree tree = this.userProvider.getAuthorizable(userID);
        if (tree != null && UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.USER) && (userPrincipal = this.createUserPrincipal(userID, tree)) != null) {
            principals.add(userPrincipal);
            principals.addAll(this.getGroupMembership(tree));
        }
        return principals;
    }

    @Nonnull
    public Iterator<? extends Principal> findPrincipals(String nameHint, int searchType) {
        try {
            AuthorizableType type = AuthorizableType.getType((int)searchType);
            StringBuilder statement = new StringBuilder().append(QueryUtil.getSearchRoot(type, this.config.getParameters())).append("//element(*,").append(QueryUtil.getNodeTypeName(type)).append(')').append("[jcr:like(@rep:principalName,'").append(UserPrincipalProvider.buildSearchPattern(nameHint)).append("')]");
            Result result = this.root.getQueryEngine().executeQuery(statement.toString(), "xpath", QueryEngine.NO_BINDINGS, this.namePathMapper.getSessionLocalMappings());
            Object principals = Iterators.filter((Iterator)Iterators.transform(result.getRows().iterator(), (Function)new ResultRowToPrincipal()), (Predicate)Predicates.notNull());
            if (UserPrincipalProvider.matchesEveryone(nameHint, searchType)) {
                principals = Iterators.concat((Iterator)principals, (Iterator)Iterators.singletonIterator((Object)EveryonePrincipal.getInstance()));
                return Iterators.filter((Iterator)principals, (Predicate)new EveryonePredicate());
            }
            return principals;
        }
        catch (ParseException e) {
            log.debug(e.getMessage());
            return Iterators.emptyIterator();
        }
    }

    @Nonnull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @CheckForNull
    private Tree getAuthorizableTree(@Nonnull Principal principal) {
        return this.userProvider.getAuthorizableByPrincipal(principal);
    }

    @CheckForNull
    private Principal createPrincipal(@CheckForNull Tree authorizableTree) {
        Object principal = null;
        if (authorizableTree != null) {
            AuthorizableType type = UserUtil.getType((Tree)authorizableTree);
            if (AuthorizableType.GROUP == type) {
                principal = this.createGroupPrincipal(authorizableTree);
            } else if (AuthorizableType.USER == type) {
                principal = this.createUserPrincipal(UserUtil.getAuthorizableId((Tree)authorizableTree, (AuthorizableType)type), authorizableTree);
            }
        }
        return principal;
    }

    @CheckForNull
    private Principal createUserPrincipal(@Nonnull String id, @Nonnull Tree userTree) {
        String principalName = UserPrincipalProvider.getPrincipalName(userTree);
        if (principalName == null) {
            return null;
        }
        if (UserUtil.isSystemUser((Tree)userTree)) {
            return new SystemUserPrincipalImpl(principalName, userTree, (PathMapper)this.namePathMapper);
        }
        if (UserUtil.isAdmin((ConfigurationParameters)this.config.getParameters(), (String)id)) {
            return new AdminPrincipalImpl(principalName, userTree, (PathMapper)this.namePathMapper);
        }
        return new TreeBasedPrincipal(principalName, userTree, (PathMapper)this.namePathMapper);
    }

    @CheckForNull
    private Group createGroupPrincipal(@Nonnull Tree groupTree) {
        String principalName = UserPrincipalProvider.getPrincipalName(groupTree);
        if (principalName == null) {
            return null;
        }
        return new GroupPrincipal(principalName, groupTree);
    }

    @CheckForNull
    private static String getPrincipalName(@Nonnull Tree tree) {
        PropertyState principalName = tree.getProperty("rep:principalName");
        if (principalName != null) {
            return (String)principalName.getValue(Type.STRING);
        }
        String msg = "Authorizable without principal name " + UserUtil.getAuthorizableId((Tree)tree);
        log.warn(msg);
        return null;
    }

    @Nonnull
    private Set<Group> getGroupMembership(@Nonnull Tree authorizableTree) {
        boolean doCache;
        Set<Group> groupPrincipals = null;
        boolean bl = doCache = this.cacheEnabled && UserUtil.isType((Tree)authorizableTree, (AuthorizableType)AuthorizableType.USER);
        if (doCache) {
            groupPrincipals = this.readGroupsFromCache(authorizableTree);
        }
        if (groupPrincipals == null) {
            groupPrincipals = new HashSet<Group>();
            Iterator<String> groupPaths = this.membershipProvider.getMembership(authorizableTree, true);
            while (groupPaths.hasNext()) {
                Group gr;
                Tree groupTree = this.userProvider.getAuthorizableByPath(groupPaths.next());
                if (groupTree == null || !UserUtil.isType((Tree)groupTree, (AuthorizableType)AuthorizableType.GROUP) || (gr = this.createGroupPrincipal(groupTree)) == null) continue;
                groupPrincipals.add(gr);
            }
            if (doCache) {
                this.cacheGroups(authorizableTree, groupPrincipals);
            }
        }
        groupPrincipals.add((Group)EveryonePrincipal.getInstance());
        return groupPrincipals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheGroups(@Nonnull Tree authorizableNode, @Nonnull Set<Group> groupPrincipals) {
        try {
            this.root.refresh();
            Tree cache = authorizableNode.getChild("rep:cache");
            if (!cache.exists()) {
                if ((long)groupPrincipals.size() <= 0L) {
                    log.debug("Omit cache creation for user without group membership at " + authorizableNode.getPath());
                    return;
                }
                log.debug("Create new group membership cache at " + authorizableNode.getPath());
                cache = TreeUtil.addChild((Tree)authorizableNode, (String)"rep:cache", (String)"rep:Cache");
            }
            cache.setProperty("rep:expiration", (Object)LongUtils.calculateExpirationTime((long)this.expiration));
            String value = groupPrincipals.isEmpty() ? "" : Joiner.on((String)",").join(Iterables.transform(groupPrincipals, (Function)new Function<Group, String>(){

                public String apply(Group input) {
                    return Text.escape((String)input.getName());
                }
            }));
            cache.setProperty("rep:groupPrincipalNames", (Object)value);
            this.root.commit(CacheValidatorProvider.asCommitAttributes());
            log.debug("Cached group membership at " + authorizableNode.getPath());
        }
        catch (AccessDeniedException e) {
            log.debug("Failed to cache group membership", (Object)e.getMessage());
        }
        catch (CommitFailedException e) {
            log.debug("Failed to cache group membership", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.root.refresh();
        }
    }

    @CheckForNull
    private Set<Group> readGroupsFromCache(@Nonnull Tree authorizableNode) {
        Tree principalCache = authorizableNode.getChild("rep:cache");
        if (!principalCache.exists()) {
            log.debug("No group cache at " + authorizableNode.getPath());
            return null;
        }
        if (UserPrincipalProvider.isValidCache(principalCache)) {
            log.debug("Reading group membership at " + authorizableNode.getPath());
            String str = TreeUtil.getString((Tree)principalCache, (String)"rep:groupPrincipalNames");
            if (str == null || str.isEmpty()) {
                return new HashSet<Group>(1);
            }
            HashSet<Group> groups = new HashSet<Group>();
            for (String s : Text.explode((String)str, (int)44)) {
                String name = Text.unescape((String)s);
                groups.add(new CachedGroupPrincipal(name));
            }
            return groups;
        }
        log.debug("Expired group cache for " + authorizableNode.getPath());
        return null;
    }

    private static boolean isValidCache(Tree principalCache) {
        long expirationTime = TreeUtil.getLong((Tree)principalCache, (String)"rep:expiration", (long)0L);
        long now = new Date().getTime();
        return expirationTime > 0L && now < expirationTime;
    }

    private static String buildSearchPattern(String nameHint) {
        if (nameHint == null) {
            return "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('%');
        sb.append(nameHint.replace("%", "\\%").replace("_", "\\_"));
        sb.append('%');
        return sb.toString();
    }

    private static boolean matchesEveryone(String nameHint, int searchType) {
        return searchType != 1 && (nameHint == null || "everyone".contains(nameHint));
    }

    private final class CachedGroupPrincipal
    extends BaseGroupPrincipal {
        private org.apache.jackrabbit.api.security.user.Group group;

        CachedGroupPrincipal(String principalName) {
            super(principalName, "");
        }

        @Override
        String getOakPath() {
            String groupPath = this.getPath();
            return groupPath == null ? null : UserPrincipalProvider.this.namePathMapper.getOakPath(this.getPath());
        }

        @Override
        public String getPath() {
            try {
                org.apache.jackrabbit.api.security.user.Group gr = this.getGroup();
                return gr == null ? null : gr.getPath();
            }
            catch (RepositoryException e) {
                log.error("Failed to retrieve path from group principal", (Object)e.getMessage());
                return null;
            }
        }

        @Override
        @CheckForNull
        org.apache.jackrabbit.api.security.user.Group getGroup() throws RepositoryException {
            Authorizable authorizable;
            if (this.group == null && (authorizable = this.getUserManager().getAuthorizable((Principal)new PrincipalImpl(this.getName()))) != null && authorizable.isGroup()) {
                this.group = (org.apache.jackrabbit.api.security.user.Group)authorizable;
            }
            return this.group;
        }
    }

    private final class GroupPrincipal
    extends BaseGroupPrincipal {
        private org.apache.jackrabbit.api.security.user.Group group;

        GroupPrincipal(@Nonnull String principalName, Tree groupTree) {
            super(principalName, groupTree);
        }

        @Override
        @CheckForNull
        org.apache.jackrabbit.api.security.user.Group getGroup() throws RepositoryException {
            Authorizable authorizable;
            if (this.group == null && (authorizable = this.getUserManager().getAuthorizable((Principal)((Object)this))) != null && authorizable.isGroup()) {
                this.group = (org.apache.jackrabbit.api.security.user.Group)authorizable;
            }
            return this.group;
        }
    }

    private abstract class BaseGroupPrincipal
    extends AbstractGroupPrincipal {
        private UserManager userManager;

        BaseGroupPrincipal(@Nonnull String principalName, Tree groupTree) {
            super(principalName, groupTree, UserPrincipalProvider.this.namePathMapper);
        }

        BaseGroupPrincipal(@Nonnull String principalName, String groupPath) {
            super(principalName, groupPath, UserPrincipalProvider.this.namePathMapper);
        }

        @Override
        UserManager getUserManager() {
            if (this.userManager == null) {
                this.userManager = UserPrincipalProvider.this.config.getUserManager(UserPrincipalProvider.this.root, UserPrincipalProvider.this.namePathMapper);
            }
            return this.userManager;
        }

        @Override
        boolean isEveryone() {
            return "everyone".equals(this.getName());
        }

        @Override
        boolean isMember(@Nonnull Authorizable authorizable) throws RepositoryException {
            org.apache.jackrabbit.api.security.user.Group g = this.getGroup();
            return g != null && g.isMember(authorizable);
        }

        @Override
        @Nonnull
        Iterator<Authorizable> getMembers() throws RepositoryException {
            org.apache.jackrabbit.api.security.user.Group g = this.getGroup();
            return g == null ? Iterators.emptyIterator() : g.getMembers();
        }

        @CheckForNull
        abstract org.apache.jackrabbit.api.security.user.Group getGroup() throws RepositoryException;
    }

    private static final class EveryonePredicate
    implements Predicate<Principal> {
        private boolean servedEveryone = false;

        private EveryonePredicate() {
        }

        public boolean apply(@Nullable Principal principal) {
            String pName;
            String string = pName = principal == null ? null : principal.getName();
            if ("everyone".equals(pName)) {
                if (this.servedEveryone) {
                    return false;
                }
                this.servedEveryone = true;
                return true;
            }
            return true;
        }
    }

    private final class ResultRowToPrincipal
    implements Function<ResultRow, Principal> {
        private ResultRowToPrincipal() {
        }

        public Principal apply(@Nullable ResultRow resultRow) {
            return resultRow != null ? UserPrincipalProvider.this.createPrincipal(resultRow.getTree(null)) : null;
        }
    }
}

