/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.UserValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;

class UserValidator
extends DefaultValidator
implements UserConstants {
    private final Tree parentBefore;
    private final Tree parentAfter;
    private final UserValidatorProvider provider;
    private final AuthorizableType authorizableType;

    UserValidator(Tree parentBefore, Tree parentAfter, UserValidatorProvider provider) {
        this.parentBefore = parentBefore;
        this.parentAfter = parentAfter;
        this.provider = provider;
        this.authorizableType = parentAfter == null ? null : UserUtil.getType((Tree)parentAfter);
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (this.authorizableType == null) {
            return;
        }
        String name = after.getName();
        if ("rep:disabled".equals(name) && this.isAdminUser(this.parentAfter)) {
            String msg = "Admin user cannot be disabled.";
            throw UserValidator.constraintViolation(20, msg);
        }
        if ("jcr:uuid".equals(name) && !this.isValidUUID(this.parentAfter, (String)after.getValue(Type.STRING))) {
            String msg = "Invalid jcr:uuid for authorizable " + this.parentAfter.getName();
            throw UserValidator.constraintViolation(21, msg);
        }
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (this.authorizableType == null) {
            return;
        }
        String name = before.getName();
        if ("rep:principalName".equals(name) || "rep:authorizableId".equals(name)) {
            String msg = "Authorizable property " + name + " may not be altered after user/group creation.";
            throw UserValidator.constraintViolation(22, msg);
        }
        if ("jcr:uuid".equals(name)) {
            Preconditions.checkNotNull((Object)this.parentAfter);
            if (!this.isValidUUID(this.parentAfter, (String)after.getValue(Type.STRING))) {
                String msg = "Invalid jcr:uuid for authorizable " + this.parentAfter.getName();
                throw UserValidator.constraintViolation(23, msg);
            }
        } else if ("jcr:primaryType".equals(name)) {
            this.validateAuthorizable(this.parentAfter, UserUtil.getType((String)((String)after.getValue(Type.STRING))));
        }
        if (UserValidator.isUser(this.parentBefore) && "rep:password".equals(name) && PasswordUtil.isPlainTextPassword((String)((String)after.getValue(Type.STRING)))) {
            String msg = "Password may not be plain text.";
            throw UserValidator.constraintViolation(24, msg);
        }
    }

    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (this.authorizableType == null) {
            return;
        }
        String name = before.getName();
        if ("rep:password".equals(name) || "rep:principalName".equals(name) || "rep:authorizableId".equals(name)) {
            String msg = "Authorizable property " + name + " may not be removed.";
            throw UserValidator.constraintViolation(25, msg);
        }
    }

    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        Tree tree = (Tree)Preconditions.checkNotNull((Object)this.parentAfter.getChild(name));
        this.validateAuthorizable(tree, UserUtil.getType((Tree)tree));
        return UserValidator.newValidator(null, tree, this.provider);
    }

    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return UserValidator.newValidator(this.parentBefore.getChild(name), this.parentAfter.getChild(name), this.provider);
    }

    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        Tree tree = this.parentBefore.getChild(name);
        AuthorizableType type = UserUtil.getType((Tree)tree);
        if (type == AuthorizableType.USER || type == AuthorizableType.GROUP) {
            if (this.isAdminUser(tree)) {
                String msg = "The admin user cannot be removed.";
                throw UserValidator.constraintViolation(27, msg);
            }
            return null;
        }
        return UserValidator.newValidator(tree, null, this.provider);
    }

    private static Validator newValidator(Tree parentBefore, Tree parentAfter, UserValidatorProvider provider) {
        return new VisibleValidator((Validator)new UserValidator(parentBefore, parentAfter, provider), true, true);
    }

    private boolean isAdminUser(@Nonnull Tree userTree) {
        if (userTree.exists() && UserValidator.isUser(userTree)) {
            String id = UserUtil.getAuthorizableId((Tree)userTree);
            return UserUtil.getAdminId((ConfigurationParameters)this.provider.getConfig()).equals(id);
        }
        return false;
    }

    private void validateAuthorizable(@Nonnull Tree tree, @Nullable AuthorizableType type) throws CommitFailedException {
        boolean isSystemUser = type == AuthorizableType.USER && UserUtil.isSystemUser((Tree)tree);
        String authRoot = UserUtil.getAuthorizableRootPath((ConfigurationParameters)this.provider.getConfig(), (AuthorizableType)type);
        if (isSystemUser) {
            String sysRelPath = (String)this.provider.getConfig().getConfigValue("systemRelativePath", (Object)"system");
            authRoot = authRoot + '/' + sysRelPath;
        }
        if (authRoot != null) {
            UserValidator.assertHierarchy(tree, authRoot);
            if (TreeUtil.getString((Tree)tree, (String)"rep:principalName") == null) {
                throw UserValidator.constraintViolation(26, "Mandatory property rep:principalName missing.");
            }
            if (isSystemUser) {
                if (TreeUtil.getString((Tree)tree, (String)"rep:password") != null) {
                    throw UserValidator.constraintViolation(32, "Attempt to set password with system user.");
                }
                if (tree.hasChild("rep:pwd")) {
                    throw UserValidator.constraintViolation(33, "Attempt to add rep:pwd node to a system user.");
                }
            }
        }
    }

    private boolean isValidUUID(@Nonnull Tree parent, @Nonnull String uuid) {
        String id = UserUtil.getAuthorizableId((Tree)parent);
        return id != null && uuid.equals(this.provider.getMembershipProvider().getContentID(id));
    }

    private static boolean isUser(@Nullable Tree tree) {
        return tree != null && "rep:User".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    private static void assertHierarchy(@Nonnull Tree tree, @Nonnull String pathConstraint) throws CommitFailedException {
        if (!Text.isDescendant((String)pathConstraint, (String)tree.getPath())) {
            String msg = "Attempt to create user/group outside of configured scope " + pathConstraint;
            throw UserValidator.constraintViolation(28, msg);
        }
        if (!tree.isRoot()) {
            Tree parent = tree.getParent();
            while (parent.exists() && !parent.isRoot()) {
                if (!"rep:AuthorizableFolder".equals(TreeUtil.getPrimaryTypeName((Tree)parent))) {
                    String msg = "Cannot create user/group: Intermediate folders must be of type rep:AuthorizableFolder.";
                    throw UserValidator.constraintViolation(29, msg);
                }
                parent = parent.getParent();
            }
        }
    }

    private static CommitFailedException constraintViolation(int code, @Nonnull String message) {
        return new CommitFailedException("Constraint", code, message);
    }
}

