/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableWrapper;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;

class GroupImpl
extends AuthorizableImpl
implements Group {
    GroupImpl(Group dlg, AutoSaveEnabledManager mgr) {
        super((Authorizable)dlg, mgr);
    }

    Group getDelegate() {
        return (Group)this.getDlg();
    }

    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.getDelegate().getDeclaredMembers(), this.getMgr());
    }

    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.getDelegate().getMembers(), this.getMgr());
    }

    public boolean isDeclaredMember(Authorizable authorizable) throws RepositoryException {
        if (this.isValid(authorizable)) {
            return this.getDelegate().isDeclaredMember(((AuthorizableImpl)authorizable).getDlg());
        }
        return false;
    }

    public boolean isMember(Authorizable authorizable) throws RepositoryException {
        if (this.isValid(authorizable)) {
            return this.getDelegate().isMember(((AuthorizableImpl)authorizable).getDlg());
        }
        return false;
    }

    public boolean addMember(Authorizable authorizable) throws RepositoryException {
        try {
            if (this.isValid(authorizable)) {
                boolean bl = this.getDelegate().addMember(((AuthorizableImpl)authorizable).getDlg());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    public Set<String> addMembers(String ... memberIds) throws RepositoryException {
        try {
            Set set = this.getDelegate().addMembers(memberIds);
            return set;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    public boolean removeMember(Authorizable authorizable) throws RepositoryException {
        try {
            if (this.isValid(authorizable)) {
                boolean bl = this.getDelegate().removeMember(((AuthorizableImpl)authorizable).getDlg());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    public Set<String> removeMembers(String ... memberIds) throws RepositoryException {
        try {
            Set set = this.getDelegate().removeMembers(memberIds);
            return set;
        }
        finally {
            this.getMgr().autosave();
        }
    }

    private boolean isValid(Authorizable a) {
        return a instanceof AuthorizableImpl;
    }
}

