/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import com.google.common.base.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResultRowToAuthorizable
implements Function<ResultRow, Authorizable> {
    private static final Logger log = LoggerFactory.getLogger(ResultRowToAuthorizable.class);
    private final UserManagerImpl userManager;
    private final Root root;
    private final AuthorizableType targetType;

    ResultRowToAuthorizable(@Nonnull UserManagerImpl userManager, @Nonnull Root root, @Nullable AuthorizableType targetType) {
        this.userManager = userManager;
        this.root = root;
        this.targetType = targetType == null || AuthorizableType.AUTHORIZABLE == targetType ? null : targetType;
    }

    @Nullable
    public Authorizable apply(@Nullable ResultRow row) {
        return this.getAuthorizable(row);
    }

    @CheckForNull
    private Authorizable getAuthorizable(@CheckForNull ResultRow row) {
        Authorizable authorizable = null;
        if (row != null) {
            String resultPath = (String)row.getValue("jcr:path").getValue(Type.STRING);
            try {
                Tree tree = this.root.getTree(resultPath);
                AuthorizableType type = UserUtil.getType((Tree)tree);
                while (tree.exists() && !tree.isRoot() && type == null) {
                    tree = tree.getParent();
                    type = UserUtil.getType((Tree)tree);
                }
                if (tree.exists() && (this.targetType == null || this.targetType == type)) {
                    authorizable = this.userManager.getAuthorizable(tree);
                }
            }
            catch (RepositoryException e) {
                log.debug("Failed to access authorizable " + resultPath);
            }
        }
        return authorizable;
    }
}

