/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.AbstractArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.CNDImporter;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.util.PathUtil;

public class NodeTypeArtifactHandler
extends AbstractArtifactHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact primary = artifacts.getPrimaryData();
        if (primary == null) {
            return null;
        }
        if (artifacts.size() != 1) {
            return null;
        }
        if (primary.getSerializationType() != SerializationType.CND) {
            return null;
        }
        String path = PathUtil.getPath(parent, primary.getRelativePath());
        if (wspFilter.getImportMode(path) == ImportMode.MERGE) {
            ImportInfoImpl info = new ImportInfoImpl();
            info.onNop(path);
            return info;
        }
        CNDImporter importer = new CNDImporter();
        try (InputStream in = primary.getInputStream();){
            InputStreamReader r = new InputStreamReader(in, "utf-8");
            ImportInfoImpl importInfoImpl = importer.doImport(parent, primary.getRelativePath(), r, primary.getRelativePath());
            return importInfoImpl;
        }
    }
}

