/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(JcrArchive.class);
    private Node archiveRoot;
    private final String rootPath;
    private DefaultMetaInf inf;
    private Archive.Entry jcrRoot;
    private String chRoot;

    public JcrArchive(@Nonnull Node archiveRoot, @Nonnull String rootPath) {
        this.archiveRoot = archiveRoot;
        this.rootPath = rootPath;
    }

    @Override
    public void open(boolean strict) throws IOException {
        if (this.jcrRoot != null) {
            return;
        }
        try {
            this.jcrRoot = this.archiveRoot.hasNode("jcr_root") ? new JcrEntry(this.archiveRoot.getNode("jcr_root"), "jcr_root", true) : new JcrEntry(this.archiveRoot, this.archiveRoot.getName(), true);
            if (this.archiveRoot.hasNode("META-INF/vault")) {
                this.inf = this.loadMetaInf(new JcrEntry(this.archiveRoot.getNode("META-INF/vault"), "META-INF/vault", true));
            } else {
                String[] roots;
                this.inf = new DefaultMetaInf();
                this.inf.setSettings(VaultSettings.createDefault());
                DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
                PathFilterSet filterSet = new PathFilterSet(this.rootPath);
                filter.add(filterSet);
                this.inf.setFilter(filter);
                if (this.chRoot != null && this.chRoot.length() > 0 && (roots = Text.explode(this.rootPath, 47)).length > 0) {
                    VirtualEntry newRoot;
                    VirtualEntry entry = newRoot = new VirtualEntry(this.jcrRoot.getName());
                    for (String name : roots) {
                        VirtualEntry newEntry = new VirtualEntry(name);
                        entry.children.put(name, newEntry);
                        entry = newEntry;
                    }
                    for (Archive.Entry entry2 : this.jcrRoot.getChildren()) {
                        entry.children.put(entry2.getName(), entry2);
                    }
                    this.jcrRoot = newRoot;
                }
            }
        }
        catch (RepositoryException | ConfigurationException e) {
            throw new IOException("Error while opening JCR archive.", e);
        }
    }

    private DefaultMetaInf loadMetaInf(Archive.Entry dir) throws IOException, ConfigurationException {
        DefaultMetaInf inf = new DefaultMetaInf();
        for (Archive.Entry entry : dir.getChildren()) {
            VaultInputSource src = this.getInputSource(entry);
            inf.load(src.getByteStream(), src.getSystemId());
        }
        if (inf.getFilter() == null) {
            log.debug("Archive {} does not contain filter definition.", (Object)this);
        }
        if (inf.getConfig() == null) {
            log.debug("Archive {} does not contain vault config.", (Object)this);
        }
        if (inf.getSettings() == null) {
            log.debug("Archive {} does not contain vault settings. using default.", (Object)this);
            VaultSettings settings = new VaultSettings();
            settings.getIgnoredNames().add(".svn");
            inf.setSettings(settings);
        }
        if (inf.getProperties() == null) {
            log.debug("Archive {} does not contain properties.", (Object)this);
        }
        if (inf.getNodeTypes().isEmpty()) {
            log.debug("Archive {} does not contain nodetypes.", (Object)this);
        }
        return inf;
    }

    @Override
    public void close() {
        this.archiveRoot = null;
        this.jcrRoot = null;
    }

    @Override
    public Archive.Entry getJcrRoot() {
        return this.jcrRoot;
    }

    @Override
    public Archive.Entry getRoot() throws IOException {
        return new JcrEntry(this.archiveRoot, "", true);
    }

    @Override
    public MetaInf getMetaInf() {
        return this.inf;
    }

    @Override
    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        if (entry == null || entry.isDirectory()) {
            return null;
        }
        try {
            Node content = ((JcrEntry)entry).node.getNode("jcr:content");
            return content.getProperty("jcr:data").getBinary().getStream();
        }
        catch (RepositoryException e) {
            throw new IOException("Unable to open input source.", e);
        }
    }

    @Override
    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        if (entry == null || entry.isDirectory()) {
            return null;
        }
        try {
            final Node content = ((JcrEntry)entry).node.getNode("jcr:content");
            final String systemId = ((JcrEntry)entry).node.getPath();
            return new VaultInputSource(){
                {
                    this.setSystemId(systemId);
                }

                @Override
                public InputStream getByteStream() {
                    try {
                        return content.getProperty("jcr:data").getBinary().getStream();
                    }
                    catch (RepositoryException e) {
                        log.error("Error while opening input stream of " + content, (Throwable)e);
                        return null;
                    }
                }

                @Override
                public long getContentLength() {
                    try {
                        return content.getProperty("jcr:data").getLength();
                    }
                    catch (RepositoryException e) {
                        log.error("Error while retrieving length of " + content, (Throwable)e);
                        return -1L;
                    }
                }

                @Override
                public long getLastModified() {
                    try {
                        return content.getProperty("jcr:lastModified").getDate().getTimeInMillis();
                    }
                    catch (RepositoryException e) {
                        log.error("Error while retrieving last modified of " + content, (Throwable)e);
                        return 0L;
                    }
                }
            };
        }
        catch (RepositoryException e) {
            throw new IOException("Unable to open input source.", e);
        }
    }

    public String toString() {
        try {
            return this.archiveRoot.getPath();
        }
        catch (RepositoryException e) {
            return this.archiveRoot.toString();
        }
    }

    private static class JcrEntry
    implements Archive.Entry {
        private final Node node;
        private final boolean isDir;
        private final String name;

        private JcrEntry(Node node, String name, boolean isDir) {
            this.node = node;
            this.isDir = isDir;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDirectory() {
            return this.isDir;
        }

        public Collection<Archive.Entry> getChildren() {
            if (this.isDir) {
                try {
                    NodeIterator iter = this.node.getNodes();
                    long size = iter.getSize();
                    if (size < 0L) {
                        size = 0L;
                    }
                    ArrayList<Archive.Entry> ret = new ArrayList<Archive.Entry>((int)size);
                    while (iter.hasNext()) {
                        boolean isDir;
                        Node child = iter.nextNode();
                        String name = child.getName();
                        if (".svn".equals(name)) continue;
                        if (child.isNodeType("nt:folder")) {
                            isDir = true;
                        } else if (child.isNodeType("nt:file")) {
                            isDir = false;
                        } else {
                            log.debug("Skipping node {} with unknown type {}.", (Object)child.getPath(), (Object)child.getPrimaryNodeType().getName());
                            continue;
                        }
                        ret.add(new JcrEntry(child, name, isDir));
                    }
                    return ret;
                }
                catch (RepositoryException e) {
                    log.error("Error while listing child nodes of {}", (Object)this.node, (Object)e);
                    throw new IllegalStateException("Error while listing child nodes of " + this.node, e);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Archive.Entry getChild(String name) {
            try {
                if (this.isDir && this.node.hasNode(name) && !".svn".equals(name)) {
                    boolean isDir;
                    Node child = this.node.getNode(name);
                    if (child.isNodeType("nt:folder")) {
                        isDir = true;
                    } else if (child.isNodeType("nt:file")) {
                        isDir = false;
                    } else {
                        log.debug("Skipping node {} with unknown type {}.", (Object)child.getPath(), (Object)child.getPrimaryNodeType().getName());
                        return null;
                    }
                    return new JcrEntry(child, name, isDir);
                }
                return null;
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving child node of {}", (Object)this.node, (Object)e);
                throw new IllegalStateException("Error while retrieving child node of " + this.node, e);
            }
        }
    }

    private static class VirtualEntry
    implements Archive.Entry {
        private final String name;
        private Map<String, Archive.Entry> children = new LinkedHashMap<String, Archive.Entry>();

        private VirtualEntry(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public Collection<? extends Archive.Entry> getChildren() {
            return this.children.values();
        }

        @Override
        public Archive.Entry getChild(String name) {
            return this.children.get(name);
        }
    }
}

