/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(MappedArchive.class);
    private final Archive base;
    private final PathMapping mapping;
    private final VirtualEntry root = new VirtualEntry();
    private VirtualEntry jcrRoot;

    public MappedArchive(Archive base, PathMapping mapping) {
        this.base = base;
        this.mapping = mapping;
    }

    @Override
    public void open(boolean strict) throws IOException {
        this.base.open(strict);
        this.applyMapping(this.base.getRoot(), this.root);
    }

    private void applyMapping(@Nonnull Archive.Entry src, @Nonnull VirtualEntry dst) {
        for (Archive.Entry entry : src.getChildren()) {
            VirtualEntry dstChild = dst.add(entry.getName(), entry);
            if ("/jcr_root".equals(dstChild.getPath())) {
                this.jcrRoot = dstChild;
                this.applyMapping(entry, "");
                continue;
            }
            this.applyMapping(entry, dstChild);
        }
    }

    private void applyMapping(@Nonnull Archive.Entry src, @Nonnull String jcrPath) {
        for (Archive.Entry entry : src.getChildren()) {
            String path = jcrPath + "/" + entry.getName();
            String mappedPath = this.mapping.map(path);
            String[] segments = Text.explode(mappedPath, 47);
            VirtualEntry entry2 = this.jcrRoot;
            for (String seg : segments) {
                entry2 = entry2.add(seg, null);
            }
            if (entry2.baseEntry != null) {
                log.warn("Path mapping maps multiple paths to the same destination: {} -> {}. ignoring this source.", (Object)path, (Object)mappedPath);
            } else {
                entry2.baseEntry = entry;
            }
            this.applyMapping(entry, path);
        }
    }

    @Override
    @CheckForNull
    public InputStream openInputStream(@Nullable Archive.Entry entry) throws IOException {
        if (entry == null) {
            return null;
        }
        return this.base.openInputStream(((VirtualEntry)entry).baseEntry);
    }

    @Override
    @CheckForNull
    public VaultInputSource getInputSource(@Nullable Archive.Entry entry) throws IOException {
        if (entry == null) {
            return null;
        }
        return this.base.getInputSource(((VirtualEntry)entry).baseEntry);
    }

    @Override
    @Nonnull
    public Archive.Entry getRoot() throws IOException {
        return this.root;
    }

    @Override
    public Archive.Entry getJcrRoot() throws IOException {
        return this.jcrRoot;
    }

    @Override
    @Nonnull
    public MetaInf getMetaInf() {
        return this.base.getMetaInf();
    }

    @Override
    public void close() {
        this.base.close();
    }

    private static class VirtualEntry
    implements Archive.Entry {
        @Nullable
        private final VirtualEntry parent;
        @Nonnull
        private final String name;
        @Nullable
        private Archive.Entry baseEntry;
        @Nullable
        private Map<String, VirtualEntry> children;

        private VirtualEntry() {
            this.parent = null;
            this.name = "";
            this.baseEntry = null;
        }

        private VirtualEntry(@Nonnull VirtualEntry parent, @Nonnull String name, @Nullable Archive.Entry baseEntry) {
            this.parent = parent;
            this.name = name;
            this.baseEntry = baseEntry;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public String getPath() {
            return this.getPath(new StringBuilder()).toString();
        }

        @Nonnull
        private StringBuilder getPath(@Nonnull StringBuilder sb) {
            return this.parent == null ? sb : this.parent.getPath(sb).append('/').append(this.name);
        }

        @Override
        public boolean isDirectory() {
            return this.baseEntry == null || this.baseEntry.isDirectory();
        }

        @Override
        @Nonnull
        public Collection<? extends Archive.Entry> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children.values();
        }

        @Override
        @Nullable
        public Archive.Entry getChild(String name) {
            return this.children == null ? null : this.children.get(name);
        }

        @Nonnull
        public VirtualEntry add(@Nonnull String name, @Nullable Archive.Entry baseEntry) {
            VirtualEntry ret;
            if (this.children != null && (ret = this.children.get(name)) != null) {
                return ret;
            }
            VirtualEntry ve = new VirtualEntry(this, name, baseEntry);
            if (this.children == null) {
                this.children = new LinkedHashMap<String, VirtualEntry>();
            }
            this.children.put(name, ve);
            return ve;
        }
    }
}

