/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.MemoryArchive;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeInstaller;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageExistsException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.Version;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackagePropertiesImpl;
import org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.JcrRegisteredPackage;
import org.apache.jackrabbit.vault.util.InputStreamPump;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageRegistry
extends AbstractPackageRegistry {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageRegistry.class);
    private static final String DEFAULT_NODETYPES = "nodetypes.cnd";
    private static final String[] FOLDER_TYPES = new String[]{"sling:Folder", "nt:folder", "nt:unstructured", null};
    private final Session session;
    @Nullable
    private PackageEventDispatcher dispatcher;
    private final Node[] packRoots;
    private final String[] packRootPaths;
    private final String primaryPackRootPathPrefix;

    public JcrPackageRegistry(@Nonnull Session session, String ... roots) {
        this.session = session;
        this.packRootPaths = roots == null || roots.length == 0 ? new String[]{"/etc/packages"} : roots;
        this.packRoots = new Node[this.packRootPaths.length];
        this.primaryPackRootPathPrefix = this.packRootPaths[0] + "/";
        this.initNodeTypes();
    }

    public void setDispatcher(@Nullable PackageEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void dispatch(@Nonnull PackageEvent.Type type, @Nonnull PackageId id, @Nullable PackageId[] related) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.dispatch(type, id, related);
    }

    private void initNodeTypes() {
        try {
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:Package");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:HierarchyNode");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:FullCoverage");
            return;
        }
        catch (RepositoryException repositoryException) {
            try (InputStream in = JcrPackageManagerImpl.class.getResourceAsStream(DEFAULT_NODETYPES);){
                if (in == null) {
                    throw new InternalError("Could not load nodetypes.cnd resource.");
                }
                NodeTypeInstaller installer = ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(this.session);
                CNDReader types = ServiceProviderFactory.getProvider().getCNDReader();
                types.read(new InputStreamReader(in, "utf8"), DEFAULT_NODETYPES, null);
                installer.install(null, types);
            }
            catch (Throwable e) {
                log.warn("Error while registering nodetypes. Package installation might not work correctly.", e);
            }
            return;
        }
    }

    @Nonnull
    public String[] getPackRootPaths() {
        return this.packRootPaths;
    }

    @Nullable
    public Node getPrimaryPackageRoot(boolean autoCreate) throws RepositoryException {
        if (this.packRoots[0] == null) {
            if (this.session.nodeExists(this.packRootPaths[0])) {
                this.packRoots[0] = this.session.getNode(this.packRootPaths[0]);
            } else if (autoCreate) {
                if (this.session.hasPendingChanges()) {
                    throw new RepositoryException("Unwilling to create package root folder while session has transient changes.");
                }
                this.packRoots[0] = JcrUtils.getOrCreateByPath((String)this.packRootPaths[0], (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (Session)this.session, (boolean)true);
            }
        }
        return this.packRoots[0];
    }

    @Nonnull
    public List<Node> getPackageRoots() throws RepositoryException {
        ArrayList<Node> roots = new ArrayList<Node>(this.packRootPaths.length);
        for (int i = 0; i < this.packRootPaths.length; ++i) {
            if (this.packRoots[i] == null && this.session.nodeExists(this.packRootPaths[i])) {
                this.packRoots[i] = this.session.getNode(this.packRootPaths[i]);
            }
            if (this.packRoots[i] == null) continue;
            roots.add(this.packRoots[i]);
        }
        return roots;
    }

    @Override
    @Nullable
    public RegisteredPackage open(@Nonnull PackageId id) throws IOException {
        try {
            Node node = this.getPackageNode(id);
            return node == null ? null : new JcrRegisteredPackage(this.open(node, false));
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean contains(@Nonnull PackageId id) throws IOException {
        try {
            return this.getPackageNode(id) != null;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    private Node getPackageNode(@Nonnull PackageId id) throws RepositoryException {
        String relPath = this.getRelativeInstallationPath(id);
        for (String pfx : this.packRootPaths) {
            String[] exts;
            String path = pfx + relPath;
            for (String ext : exts = new String[]{"", ".zip", ".jar"}) {
                if (!this.session.nodeExists(path + ext)) continue;
                return this.session.getNode(path + ext);
            }
        }
        return null;
    }

    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageImpl pack = new JcrPackageImpl(this, node);
        if (pack.isValid()) {
            return pack;
        }
        if (allowInvalid && node.isNodeType("nt:hierarchyNode") && node.hasProperty("jcr:content/jcr:data")) {
            return pack;
        }
        return null;
    }

    @Override
    public PackageId resolve(Dependency dependency, boolean onlyInstalled) throws IOException {
        try {
            PackageId bestId = null;
            for (Node root : this.getPackageRoots()) {
                if (!root.hasNode(dependency.getGroup())) continue;
                Node groupNode = root.getNode(dependency.getGroup());
                NodeIterator iter = groupNode.getNodes();
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    if (".snapshot".equals(child.getName())) continue;
                    JcrPackageImpl pack = new JcrPackageImpl(this, child);
                    Throwable throwable = null;
                    try {
                        PackageId id;
                        if (!pack.isValid() || onlyInstalled && !pack.isInstalled() || !dependency.matches(id = pack.getDefinition().getId()) || bestId != null && id.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                        bestId = id;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pack == null) continue;
                        if (throwable != null) {
                            try {
                                pack.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pack.close();
                    }
                }
            }
            return bestId;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public PackageId register(@Nonnull InputStream in, boolean replace) throws IOException, PackageExistsException {
        try (JcrPackage pkg = this.upload(in, replace);){
            PackageId packageId = pkg.getPackage().getId();
            return packageId;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrPackage upload(InputStream in, boolean replace) throws RepositoryException, IOException, PackageExistsException {
        MemoryArchive archive = new MemoryArchive(true);
        InputStreamPump pump = new InputStreamPump(in, archive);
        Binary bin = this.session.getValueFactory().createBinary((InputStream)pump);
        if (pump.getError() != null) {
            Exception error = pump.getError();
            log.error("Error while reading from input stream.", (Throwable)error);
            bin.dispose();
            throw new IOException("Error while reading from input stream", error);
        }
        if (archive.getJcrRoot() == null) {
            String msg = "Stream is not a content package. Missing 'jcr_root'.";
            log.error(msg);
            bin.dispose();
            throw new IOException(msg);
        }
        final MetaInf inf = archive.getMetaInf();
        PackagePropertiesImpl props = new PackagePropertiesImpl(){

            @Override
            protected Properties getPropertiesMap() {
                return inf.getProperties();
            }
        };
        PackageId pid = props.getId();
        if (pid == null) {
            pid = JcrPackageRegistry.createRandomPid();
        }
        if (!pid.isValid()) {
            bin.dispose();
            throw new RepositoryException("Unable to create package. Illegal package name.");
        }
        String path = this.getInstallationPath(pid) + ".zip";
        String parentPath = Text.getRelativeParent(path, 1);
        String name = Text.getName(path);
        Node parent = this.mkdir(parentPath, false);
        JcrPackageDefinitionImpl.State state = null;
        Calendar oldCreatedDate = null;
        if (parent.hasNode(name)) {
            try (JcrPackageImpl oldPackage = new JcrPackageImpl(this, parent.getNode(name));){
                JcrPackageDefinitionImpl oldDef = (JcrPackageDefinitionImpl)oldPackage.getDefinition();
                if (oldDef != null) {
                    state = oldDef.getState();
                    oldCreatedDate = oldDef.getCreated();
                }
            }
            if (replace) {
                parent.getNode(name).remove();
            } else {
                throw new PackageExistsException("Package already exists: " + pid).setId(pid);
            }
        }
        JcrPackage jcrPack = null;
        try {
            Calendar newCreateDate;
            jcrPack = this.createNew(parent, pid, bin, archive);
            JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)jcrPack.getDefinition();
            Calendar calendar = newCreateDate = def == null ? null : def.getCreated();
            if (state != null && newCreateDate != null && oldCreatedDate != null && oldCreatedDate.compareTo(newCreateDate) == 0) {
                def.setState(state);
            }
            this.dispatch(PackageEvent.Type.UPLOAD, pid, null);
            JcrPackage jcrPackage = jcrPack;
            return jcrPackage;
        }
        finally {
            bin.dispose();
            if (jcrPack == null) {
                this.session.refresh(false);
            } else {
                this.session.save();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public PackageId register(@Nonnull File file, boolean replace) throws IOException, PackageExistsException {
        ZipVaultPackage pack = new ZipVaultPackage(file, false, true);
        try (JcrPackage pkg = this.upload(pack, replace);){
            PackageId packageId = pkg.getPackage().getId();
            return packageId;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    @Nonnull
    public PackageId registerExternal(@Nonnull File file, boolean replace) throws IOException, PackageExistsException {
        throw new UnsupportedOperationException("linking files to repository persistence is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrPackage upload(ZipVaultPackage pkg, boolean replace) throws RepositoryException, IOException, PackageExistsException {
        if (pkg.getArchive().getJcrRoot() == null) {
            String msg = "Zip File is not a content package. Missing 'jcr_root'.";
            log.error(msg);
            pkg.close();
            throw new IOException(msg);
        }
        PackageId pid = pkg.getId();
        if (pid == null) {
            pid = JcrPackageRegistry.createRandomPid();
        }
        if (!pid.isValid()) {
            throw new RepositoryException("Unable to create package. Illegal package name.");
        }
        String path = this.getInstallationPath(pid) + ".zip";
        String parentPath = Text.getRelativeParent(path, 1);
        String name = Text.getName(path);
        Node parent = this.mkdir(parentPath, false);
        JcrPackageDefinitionImpl.State state = null;
        if (parent.hasNode(name)) {
            try (JcrPackageImpl oldPackage = new JcrPackageImpl(this, parent.getNode(name));){
                JcrPackageDefinitionImpl oldDef = (JcrPackageDefinitionImpl)oldPackage.getDefinition();
                if (oldDef != null) {
                    state = oldDef.getState();
                }
            }
            if (replace) {
                parent.getNode(name).remove();
            } else {
                throw new PackageExistsException("Package already exists: " + pid).setId(pid);
            }
        }
        JcrPackage jcrPack = null;
        try {
            jcrPack = this.createNew(parent, pid, pkg, false);
            JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)jcrPack.getDefinition();
            if (state != null && def != null) {
                def.setState(state);
            }
            this.dispatch(PackageEvent.Type.UPLOAD, pid, null);
            JcrPackage jcrPackage = jcrPack;
            return jcrPackage;
        }
        finally {
            if (jcrPack == null) {
                this.session.refresh(false);
            } else {
                this.session.save();
            }
        }
    }

    public Node mkdir(String path, boolean autoSave) throws RepositoryException {
        if (this.session.nodeExists(path)) {
            return this.session.getNode(path);
        }
        String parentPath = Text.getRelativeParent(path, 1);
        if (path == null || "/".equals(path) && parentPath.equals(path)) {
            throw new RepositoryException("could not crete intermediate nodes");
        }
        Node parent = this.mkdir(parentPath, autoSave);
        Node node = null;
        RepositoryException lastError = null;
        for (int i = 0; node == null && i < FOLDER_TYPES.length; ++i) {
            try {
                node = parent.addNode(Text.getName(path), FOLDER_TYPES[i]);
                continue;
            }
            catch (RepositoryException e) {
                lastError = e;
            }
        }
        if (node == null) {
            if (lastError != null) {
                throw lastError;
            }
            throw new RepositoryException("Unable to create path: " + path);
        }
        if (autoSave) {
            parent.getSession().save();
        }
        return node;
    }

    public JcrPackage create(String group, String name, String version) throws RepositoryException, IOException {
        String ext = Text.getName(name, '.');
        if ("zip".equals(ext) || "jar".equals(ext)) {
            name = name.substring(0, name.length() - 4);
        }
        if (!PackageId.isValid(group, name, version)) {
            throw new RepositoryException("Unable to create package. Illegal package name.");
        }
        PackageId pid = new PackageId(group, name, version);
        Node folder = this.mkdir(Text.getRelativeParent(this.getInstallationPath(pid), 1), false);
        return this.createNew(folder, pid, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public JcrPackage createNew(@Nonnull Node parent, @Nonnull PackageId pid, @Nullable VaultPackage pack, boolean autoSave) throws RepositoryException, IOException {
        Node node = parent.addNode(Text.getName(this.getInstallationPath(pid) + ".zip"), "nt:file");
        Node content = node.addNode("jcr:content", "nt:resource");
        content.addMixin("vlt:Package");
        Node defNode = content.addNode("vlt:definition");
        JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
        def.set("name", pid.getName(), false);
        def.set("group", pid.getGroup(), false);
        def.set("version", pid.getVersionString(), false);
        def.touch(null, false);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:mimeType", "application/zip");
        InputStream in = new ByteArrayInputStream(new byte[0]);
        try {
            if (pack != null && pack.getFile() != null) {
                in = FileUtils.openInputStream((File)pack.getFile());
            }
            content.setProperty("jcr:data", in);
            if (pack != null) {
                def.unwrap(pack, true, false);
            }
            if (autoSave) {
                parent.getSession().save();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        this.dispatch(PackageEvent.Type.CREATE, pid, null);
        return new JcrPackageImpl(this, node, (ZipVaultPackage)pack);
    }

    @Nonnull
    private JcrPackage createNew(@Nonnull Node parent, @Nonnull PackageId pid, @Nonnull Binary bin, @Nonnull MemoryArchive archive) throws RepositoryException, IOException {
        Node node = parent.addNode(Text.getName(this.getInstallationPath(pid) + ".zip"), "nt:file");
        Node content = node.addNode("jcr:content", "nt:resource");
        content.addMixin("vlt:Package");
        Node defNode = content.addNode("vlt:definition");
        JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
        def.set("name", pid.getName(), false);
        def.set("group", pid.getGroup(), false);
        def.set("version", pid.getVersionString(), false);
        def.touch(null, false);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:mimeType", "application/zip");
        content.setProperty("jcr:data", bin);
        def.unwrap(archive, false);
        this.dispatch(PackageEvent.Type.CREATE, pid, null);
        return new JcrPackageImpl(this, node);
    }

    @Override
    public void remove(@Nonnull PackageId id) throws IOException, NoSuchPackageException {
        JcrRegisteredPackage pkg = (JcrRegisteredPackage)this.open(id);
        if (pkg == null) {
            throw new NoSuchPackageException().setId(id);
        }
        JcrPackage pack = pkg.getJcrPackage();
        try {
            JcrPackage snap = pack.getSnapshot();
            if (snap != null) {
                snap.getNode().remove();
            }
            pack.getNode().remove();
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
        this.dispatch(PackageEvent.Type.REMOVE, id, null);
    }

    public JcrPackage rename(JcrPackage pack, String group, String name, String version) throws PackageException, RepositoryException {
        if (!pack.isValid()) {
            throw new PackageException("Package is not valid.");
        }
        if (pack.getSize() > 0L && !pack.getDefinition().isUnwrapped()) {
            throw new PackageException("Package definition not unwrapped.");
        }
        if (!PackageId.isValid(group, name, version)) {
            throw new RepositoryException("Unable to rename package. Illegal package name.");
        }
        JcrPackageDefinition def = pack.getDefinition();
        PackageId id = def.getId();
        PackageId newId = new PackageId(group == null ? id.getGroup() : group, name == null ? id.getName() : name, version == null ? id.getVersion() : Version.create(version));
        String dstPath = this.getInstallationPath(newId) + ".zip";
        if (id.equals(newId) && pack.getNode().getPath().equals(dstPath)) {
            log.debug("Package id not changed. won't rename.");
            return pack;
        }
        def.setId(newId, false);
        if (!pack.getNode().getPath().equals(dstPath)) {
            if (this.session.nodeExists(dstPath)) {
                throw new PackageException("Node at " + dstPath + " already exists.");
            }
            this.mkdir(Text.getRelativeParent(dstPath, 1), false);
            this.session.move(pack.getNode().getPath(), dstPath);
        }
        this.session.save();
        Node newNode = this.session.getNode(dstPath);
        this.dispatch(PackageEvent.Type.RENAME, id, new PackageId[]{newId});
        return this.open(newNode, false);
    }

    @Override
    @Nonnull
    public Set<PackageId> packages() throws IOException {
        try {
            TreeSet<PackageId> packages = new TreeSet<PackageId>();
            for (Node pRoot : this.getPackageRoots()) {
                this.listPackages(pRoot, packages);
            }
            return packages;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    private void listPackages(Node root, Set<PackageId> packages) throws RepositoryException {
        NodeIterator iter = root.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (".snapshot".equals(child.getName())) continue;
            JcrPackageImpl pack = new JcrPackageImpl(this, child);
            Throwable throwable = null;
            try {
                if (pack.isValid()) {
                    JcrPackageDefinition jDef = pack.getDefinition();
                    if (jDef == null || !jDef.getId().isValid()) continue;
                    packages.add(jDef.getId());
                    continue;
                }
                if (!child.hasNodes()) continue;
                this.listPackages(child, packages);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pack == null) continue;
                if (throwable != null) {
                    try {
                        pack.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pack.close();
            }
        }
    }

    public String getInstallationPath(PackageId id) {
        return this.packRootPaths[0] + this.getRelativeInstallationPath(id);
    }

    @Override
    public void installPackage(@Nonnull Session session, @Nonnull RegisteredPackage pkg, @Nonnull ImportOptions opts, boolean extract) throws IOException, PackageException {
        try (JcrPackage jcrPkg = ((JcrRegisteredPackage)pkg).getJcrPackage();){
            if (extract) {
                jcrPkg.extract(opts);
            } else {
                jcrPkg.install(opts);
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void uninstallPackage(@Nonnull Session session, @Nonnull RegisteredPackage pkg, @Nonnull ImportOptions opts) throws IOException, PackageException {
        try (JcrPackage jcrPkg = ((JcrRegisteredPackage)pkg).getJcrPackage();){
            jcrPkg.uninstall(opts);
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }
}

