/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public class Unbox {
    private static final int MASK = 15;
    private static ThreadLocal<State> threadLocalState = new ThreadLocal();

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(float value) {
        return Unbox.getSB().append(value);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(double value) {
        return Unbox.getSB().append(value);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(short value) {
        return Unbox.getSB().append(value);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(int value) {
        return Unbox.getSB().append(value);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(char value) {
        return Unbox.getSB().append(value);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(long value) {
        return Unbox.getSB().append(value);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(byte value) {
        return Unbox.getSB().append(value);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(boolean value) {
        return Unbox.getSB().append(value);
    }

    private static State getState() {
        State state = threadLocalState.get();
        if (state == null) {
            state = new State();
            threadLocalState.set(state);
        }
        return state;
    }

    private static StringBuilder getSB() {
        return Unbox.getState().getStringBuilder();
    }

    private static class State {
        private final StringBuilder[] ringBuffer = new StringBuilder[16];
        private int current;

        State() {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                this.ringBuffer[i] = new StringBuilder(21);
            }
        }

        public StringBuilder getStringBuilder() {
            StringBuilder result = this.ringBuffer[0xF & this.current++];
            result.setLength(0);
            return result;
        }

        public boolean isBoxedPrimitive(StringBuilder text) {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                if (text != this.ringBuffer[i]) continue;
                return true;
            }
            return false;
        }
    }
}

