/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.BanDistributionManagement;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.junit.Test;
import org.mockito.Mockito;

public class BanDistributionManagementTest {
    private MavenProject project;
    private EnforcerRuleHelper helper;

    @Test
    public void shouldNotFailWithoutDistributionManagement() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithoutDistributionManagement();
        rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldThrowExceptionIfDistributionManagementIsDefinedWithRepository() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithDistributionManagement(new DeploymentRepository(), null, null);
        rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldThrowExceptionIfDistributionManagementIsDefinedWithRepositorySnapshotRepository() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithDistributionManagement(new DeploymentRepository(), new DeploymentRepository(), null);
        rule.execute(this.helper);
    }

    @Test(expected=EnforcerRuleException.class)
    public void shouldThrowExceptionIfDistributionManagementIsDefinedWithRepositorySnapshotRepositorySite() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithDistributionManagement(new DeploymentRepository(), new DeploymentRepository(), new Site());
        rule.execute(this.helper);
    }

    @Test
    public void shouldAllowDistributionManagementHavingRepository() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithDistributionManagement(new DeploymentRepository(), null, null);
        rule.setAllowRepository(true);
        rule.execute(this.helper);
    }

    @Test
    public void shouldAllowDistributionManagementHavingRepositorySnapshotRepository() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithDistributionManagement(new DeploymentRepository(), new DeploymentRepository(), null);
        rule.setAllowRepository(true);
        rule.setAllowSnapshotRepository(true);
        rule.execute(this.helper);
    }

    @Test
    public void shouldAllowDistributionManagementHavingRepositorySnapshotRepositorySite() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithDistributionManagement(new DeploymentRepository(), new DeploymentRepository(), new Site());
        rule.setAllowRepository(true);
        rule.setAllowSnapshotRepository(true);
        rule.setAllowSite(true);
        rule.execute(this.helper);
    }

    @Test
    public void shouldThrowExceptionCauseParentProjectHasDistributionManagementSnapshotRepository() throws Exception {
        BanDistributionManagement rule = this.setupProjectWithParentDistributionManagement(null, new DeploymentRepository(), null);
        rule.setAllowSnapshotRepository(true);
        rule.execute(this.helper);
    }

    private BanDistributionManagement setupProjectWithParentDistributionManagement(DeploymentRepository repository, DeploymentRepository snapshotRepository, Site site) throws ExpressionEvaluationException {
        this.project = this.setupProject(null);
        DistributionManagement dmParent = (DistributionManagement)Mockito.mock(DistributionManagement.class);
        Mockito.when((Object)dmParent.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)dmParent.getSnapshotRepository()).thenReturn((Object)snapshotRepository);
        Mockito.when((Object)dmParent.getSite()).thenReturn((Object)site);
        MavenProject parentProject = (MavenProject)Mockito.mock(MavenProject.class);
        Model model = (Model)Mockito.mock(Model.class);
        Mockito.when((Object)model.getDistributionManagement()).thenReturn((Object)dmParent);
        Mockito.when((Object)parentProject.getOriginalModel()).thenReturn((Object)model);
        Mockito.when((Object)this.project.getParent()).thenReturn((Object)parentProject);
        BanDistributionManagement rule = this.setupEnforcerRule();
        return rule;
    }

    private BanDistributionManagement setupProjectWithoutDistributionManagement() throws ExpressionEvaluationException {
        this.project = this.setupProject(null);
        BanDistributionManagement rule = this.setupEnforcerRule();
        return rule;
    }

    private BanDistributionManagement setupProjectWithDistributionManagement(DeploymentRepository repository, DeploymentRepository snapshotRepository, Site site) throws ExpressionEvaluationException {
        DistributionManagement dm = (DistributionManagement)Mockito.mock(DistributionManagement.class);
        Mockito.when((Object)dm.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)dm.getSnapshotRepository()).thenReturn((Object)snapshotRepository);
        Mockito.when((Object)dm.getSite()).thenReturn((Object)site);
        this.project = this.setupProject(dm);
        Mockito.when((Object)this.project.getParent()).thenReturn(Mockito.mock(MavenProject.class));
        Mockito.when((Object)this.project.isExecutionRoot()).thenReturn((Object)true);
        BanDistributionManagement rule = this.setupEnforcerRule();
        return rule;
    }

    private MavenProject setupProject(DistributionManagement distributionManagement) {
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)project.getPackaging()).thenReturn((Object)"jar");
        Model mavenModel = (Model)Mockito.mock(Model.class);
        Mockito.when((Object)project.getOriginalModel()).thenReturn((Object)mavenModel);
        Mockito.when((Object)mavenModel.getDistributionManagement()).thenReturn((Object)distributionManagement);
        return project;
    }

    private BanDistributionManagement setupEnforcerRule() throws ExpressionEvaluationException {
        this.helper = (EnforcerRuleHelper)Mockito.mock(EnforcerRuleHelper.class);
        Mockito.when((Object)this.helper.evaluate("${project}")).thenReturn((Object)this.project);
        BanDistributionManagement rule = new BanDistributionManagement();
        Mockito.when((Object)this.helper.getLog()).thenReturn(Mockito.mock(Log.class));
        return rule;
    }
}

